/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.reports;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.SecurityCodes;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dss.shadelib.com.google.common.collect.ObjectArrays;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TemplatesDAO {
    private TemplateDef fromFile(File f) {
        TemplateDef tdef = new TemplateDef();
        tdef.fileName = f.getName();
        tdef.displayName = f.getName().replaceAll("\\.[a-z]*$", "");
        return tdef;
    }

    public List<TemplateDef> list(TemplateType templateType) {
        File user;
        ArrayList<TemplateDef> ret = new ArrayList<TemplateDef>();
        File builtin = ApplicationConfigurator.getResourceFile((String[])templateType.resourcePathChunks);
        if (builtin.isDirectory()) {
            for (File f : builtin.listFiles()) {
                if (!f.getName().endsWith(".ftl") && !f.getName().endsWith(".dtl")) continue;
                ret.add(this.fromFile(f));
            }
        }
        if ((user = ApplicationConfigurator.getFile((String[])((String[])ObjectArrays.concat((Object)"resources", (Object[])templateType.resourcePathChunks)))).isDirectory()) {
            for (File f : user.listFiles()) {
                if (!f.getName().endsWith(".ftl") && !f.getName().endsWith(".dtl")) continue;
                ret.add(this.fromFile(f));
            }
        }
        return ret;
    }

    public File get(String fileName, TemplateType templateType) throws IOException, DKUSecurityException {
        File builtin;
        File user;
        File userRoot = ApplicationConfigurator.getFile((String[])((String[])ObjectArrays.concat((Object)"resources", (Object[])templateType.resourcePathChunks)));
        if (!DKUFileUtils.isWithin((File)userRoot, (File)(user = ApplicationConfigurator.getFile((String[])((String[])ObjectArrays.concat((Object)"resources", (Object[])((String[])ObjectArrays.concat((Object[])templateType.resourcePathChunks, (Object)fileName)))))))) {
            throw new DKUSecurityException("Trying to access a file outside the templates directory").withCode((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_PATH_ESCAPE);
        }
        if (user.isFile()) {
            return user;
        }
        File builtinRoot = ApplicationConfigurator.getResourceFile((String[])templateType.resourcePathChunks);
        if (!DKUFileUtils.isWithin((File)builtinRoot, (File)(builtin = ApplicationConfigurator.getResourceFile((String[])((String[])ObjectArrays.concat((Object[])templateType.resourcePathChunks, (Object)fileName)))))) {
            throw new SecurityException("Illegal file access");
        }
        if (builtin.isFile()) {
            return builtin;
        }
        throw ErrorContext.iae((String)("Unknown template file " + fileName));
    }

    public static class TemplateDef {
        String fileName;
        String displayName;
    }

    public static enum TemplateType {
        SCENARIO("scenarios", "report-templates"),
        DIRECT_USAGE("integration", "direct-templates");

        private final String[] resourcePathChunks;

        private TemplateType(String ... resourcePathChunks) {
            this.resourcePathChunks = resourcePathChunks;
        }
    }
}

