/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.scenarios;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvPermissionsService;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.custom.IPluginifiedHolderMeta;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.integrations.AttachmentService;
import com.dataiku.dip.integrations.mail.MailIntegrationHandler;
import com.dataiku.dip.integrations.mail.MailIntegrationParams;
import com.dataiku.dip.recipes.ParamsWithSelectableCodeEnv;
import com.dataiku.dip.scheduler.TicketBasedCustomPythonRunner;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.reports.ScenarioReporter;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioMeta;
import com.dataiku.dip.scheduler.scenarios.ScenarioMetaWithSelectableCodeEnv;
import com.dataiku.dip.scheduler.scenarios.ScenarioParams;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunner;
import com.dataiku.dip.scheduler.triggers.Trigger;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.process.InsecureProcessesLaunchService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.services.ScenariosService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomPythonScenarioRunner
implements ScenarioRunner {
    public static final ScenarioMeta META = new ScenarioMetaWithSelectableCodeEnv(){

        @Override
        public String getType() {
            return "custom_python";
        }

        @Override
        public Class<? extends ScenarioParams> paramsClass() {
            return CustomPythonScenarioParams.class;
        }

        @Override
        public ScenarioRunner buildRunner(Scenario scenario) {
            return new CustomPythonScenarioRunner(scenario, scenario.getParamsAs(CustomPythonScenarioParams.class));
        }

        @Override
        public void checkSaveSecurity(Scenario scenario, Scenario oldScenario, CodeEnvPermissionsService permissionsService, AuthCtx authCtx) throws DKUSecurityException {
            authCtx.failIfNoSafeCode("save a code-based scenario");
            CustomPythonScenarioParams scenarioParams = scenario.getParamsAs(CustomPythonScenarioParams.class);
            CustomPythonScenarioParams oldScenarioParams = oldScenario == null ? null : oldScenario.getParamsAs(CustomPythonScenarioParams.class);
            permissionsService.failIfCodeEnvNotUsable(scenario.getProjectKey(), CodeEnvModel.EnvLang.PYTHON, scenarioParams, oldScenarioParams, authCtx);
        }

        @Override
        public Scenario prepareForSave(Scenario scenario) {
            return scenario;
        }

        @Override
        public CodeEnvModel.EnvLang getEnvLang() {
            return CodeEnvModel.EnvLang.PYTHON;
        }

        @Override
        public List<IPluginifiedHolderMeta.Pluginifiable> getPluginifiables(Object object, String payload) {
            ArrayList components = Lists.newArrayList();
            if (object instanceof Scenario) {
                Scenario scenario = (Scenario)object;
                for (Trigger trigger : scenario.getTriggers()) {
                    components.add(new IPluginifiedHolderMeta.Pluginifiable("trigger", trigger.getType(), trigger));
                }
                for (ScenarioReporter reporter : scenario.getReporters()) {
                    if (!MailIntegrationHandler.SCENARIO_META.getType().equals(reporter.messaging.type)) continue;
                    MailIntegrationParams.MailScenarioIntegrationParams params = (MailIntegrationParams.MailScenarioIntegrationParams)reporter.messaging.configuration;
                    for (AttachmentService.MailScenarioAttachment attachment : params.attachments) {
                        if (attachment.type != AttachmentService.AttachmentType.DATASET) continue;
                        AttachmentService.DatasetExportAttachment exportAttachment = (AttachmentService.DatasetExportAttachment)JSON.parse((String)JSON.json((Object)attachment.params), AttachmentService.DatasetExportAttachment.class);
                        PluginUsagesInspector.addExporterComponentToList(components, exportAttachment.exportParams);
                    }
                }
            }
            return components;
        }
    };
    private final Scenario scenario;
    private final CustomPythonScenarioParams params;
    @Autowired
    private ScenariosService scenariosService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private APITicketService apiTicketService;
    @Autowired
    private InsecureProcessesLaunchService insecureProcessesLaunchService;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.custompython");

    CustomPythonScenarioRunner(Scenario scenario, CustomPythonScenarioParams params) {
        this.scenario = scenario;
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(ScenarioRun scenarioRun) throws Exception {
        String code;
        logger.info((Object)("Start scenario " + this.scenario.getName()));
        try (Transaction t = this.transactionService.beginRead();){
            code = this.scenariosService.getPayload(this.scenario.getProjectKey(), this.scenario.getId(), "py");
        }
        File runFolder = ScenarioRunContext.scenarioRunFolder(this.scenario.getProjectKey(), this.scenario.getId(), scenarioRun.getRunId());
        File pythonRunFolder = new File(runFolder, "custom-scenario");
        DKUFileUtils.mkdirs((File)pythonRunFolder);
        TicketBasedCustomPythonRunner pythonRunner = new TicketBasedCustomPythonRunner(this.apiTicketService, this.insecureProcessesLaunchService, "python_scenario:" + this.scenario.getProjectKey() + "." + this.scenario.getId(), scenarioRun.getRunAsUser(), pythonRunFolder, scenarioRun, false);
        HashMap extraEnv = Maps.newHashMap();
        HashMap fileBasedEnv = Maps.newHashMap();
        extraEnv.put("DKU_CURRENT_PROJECT_KEY", scenarioRun.getScenario().getProjectKey());
        if (scenarioRun.getTrigger() != null) {
            fileBasedEnv.put("DKU_CURRENT_SCENARIO_TRIGGER_FILE", JSON.json((Object)scenarioRun.getTrigger()));
        }
        ReportItem.ScenarioDone reportItem = new ReportItem.ScenarioDone(new ReportTargetItem.ScenarioItem(scenarioRun)).withLogin(scenarioRun.getRunAsUser().getIdentifier());
        try (FutureProgress.AutocloseableFutureProgressState state = FutureProgress.pushAutoCloseableState((String)"Running script");){
            pythonRunner.run(code, extraEnv, fileBasedEnv, this.scenario.getProjectKey(), null, this.params.envSelection, reportItem, GeneralSettingsDAO.CGrouppableProcessType.PYTHON_SCENARIO);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            scenarioRun.withResult(reportItem.withOutcome(ReportItem.Outcome.ABORTED));
        }
        finally {
            scenarioRun.withResult(reportItem);
        }
        logger.info((Object)("Done scenario " + this.scenario.name));
    }

    public static class CustomPythonScenarioParams
    implements ScenarioParams,
    ParamsWithSelectableCodeEnv {
        public CodeEnvSelection envSelection = new CodeEnvSelection();

        @Override
        public CodeEnvSelection getCodeEnvSelection() {
            return this.envSelection;
        }

        @Override
        public void setCodeEnvSelection(CodeEnvSelection envSelection) {
            this.envSelection = envSelection;
        }

        @Override
        public List<CodeEnvModel.CodeEnvUsage> collectCodeEnvUsage(TaggableObjectsService.TaggableObject object) {
            ArrayList usages = Lists.newArrayList();
            if (this.envSelection.envMode == CodeEnvSelection.EnvMode.EXPLICIT_ENV) {
                usages.add(new CodeEnvModel.CodeEnvUsage(CodeEnvModel.EnvLang.PYTHON, this.envSelection.envName, CodeEnvModel.EnvUsage.SCENARIO, object.getProjectKey(), object.getId()));
            }
            return usages;
        }
    }
}

