/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.triggers;

import com.dataiku.dip.scheduler.triggers.GraceDelaySettings;
import com.dataiku.dip.scheduler.triggers.TriggerParams;
import com.dataiku.dip.scheduler.triggers.TriggerRegistry;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;

public class Trigger {
    public String id;
    public String type;
    public String name;
    public String description;
    public int delay;
    public boolean active;
    public GraceDelaySettings graceDelaySettings;
    public TriggerParams params;

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getDelay() {
        return this.delay;
    }

    public GraceDelaySettings getGraceDelaySettings() {
        if (this.graceDelaySettings == null) {
            return new GraceDelaySettings(Math.max(1, this.getDelay()) / 2, false);
        }
        return this.graceDelaySettings;
    }

    public boolean isActive() {
        return this.active;
    }

    public TriggerParams getParams() {
        return this.params;
    }

    public <T extends TriggerParams> T getParamsAs(Class<T> clazz) {
        return (T)((TriggerParams)clazz.cast(this.params));
    }

    public Trigger withId(String id) {
        this.id = id;
        return this;
    }

    public Trigger withType(String type) {
        this.type = type;
        return this;
    }

    public Trigger withName(String name) {
        this.name = name;
        return this;
    }

    public Trigger withDescription(String description) {
        this.description = description;
        return this;
    }

    public Trigger withDelay(int delay) {
        this.delay = delay;
        return this;
    }

    public Trigger withGraceDelaySettings(GraceDelaySettings graceDelaySettings) {
        this.graceDelaySettings = graceDelaySettings;
        return this;
    }

    public Trigger withActive(boolean active) {
        this.active = active;
        return this;
    }

    public Trigger withParams(TriggerParams params) {
        this.params = params;
        return this;
    }

    public void notifyUpdate() {
        this.params.notifyUpdate();
    }

    public static void registerAdapter() {
        JSON.registerAdapter(Trigger.class, (Object)new JSON.Adapter<Trigger>(){

            public Trigger deserialize(JsonElement json, Type type, JsonDeserializationContext ctx) throws JsonParseException {
                JsonElement jsonGraceDelaySettings;
                JsonElement jsonParams;
                JsonElement jsonActive;
                JsonElement jsonDelay;
                JsonElement jsonDescription;
                JsonObject jsonObj = json.getAsJsonObject();
                Trigger trigger = new Trigger();
                JsonElement jsonId = jsonObj.get("id");
                if (jsonId != null && !jsonId.isJsonNull()) {
                    trigger = trigger.withId(jsonId.getAsString());
                }
                trigger = trigger.withType(jsonObj.get("type").getAsString());
                JsonElement jsonName = jsonObj.get("name");
                if (jsonName != null && !jsonName.isJsonNull()) {
                    trigger = trigger.withName(jsonName.getAsString());
                }
                if ((jsonDescription = jsonObj.get("description")) != null && !jsonDescription.isJsonNull()) {
                    trigger = trigger.withDescription(jsonDescription.getAsString());
                }
                if ((jsonDelay = jsonObj.get("delay")) != null) {
                    trigger = trigger.withDelay(jsonDelay.getAsInt());
                }
                if ((jsonActive = jsonObj.get("active")) != null) {
                    trigger = trigger.withActive(jsonActive.getAsBoolean());
                }
                if ((jsonParams = jsonObj.get("params")) != null) {
                    trigger = trigger.withParams((TriggerParams)ctx.deserialize(jsonParams, TriggerRegistry.getMeta(trigger).paramsClass()));
                }
                if ((jsonGraceDelaySettings = jsonObj.get("graceDelaySettings")) != null) {
                    trigger = trigger.withGraceDelaySettings((GraceDelaySettings)ctx.deserialize(jsonGraceDelaySettings, GraceDelaySettings.class));
                }
                return trigger;
            }

            public JsonElement serialize(Trigger trigger, Type type, JsonSerializationContext ctx) {
                JsonObject jsonObj = new JsonObject();
                jsonObj.addProperty("id", trigger.getId());
                jsonObj.addProperty("type", trigger.getType());
                jsonObj.addProperty("name", trigger.getName());
                jsonObj.addProperty("delay", (Number)trigger.getDelay());
                jsonObj.addProperty("description", trigger.getDescription());
                jsonObj.addProperty("active", Boolean.valueOf(trigger.isActive()));
                if (trigger.getParams() != null) {
                    jsonObj.add("params", ctx.serialize((Object)trigger.getParams(), TriggerRegistry.getMeta(trigger).paramsClass()));
                }
                if (trigger.graceDelaySettings != null) {
                    jsonObj.add("graceDelaySettings", ctx.serialize((Object)trigger.getGraceDelaySettings(), GraceDelaySettings.class));
                }
                return jsonObj;
            }
        });
    }
}

