/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.activity.ProjectActivitySummaryBuilder;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.projects.ProjectCodes;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ProjectActivityDashboardController
extends DIPInternalControllerBase {
    private static Logger logger = Logger.getLogger((String)"dip.controllers.projects");
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TransactionService transactionService;

    @AuditedCall(value={"msgType", "project-read-meta", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/activity/get-summary"})
    public void getProjectActivitySummary(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String timeSpan) throws Exception {
        int _timeSpan = 1;
        switch (timeSpan.trim().toLowerCase()) {
            case "week": {
                _timeSpan = 3;
                break;
            }
            case "month": {
                _timeSpan = 2;
                break;
            }
            case "year": {
                break;
            }
            case "all": {
                _timeSpan = 0;
                break;
            }
            default: {
                logger.warn((Object)("Unkown time span: " + timeSpan));
            }
        }
        try (Transaction t = this.transactionService.beginRead();){
            if (!this.projectsService.projectExists(projectKey)) {
                throw new CodedException((InfoMessage.MessageCode)ProjectCodes.ERR_PROJECT_UNKNOWN_PROJECT_KEY, String.format("Unknown project key %s. It may have been deleted.", projectKey));
            }
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        ProjectActivitySummaryBuilder.ProjectActivitySummary pas = this.projectsService.updateAndGetProjectActivitySummary(projectKey, _timeSpan, 1, false);
        ProjectActivityDashboardController.writeJSON((HttpServletResponse)resp, (Object)pas);
    }
}

