/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.license.License;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.ConfigurationController;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.RegistrationService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.utils.JSON;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class RegistrationController
extends DIPInternalControllerBase {
    @Autowired
    private RegistrationService registerService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private LicenseStatusService licenseService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ConfigurationController configurationController;

    @AuditedCall(value={"msgType", "dss-register-initial"})
    @RequestMapping(value={"/api/registration/initial-register-community"})
    public void initialRegister(HttpServletRequest req, HttpServletResponse resp, @RequestParam String userFirstName, @RequestParam String userLastName, @RequestParam String userEmail, @RequestParam String instanceId, @RequestParam String license) throws Exception {
        this.configurationController.verifyPreRegistrationAuth(req, resp);
        try (RWTransaction rw = this.transactionService.beginWriteAsDSS();){
            License lic = (License)JSON.parse((String)license, License.class);
            RegistrationController.writeJSON((HttpServletResponse)resp, (Object)this.registerService.initialRegisterCommunity(userFirstName, userLastName, userEmail, instanceId, lic));
            rw.commit("Installed license");
        }
    }

    @AuditedCall(value={"msgType", "dss-register-license"})
    @RequestMapping(value={"/api/registration/post-initial-register-licensed"})
    public void postInitialRegisterLicensed(HttpServletRequest req, HttpServletResponse resp, @RequestParam String license) throws Exception {
        this.configurationController.verifyPreRegistrationAuth(req, resp);
        try (RWTransaction rw = this.transactionService.beginWriteAsDSS();){
            License lic = (License)JSON.parse((String)RegistrationService.parseLicense(license), License.class);
            RegistrationController.writeJSON((HttpServletResponse)resp, (Object)this.registerService.postInitialRegisterLicensed(lic));
            rw.commit("Installed license");
        }
        catch (Exception e) {
            RegistrationController.callFailed((Throwable)e, (HttpServletRequest)req, (HttpServletResponse)resp);
        }
    }

    @AuditedCall(value={"msgType", "dss-license-update"})
    @RequestMapping(value={"/api/registration/set-offline-license"})
    public void setOfflineLicense(HttpServletRequest req, HttpServletResponse resp, @RequestParam String license) {
        try (RWTransaction rw = this.transactionService.beginWriteForUI(req);){
            this.authService.failIfNotAdmin(req);
            License lic = (License)JSON.parse((String)RegistrationService.parseLicense(license), License.class);
            this.registerService.setOfflineLicense(lic);
            rw.commit("Installed license");
        }
        catch (Exception e) {
            RegistrationController.callFailed((Throwable)e, (HttpServletRequest)req, (HttpServletResponse)resp);
        }
    }

    @AuditedCall(value={"msgType", "dss-license-renew"})
    @RequestMapping(value={"/api/registration/renew-expired-license"})
    public void renewExpiredLicense(HttpServletRequest req, HttpServletResponse resp, @RequestParam String license) {
        try (RWTransaction rw = this.transactionService.beginWriteAsDSS();){
            LicenseStatusService.LicensingStatus ls = this.licenseService.getLicensingStatus();
            if (ls.valid) {
                throw new SecurityException("Your license is not expired !");
            }
            License lic = (License)JSON.parse((String)RegistrationService.parseLicense(license), License.class);
            this.registerService.setOfflineLicense(lic);
            rw.commit("Installed license");
        }
        catch (Exception e) {
            RegistrationController.callFailed((Throwable)e, (HttpServletRequest)req, (HttpServletResponse)resp);
        }
    }
}

