/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers.labeling;

import com.dataiku.dip.datasets.labeling.LabelsDatasetParams;
import com.dataiku.dip.labeling.AnnotationService;
import com.dataiku.dip.labeling.LabelingAnswer;
import com.dataiku.dip.labeling.LabelingInternalDBService;
import com.dataiku.dip.labeling.LabelingPermissionsService;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.LabelingTasksDAO;
import com.dataiku.dip.labeling.LocalLabelingAnswerCRUDService;
import com.dataiku.dip.labeling.ReviewRecordInfo;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
public class LabelingAnswersController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private LabelingInternalDBService labelingInternalDBService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private AnnotationService annotationService;
    @Autowired
    private LabelingTasksDAO labelingTasksDAO;
    @Autowired
    private LocalLabelingAnswerCRUDService labelingAnswerCRUDService;
    @Autowired
    private LabelingPermissionsService labelingPermissionsService;

    @AuditedCall(value={"msgType", "labeling-answers-save", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/labelinganswers/save"}, method={RequestMethod.POST})
    @ResponseBody
    public LabelingAnswer saveAnswer(HttpServletRequest req, @RequestParam String projectKey, @RequestParam LabelingAnswer labelingAnswer) throws Exception {
        boolean canReview;
        LabelingTask labelingTask;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            labelingTask = (LabelingTask)this.labelingTasksDAO.getMandatory(projectKey, labelingAnswer.labelingTaskId);
            this.labelingPermissionsService.checkPerm(authCtx, labelingTask, Privileges.LabelingLevelPrivilegeType.ANNOTATE);
            canReview = this.labelingPermissionsService.canReview(authCtx, labelingTask);
        }
        return this.labelingAnswerCRUDService.upsertLabelingAnswer(labelingAnswer, labelingTask, authCtx, canReview);
    }

    @AuditedCall(value={"msgType", "labeling-answers-get-annotation-from-annotator", "projectKey", "${projectKey}", "labelingTaskId", "${labelingTaskId}", "path", "${path}"})
    @RequestMapping(value={"/api/labelinganswers/get-annotation-from-annotator"}, method={RequestMethod.GET})
    @ResponseBody
    public LabelingAnswer getAnnotationFromAnnotator(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String labelingTaskId, @RequestParam String recordId) throws Exception {
        LabelingTask labelingTask;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            labelingTask = (LabelingTask)this.labelingTasksDAO.getMandatory(projectKey, labelingTaskId);
            this.labelingPermissionsService.checkPerm(authCtx, labelingTask, Privileges.LabelingLevelPrivilegeType.ANNOTATE);
        }
        return this.labelingInternalDBService.getAnnotationForPathFromAnnotator(authCtx, labelingTask, recordId);
    }

    @AuditedCall(value={"msgType", "labeling-answers-delete-annotations-from-record", "projectKey", "${projectKey}", "labelingTaskId", "${labelingTaskId}", "recordId", "${recordId}"})
    @RequestMapping(value={"/api/labelinganswers/delete-annotations-from-record"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteAnnotationsFromRecord(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String labelingTaskId, @RequestParam String recordId) throws Exception {
        LabelingTask labelingTask;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            labelingTask = (LabelingTask)this.labelingTasksDAO.getMandatory(projectKey, labelingTaskId);
            this.labelingPermissionsService.checkPerm(authCtx, labelingTask, Privileges.LabelingLevelPrivilegeType.REVIEW);
        }
        this.labelingInternalDBService.deleteAllAnswersForRecord(labelingTask, recordId);
    }

    @AuditedCall(value={"msgType", "labeling-answers-list-not-reviewed", "projectKey", "${projectKey}", "labelingTaskId", "${labelingTaskId}", "path", "${path}"})
    @RequestMapping(value={"/api/labelinganswers/list-not-reviewed"}, method={RequestMethod.GET})
    @ResponseBody
    public List<LabelingAnswer> listNotReviewed(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String labelingTaskId, @RequestParam String recordId) throws Exception {
        LabelingTask labelingTask;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            labelingTask = (LabelingTask)this.labelingTasksDAO.getMandatory(projectKey, labelingTaskId);
            this.labelingPermissionsService.checkPerm(authCtx, labelingTask, Privileges.LabelingLevelPrivilegeType.REVIEW);
        }
        return this.labelingInternalDBService.listNotReviewed(authCtx, labelingTask, recordId);
    }

    @AuditedCall(value={"msgType", "labelingtasks-list-review-record-info", "projectKey", "${projectKey}", "labelingTaskId", "${labelingTaskId}"})
    @RequestMapping(value={"/api/labelinganswers/list-review-record-info"}, method={RequestMethod.POST})
    @ResponseBody
    public List<ReviewRecordInfo> listReviewRecordInfo(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String labelingTaskId, @RequestParam List<String> recordIds) throws Exception {
        LabelingTask labelingTask;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            labelingTask = (LabelingTask)this.labelingTasksDAO.getMandatory(projectKey, labelingTaskId);
            this.labelingPermissionsService.checkPerm(authCtx, labelingTask, Privileges.LabelingLevelPrivilegeType.REVIEW);
        }
        return this.annotationService.listReviewRecordInfo(authCtx, labelingTask, recordIds);
    }

    @AuditedCall(value={"msgType", "labeling-answers-count", "projectKey", "${projectKey}", "labelingTaskId", "${labelingTaskId}", "path", "${path}"})
    @RequestMapping(value={"/api/labelinganswers/count"}, method={RequestMethod.GET})
    @ResponseBody
    public LabelingAnswersCount listNotReviewed(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String labelingTaskId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            LabelingTask labelingTask = (LabelingTask)this.labelingTasksDAO.getMandatory(projectKey, labelingTaskId);
            this.labelingPermissionsService.checkPerm(authCtx, labelingTask, Privileges.LabelingLevelPrivilegeType.REVIEW);
        }
        return new LabelingAnswersCount(this.labelingAnswerCRUDService.countAnswers(authCtx, projectKey, labelingTaskId, LabelsDatasetParams.View.ALL));
    }

    private static class LabelingAnswersCount {
        long allAnswersCount;

        public LabelingAnswersCount(long allAnswersCount) {
            this.allAnswersCount = allAnswersCount;
        }
    }
}

