/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.datasets;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.maintainance.CleanS3AInstrumentationsTask;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.TestFlag;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DatasetAccessService {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @VisibleForTesting
    public static final TestFlag skipInstallS3ACleaner = new TestFlag();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.datasets");

    @PostConstruct
    public void installS3ACleaner() {
        if (skipInstallS3ACleaner.isActivated()) {
            return;
        }
        CleanS3AInstrumentationsTask.startCleanupThreadIfNeeded();
    }

    public List<Dataset> list(String projectKey) throws IOException {
        ArrayList<Dataset> out = new ArrayList<Dataset>();
        for (SerializedDataset sd : this.datasetsDAO.list(projectKey)) {
            try {
                out.add(Dataset.fromSerialized(sd));
            }
            catch (Exception e) {
                logger.warn((Object)("Error reading dataset:" + sd.getFullName()), (Throwable)e);
            }
        }
        return out;
    }

    public List<Dataset> listUnsafe(String projectKey) throws IOException {
        ArrayList<Dataset> out = new ArrayList<Dataset>();
        for (SerializedDataset sd : this.datasetsDAO.listUnsafe(projectKey)) {
            try {
                out.add(Dataset.fromSerializedUnsafe(sd));
            }
            catch (Exception e) {
                logger.warn((Object)("Error reading dataset:" + sd.getFullName()), (Throwable)e);
            }
        }
        return out;
    }

    public Dataset getOrNull(String projectKey, String name) throws IOException {
        return this.get(projectKey, name, false, false);
    }

    public Dataset getOrNullUnsafe(String projectKey, String name) throws IOException {
        return this.get(projectKey, name, false, true);
    }

    public Dataset getMandatory(String projectKey, String name) throws IOException {
        return this.get(projectKey, name, true, false);
    }

    public Dataset getMandatoryUnsafe(String projectKey, String name) throws IOException {
        return this.get(projectKey, name, true, true);
    }

    public Dataset getMandatoryFromRef(String contextProjectKey, String ref) throws IOException {
        AnyLoc loc = AnyLoc.resolveSmart(contextProjectKey, ref);
        return this.get(loc.getProjectKey(), loc.getId(), true, false);
    }

    public Dataset getMandatoryUnsafeFromRef(String contextProjectKey, String ref) throws IOException {
        AnyLoc loc = AnyLoc.resolveSmart(contextProjectKey, ref);
        return this.get(loc.getProjectKey(), loc.getId(), true, true);
    }

    private Dataset get(String projectKey, String name, boolean mandatory, boolean unsafe) throws IOException {
        SerializedDataset sds = mandatory ? (unsafe ? (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(projectKey, name) : (SerializedDataset)this.datasetsDAO.getMandatory(projectKey, name)) : (unsafe ? (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(projectKey, name) : (SerializedDataset)this.datasetsDAO.getOrNull(projectKey, name));
        if (sds == null) {
            return null;
        }
        if (unsafe) {
            return Dataset.fromSerializedUnsafe(sds);
        }
        return Dataset.fromSerialized(sds);
    }

    public Dataset getOrNull(AnyLoc loc) throws IOException {
        return this.getOrNull(loc.getProjectKey(), loc.getId());
    }

    public Dataset getOrNullUnsafe(AnyLoc loc) throws IOException {
        return this.getOrNullUnsafe(loc.getProjectKey(), loc.getId());
    }

    public Dataset getMandatory(AnyLoc loc) throws IOException {
        return this.getMandatory(loc.getProjectKey(), loc.getId());
    }

    public Dataset getMandatoryUnsafe(AnyLoc loc) throws IOException {
        return this.getMandatoryUnsafe(loc.getProjectKey(), loc.getId());
    }
}

