/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.datasets.renaming.code.r;

import com.dataiku.dip.server.datasets.renaming.code.RegexParser;
import java.util.Formatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class DatasetReadWriteParser
implements RegexParser {
    private final Pattern readPattern;
    private final Pattern writePattern;
    private final String replacement;
    private Matcher readMatcher;
    private Matcher writeMatcher;
    private boolean readMatch;
    private int count;

    public DatasetReadWriteParser(String datasetNameRegex, String replacement) {
        String regex;
        this.replacement = replacement;
        try (Formatter regexFormatter = new Formatter();){
            regex = regexFormatter.format("^((?:dkuReadDataset\\s*+\\(|dkuSparkReadDataset\\s*+\\((?:\\s*+[^,\\)]++,)?|spark_read_dku_dataset\\s*+\\(\\s*+[^,]++,)\\s*+)(?:\"%1$s\"|'%1$s')([^\\)]*+\\))", datasetNameRegex).toString();
            this.readPattern = Pattern.compile(regex);
        }
        regexFormatter = new Formatter();
        try {
            regex = regexFormatter.format("^((?:dkuWriteDataset|dkuSparkWriteDataset|spark_write_dku_dataset)\\s*+\\([^,]++,\\s*+)(?:\"%1$s\"|'%1$s')(\\s*+\\))", datasetNameRegex).toString();
            this.writePattern = Pattern.compile(regex);
        }
        finally {
            regexFormatter.close();
        }
    }

    @Override
    public boolean matches(String input) {
        this.readMatcher = this.readPattern.matcher(input);
        this.readMatch = this.readMatcher.find();
        if (this.readMatch) {
            ++this.count;
            return true;
        }
        this.writeMatcher = this.writePattern.matcher(input);
        if (this.writeMatcher.find()) {
            ++this.count;
            return true;
        }
        return false;
    }

    @Override
    public String getMatch() {
        if (this.readMatch) {
            return this.readMatcher.group(0);
        }
        return this.writeMatcher.group(0);
    }

    @Override
    public String getReplacement() {
        if (this.readMatch) {
            return this.readPattern.matcher(this.readMatcher.group(0)).replaceFirst(this.replacement);
        }
        return this.writePattern.matcher(this.writeMatcher.group(0)).replaceFirst(this.replacement);
    }

    @Override
    public int datasetReferences() {
        return this.count;
    }
}

