/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.emails;

import com.dataiku.dip.requestcenter.Request;
import com.dataiku.dip.requestcenter.RequestsService;
import com.dataiku.dip.server.notifications.emails.CodeEnvRequestEmailBuilder;
import com.dataiku.dip.server.notifications.emails.CodeEnvRequestGrantedEmailBuilder;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CodeEnvRequestEmailSendService {
    @Autowired
    public TransactionService transactionService;
    @Autowired
    private PubSubService pubSubService;
    @Autowired
    private UserSettingsService userSettingsService;
    @Autowired
    private RequestsService requestsService;
    private static final Logger logger = Logger.getLogger((String)"dku.notifications.email.codeenvRequestEmailService");

    @PostConstruct
    public void init() {
        logger.debug((Object)"Init Code Env request email service");
        this.subscribeToCodeEnvRequestEvent();
        this.subscribeToCodeEnvRequestGrantedEvent();
    }

    private void subscribeToCodeEnvRequestEvent() {
        this.pubSubService.subscribe("code-env-request", evt -> {
            List<String> destinationUsers = this.requestsService.getRequestTargets_NT(Request.RequestType.INSTALL_CODE_ENV, Request.RequestObjectType.CODE_ENV, evt.getObjectId());
            for (String destinationEmail : destinationUsers) {
                UserSettingsService.UserSettings userSettings;
                try (Transaction ignored = this.transactionService.beginRead();){
                    userSettings = this.userSettingsService.getForUser(destinationEmail);
                }
                try {
                    if (userSettings == null || !userSettings.codeEnvCreationRequestEmails.enabled) continue;
                    CodeEnvRequestEmailBuilder emailBuilder = new CodeEnvRequestEmailBuilder();
                    emailBuilder.sendToUser(evt, destinationEmail);
                }
                catch (Exception exception) {
                    logger.error((Object)("Failed to send email to user " + destinationEmail + " for code env request " + evt.getObjectId()), (Throwable)exception);
                }
            }
        });
    }

    private void subscribeToCodeEnvRequestGrantedEvent() {
        this.pubSubService.subscribe("code-env-request-granted", evt -> {
            UserSettingsService.UserSettings userSettings;
            String requesterEmail = evt.getUserLogin();
            try (Transaction ignored = this.transactionService.beginRead();){
                userSettings = this.userSettingsService.getForUser(requesterEmail);
            }
            try {
                if (userSettings != null && userSettings.grantedCodeEnvCreationRequestEmails.enabled) {
                    CodeEnvRequestGrantedEmailBuilder emailBuilder = new CodeEnvRequestGrantedEmailBuilder();
                    emailBuilder.sendToUser(evt, requesterEmail);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Failed to send email to user " + requesterEmail + " for granted code env request " + evt.getObjectId()), (Throwable)e);
            }
        });
    }
}

