/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.openapi;

import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.openapi.OpenAPIHelper;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.io.swagger.models.Swagger;
import com.dataiku.dss.shadelib.io.swagger.util.Json;
import com.dataiku.lambda.model.studioconfig.DSSLambdaEndpointConfig;
import com.dataiku.lambda.model.studioconfig.DSSPredictionEndpointConfig;
import com.dataiku.lambda.model.studioconfig.LambdaService;
import com.dataiku.lambda.model.studioconfig.OpenAPIDoc;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OpenAPIService {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    public static final String OPENAPIDOC_FILENAME = "swagger.json";
    private static DKULogger logger = DKULogger.getLogger((String)"dku.openapi");

    public void addDefaultOpenAPIDocToEndpoint(DSSLambdaEndpointConfig endpointObj, SavedModel savedModel) throws IOException {
        endpointObj.openAPI = this.generateEndpointOpenAPIDoc(endpointObj, savedModel, false, !OpenAPIHelper.endpointTypeSupportAutomatedMode(endpointObj.type));
        logger.infoV("Create default OpenAPI Doc for Endpoint %s", new Object[]{endpointObj.id});
    }

    public void updateServiceEndpointsAutomatedOpenAPIDoc(HttpServletRequest req, String projectKey, LambdaService serviceObj) throws IOException, DKUSecurityException {
        for (DSSLambdaEndpointConfig epc : serviceObj.endpoints) {
            if (epc.openAPI != null && epc.openAPI.isManual) continue;
            SavedModel savedModel = this.getSavedModelFromEndpointForOpenAPIDocGenerationOrNull_Check(req, projectKey, epc);
            if (epc.openAPI == null) {
                this.addDefaultOpenAPIDocToEndpoint(epc, savedModel);
                continue;
            }
            epc.openAPI = this.generateEndpointOpenAPIDoc(epc, savedModel, epc.openAPI.enabled, false);
            logger.infoV("Updated OpenAPI doc for Service %s Endpoint %s", new Object[]{serviceObj.id, epc.id});
        }
    }

    @Nullable
    public SavedModel getSavedModelFromEndpointForOpenAPIDocGenerationOrNull_Check(HttpServletRequest req, String projectKey, DSSLambdaEndpointConfig endpointObj) throws IOException, DKUSecurityException {
        SavedModel savedModel = null;
        switch (endpointObj.type) {
            case STD_PREDICTION: {
                String modelRef = ((DSSPredictionEndpointConfig)endpointObj).modelRef;
                if (!StringUtils.isNotBlank((String)modelRef)) break;
                AnyLoc modelLoc = AnyLoc.resolveSmart(projectKey, modelRef);
                this.projectsService.checkPerm(req, modelLoc.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
                savedModel = (SavedModel)this.savedModelsDAO.getOrNullUnsafe(modelLoc);
            }
        }
        if (savedModel == null) {
            logger.debugV("No Saved Model compatible with automatic generation of OpenAPI doc found in Endpoint %s.", new Object[]{endpointObj.id});
        }
        return savedModel;
    }

    public String generateServiceOpenAPIDocContent(String serviceId, String version, String desc, List<OpenAPIDoc> serviceEndpointOADs) {
        Swagger swagger = new Swagger();
        OpenAPIHelper.enrichSwaggerWithInfo(swagger, serviceId, version, desc);
        OpenAPIHelper.enrichServiceSwaggerWithEndpointsOpenAPIDoc(swagger, serviceEndpointOADs);
        return Json.pretty((Object)swagger);
    }

    public OpenAPIDoc generateEndpointOpenAPIDoc(DSSLambdaEndpointConfig endpointConfig, SavedModel sm, boolean enabled, boolean isManual) throws IOException {
        Swagger swagger = new Swagger();
        swagger.setSwagger(null);
        Map<String, String> refMap = OpenAPIHelper.enrichSwaggerWithDefinitionsAndGetReferenceMap(swagger, endpointConfig, sm, isManual);
        OpenAPIHelper.enrichSwaggerWithPath(swagger, endpointConfig, refMap);
        return new OpenAPIDoc(endpointConfig.id, Json.pretty((Object)swagger), enabled, isManual, endpointConfig.openAPI != null ? endpointConfig.openAPI.description : "");
    }
}

