/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.plugins.dev.DevPluginsService;
import com.dataiku.dip.recipes.code.scala.CodeMode;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class CustomRecipesController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private DevPluginsService devPluginsService;

    @AuditedCall(value={"msgType", "recipe-add-to-plugin", "pluginId", "${targetPluginId}", "recipeType", "spark-scala"})
    @RequestMapping(value={"/api/flow/recipes/scala/convert-to-custom"})
    public void convertScalaToCustom(HttpServletRequest req, HttpServletResponse resp, @RequestParam String targetPluginId, @RequestParam String targetPluginMode, @RequestParam String recipeFolder, @RequestParam String scriptData, @RequestParam String codeMode) throws Exception {
        AuthCtx liu;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
        }
        CodeMode codeMode2 = StringUtils.isBlank((String)codeMode) ? CodeMode.FREE_FORM : CodeMode.valueOf(codeMode);
        DevPluginsService.TargetPluginMode tpm = StringUtils.isBlank((String)targetPluginMode) ? DevPluginsService.TargetPluginMode.EXISTING : DevPluginsService.TargetPluginMode.valueOf(targetPluginMode);
        DevPluginsService.RecipeConversionResult ret = this.devPluginsService.addCustomRecipeFromSparkScala(targetPluginId, tpm, scriptData, recipeFolder, codeMode2, liu);
        CustomRecipesController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "recipe-add-to-plugin", "pluginId", "${targetPluginId}", "recipeType", "python"})
    @RequestMapping(value={"/api/flow/recipes/python/convert-to-custom"})
    public void convertPythonToCustom(HttpServletRequest req, HttpServletResponse resp, @RequestParam String targetPluginId, @RequestParam String targetPluginMode, @RequestParam String recipeData, @RequestParam String scriptData, @RequestParam String recipeFolder) throws Exception {
        AuthCtx liu;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
        }
        SerializedRecipe sa = (SerializedRecipe)JSON.parse((String)recipeData, SerializedRecipe.class);
        DevPluginsService.TargetPluginMode tpm = StringUtils.isBlank((String)targetPluginMode) ? DevPluginsService.TargetPluginMode.EXISTING : DevPluginsService.TargetPluginMode.valueOf(targetPluginMode);
        DevPluginsService.RecipeConversionResult ret = this.devPluginsService.addCustomRecipeFromPython(targetPluginId, tpm, scriptData, recipeFolder, liu);
        CustomRecipesController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "recipe-add-to-plugin", "pluginId", "${targetPluginId}", "recipeType", "r"})
    @RequestMapping(value={"/api/flow/recipes/r/convert-to-custom"})
    public void convertRToCustom(HttpServletRequest req, HttpServletResponse resp, @RequestParam String targetPluginId, @RequestParam String targetPluginMode, @RequestParam String recipeFolder, @RequestParam String scriptData) throws Exception {
        AuthCtx liu;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
        }
        DevPluginsService.TargetPluginMode tpm = StringUtils.isBlank((String)targetPluginMode) ? DevPluginsService.TargetPluginMode.EXISTING : DevPluginsService.TargetPluginMode.valueOf(targetPluginMode);
        DevPluginsService.RecipeConversionResult ret = this.devPluginsService.addCustomRecipeFromR(targetPluginId, tpm, scriptData, recipeFolder, liu);
        CustomRecipesController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "recipe-add-to-plugin", "pluginId", "${targetPluginId}", "recipeType", "pyspark"})
    @RequestMapping(value={"/api/flow/recipes/pyspark/convert-to-custom"})
    public void convertPysparkToCustom(HttpServletRequest req, HttpServletResponse resp, @RequestParam String targetPluginId, @RequestParam String targetPluginMode, @RequestParam String recipeFolder, @RequestParam String scriptData) throws Exception {
        AuthCtx liu;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
        }
        DevPluginsService.TargetPluginMode tpm = StringUtils.isBlank((String)targetPluginMode) ? DevPluginsService.TargetPluginMode.EXISTING : DevPluginsService.TargetPluginMode.valueOf(targetPluginMode);
        DevPluginsService.RecipeConversionResult ret = this.devPluginsService.addCustomRecipeFromPyspark(targetPluginId, tpm, scriptData, recipeFolder, liu);
        CustomRecipesController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }
}

