/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.QueryGenerationUtils;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipePayloadParams;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.expressions.GrelToQueryMapping;
import com.dataiku.dip.expressions.GrelToQueryTranslator;
import com.dataiku.dip.expressions.GrelTranslator;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.sql.H2SQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class GroupingQueryGenerator {
    protected final ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
    protected final GroupingRecipePayloadParams params;
    protected final SQLUtils.SQLTable sqlTable;
    protected final SelectQueryBuilder sqlTableQuery;
    protected final String sqlTableQueryName;
    protected final Dataset sourceDataset;
    protected final DatasetHandler.DatasetParams sourceParams;
    protected final Dataset outputDataset;
    protected PartitioningScheme sourcePartitionScheme;
    protected List<Partition> sourcePartitions;
    protected PartitioningScheme targetPartitionScheme;
    static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.group");

    public GroupingQueryGenerator(GroupingRecipePayloadParams params, Dataset sourceDataset, DatasetHandler.DatasetParams sourceParams, SQLUtils.SQLTable sqlTable, Dataset outputDataset) {
        Preconditions.checkNotNull((Object)params);
        Preconditions.checkNotNull((Object)sourceDataset);
        Preconditions.checkNotNull((Object)sourceDataset.getSchema(), (Object)"Input dataset has no schema");
        this.sourceDataset = sourceDataset;
        this.outputDataset = outputDataset;
        this.sourceParams = sourceParams;
        this.params = params;
        this.sqlTable = sqlTable;
        this.sqlTableQuery = null;
        this.sqlTableQueryName = null;
    }

    public GroupingQueryGenerator(GroupingRecipePayloadParams params, Dataset sourceDataset, DatasetHandler.DatasetParams sourceParams, SelectQueryBuilder sqlTableQuery, String sqlTableQueryName, Dataset outputDataset) {
        Preconditions.checkNotNull((Object)params);
        Preconditions.checkNotNull((Object)sourceDataset);
        Preconditions.checkNotNull((Object)sourceDataset.getSchema(), (Object)"Input dataset has no schema");
        this.sourceDataset = sourceDataset;
        this.outputDataset = outputDataset;
        this.sourceParams = sourceParams;
        this.params = params;
        this.sqlTable = null;
        this.sqlTableQuery = sqlTableQuery;
        this.sqlTableQueryName = sqlTableQueryName;
    }

    public void setPartitioning(PartitioningScheme sourcePartitionScheme, List<Partition> sourcePartitions, PartitioningScheme targetPartitionScheme) {
        this.sourcePartitionScheme = sourcePartitionScheme;
        this.sourcePartitions = sourcePartitions;
        this.targetPartitionScheme = targetPartitionScheme;
    }

    public String generateSQL(SQLDialect dialect, boolean forceOutputColumnNameOverride) {
        return this.generateQuery(dialect, dialect == null ? null : Integer.valueOf(dialect.getIdentifiersMaxLength()), forceOutputColumnNameOverride).toSQL(dialect);
    }

    public SelectQueryBuilder generateQuery(SQLDialect dialect, Integer identifierMaxLength, boolean forceOutputColumnNameOverride) {
        return this.generateQuery(dialect, identifierMaxLength, forceOutputColumnNameOverride, false);
    }

    public SelectQueryBuilder generateQuery(SQLDialect dialect, Integer identifierMaxLength, boolean forceOutputColumnNameOverride, boolean schemalessSuffixing) {
        ExpressionBuilder col;
        SchemaColumn schemaCol;
        Schema intputSchema = this.sourceDataset.getSchema();
        if (intputSchema == null) {
            throw ErrorContext.iae((String)"Input dataset has no schema");
        }
        List<GroupingRecipePayloadParams.GroupingKey> resolvedGroupingKeys = this.params.getResolvedGroupingKeys(intputSchema);
        ArrayList<ExpressionBuilder> keyColumns = new ArrayList<ExpressionBuilder>();
        for (GroupingRecipePayloadParams.GroupingKey gk : resolvedGroupingKeys) {
            keyColumns.add(this.ef.col(gk.column));
        }
        boolean hasFirstLast = this.params.values.stream().anyMatch(value -> value.first || value.last);
        boolean ignoreFilterTranslationError = dialect instanceof H2SQLDialect;
        boolean isSourceDatasetManaged = this.sourceDataset.isManaged();
        SchemaUtils.SafeColumnIdentifierSuffixer safeSuffixer = schemalessSuffixing ? new SchemaUtils.SchemalessSafeColumnIdentifierSuffixer(identifierMaxLength) : new SchemaUtils.SafeColumnIdentifierSuffixer(identifierMaxLength, this.sourceDataset.getSchema());
        SelectQueryBuilder currentQuery = null;
        if (this.params.preFilter != null && (this.params.preFilter.enabled || this.params.preFilter.distinct) || this.sourcePartitions != null) {
            SelectQueryBuilder subQuery = new SelectQueryBuilder();
            this.doSelectFrom(subQuery);
            for (SchemaColumn schemaColumn : this.sourceDataset.getSchema().columns) {
                subQuery.select(schemaColumn.getName());
            }
            Object preFilter = this.params.preFilter;
            if (((FilterDesc)preFilter).distinct) {
                subQuery.selectDistinct();
                preFilter = (FilterDesc)JSON.deepCopy((Object)preFilter);
                ((FilterDesc)preFilter).distinct = false;
            }
            QueryGenerationUtils.preFilter(subQuery, (FilterDesc)preFilter, dialect, this.sourceDataset, ignoreFilterTranslationError);
            if (this.sourcePartitions != null && this.sqlTable.isTrueTable()) {
                ExpressionBuilder expressionBuilder = ExpressionUtils.getPartitionFilterClause(this.sourcePartitionScheme, this.sourceDataset.getSchema(), this.sourceParams, this.sourcePartitions, isSourceDatasetManaged, dialect);
                subQuery.where(expressionBuilder);
            }
            currentQuery = subQuery;
        }
        currentQuery = currentQuery == null ? (StringUtils.isNotBlank((String)this.sqlTableQueryName) ? QueryGenerationUtils.computedColumns(this.sqlTableQuery, this.params.computedColumns, dialect, intputSchema) : QueryGenerationUtils.computedColumns(this.sqlTable, this.params.computedColumns, dialect, intputSchema)) : QueryGenerationUtils.computedColumns(currentQuery, this.params.computedColumns, dialect, intputSchema);
        if (hasFirstLast) {
            SelectQueryBuilder firstLastQuery = new SelectQueryBuilder();
            firstLastQuery.from(currentQuery, "dku__beforefirstlast");
            for (SchemaColumn schemaColumn : this.sourceDataset.getSchema().columns) {
                firstLastQuery.select(schemaColumn.getName());
            }
            if (this.params.computedColumns != null) {
                for (ComputedColumn computedColumn : this.params.computedColumns) {
                    firstLastQuery.select(computedColumn.name);
                }
            }
            for (GroupingRecipePayloadParams.GroupingValue groupingValue : this.params.values) {
                QueryAst.Window w;
                ExpressionBuilder conditionExpr;
                ArrayList partitionColumns;
                if (groupingValue.column == null) continue;
                ExpressionBuilder col2 = ExpressionUtils.getAdjustedColumn(this.ef.col(groupingValue.column), groupingValue.column, this.sourceDataset.getSchema(), this.sourceParams, isSourceDatasetManaged, dialect);
                if (groupingValue.first) {
                    if (StringUtils.isBlank((String)groupingValue.orderColumn)) {
                        throw new IllegalArgumentException("orderColumn parameter is required for FIRST aggregation");
                    }
                    partitionColumns = Lists.newArrayList(keyColumns);
                    if (groupingValue.condition != null) {
                        conditionExpr = (ExpressionBuilder)new GrelToQueryTranslator((GrelTranslator.GrelMapping)new GrelToQueryMapping((SQLDialect)dialect), (Schema)this.sourceDataset.getSchema()).translateToQuery((Expression)groupingValue.condition, (boolean)true).result;
                        partitionColumns.add(this.ef.caseWhen(conditionExpr, this.ef.cst("0"), this.ef.cst("1")));
                    }
                    w = this.makeWindow(partitionColumns, this.ef.col(groupingValue.orderColumn), QueryAst.OrderType.ASC);
                    firstLastQuery.select(col2.firstValue(groupingValue.firstLastNotNull).over(w), safeSuffixer.addSuffix(groupingValue.column, "_dku_fst"));
                }
                if (!groupingValue.last) continue;
                if (StringUtils.isBlank((String)groupingValue.orderColumn)) {
                    throw new IllegalArgumentException("orderColumn parameter is required for LAST aggregation");
                }
                partitionColumns = Lists.newArrayList(keyColumns);
                if (groupingValue.condition != null) {
                    conditionExpr = (ExpressionBuilder)new GrelToQueryTranslator((GrelTranslator.GrelMapping)new GrelToQueryMapping((SQLDialect)dialect), (Schema)intputSchema).translateToQuery((Expression)groupingValue.condition, (boolean)true).result;
                    partitionColumns.add(this.ef.caseWhen(conditionExpr, this.ef.cst("0"), this.ef.cst("1")));
                }
                w = this.makeWindow(partitionColumns, this.ef.col(groupingValue.orderColumn), QueryAst.OrderType.ASC);
                firstLastQuery.select(col2.lastValue(groupingValue.firstLastNotNull).over(w), safeSuffixer.addSuffix(groupingValue.column, "_dku_lst"));
            }
            currentQuery = firstLastQuery;
        }
        SelectQueryBuilder query = new SelectQueryBuilder();
        query.from(currentQuery, "dku__beforegrouping");
        for (GroupingRecipePayloadParams.GroupingKey groupingKey : resolvedGroupingKeys) {
            schemaCol = ExpressionUtils.getSchemaColumn(groupingKey.column, intputSchema, this.params.computedColumns);
            col = ExpressionUtils.getAdjustedColumn(this.ef.col(groupingKey.column), schemaCol, this.sourceParams, isSourceDatasetManaged, dialect);
            query.select(col, groupingKey.column);
        }
        for (GroupingRecipePayloadParams.GroupingValue groupingValue : this.params.values) {
            if (groupingValue.column != null) {
                String aggColumn;
                String aggColumn2;
                if (!groupingValue.hasAnyAggr()) continue;
                schemaCol = ExpressionUtils.getSchemaColumn(groupingValue.column, intputSchema, this.params.computedColumns);
                col = ExpressionUtils.getAdjustedColumn(this.ef.col(groupingValue.column), schemaCol, this.sourceParams, isSourceDatasetManaged, dialect);
                if (groupingValue.min) {
                    ExpressionBuilder min = ExpressionUtils.min(col, schemaCol.getType(), null);
                    String aggColumn22 = safeSuffixer.addSuffix(groupingValue.column, "_min");
                    query.select(min, aggColumn22);
                }
                if (groupingValue.max) {
                    ExpressionBuilder max = ExpressionUtils.max(col, schemaCol.getType(), null);
                    aggColumn2 = safeSuffixer.addSuffix(groupingValue.column, "_max");
                    query.select(max, aggColumn2);
                }
                if (groupingValue.count) {
                    aggColumn = safeSuffixer.addSuffix(groupingValue.column, "_count");
                    query.select(col.count(), aggColumn);
                }
                if (groupingValue.countDistinct) {
                    aggColumn = safeSuffixer.addSuffix(groupingValue.column, "_distinct");
                    query.select(col.countDistinct(), aggColumn);
                }
                if (groupingValue.avg) {
                    aggColumn = safeSuffixer.addSuffix(groupingValue.column, "_avg");
                    query.select(ExpressionUtils.getColAsFloatingPoint(groupingValue.column, schemaCol).avg(), aggColumn);
                }
                if (groupingValue.median) {
                    aggColumn = safeSuffixer.addSuffix(groupingValue.column, "_median");
                    query.select(ExpressionUtils.getColAsFloatingPoint(groupingValue.column, schemaCol).median(), aggColumn);
                }
                if (groupingValue.sum || groupingValue.sum2) {
                    aggColumn = safeSuffixer.addSuffix(groupingValue.column, "_sum");
                    ExpressionBuilder expr = ExpressionUtils.getColAsNumeric(groupingValue.column, schemaCol);
                    expr = expr.castForAggregateIfNeeded(dialect, schemaCol.getType());
                    query.select(expr.sum(), aggColumn);
                }
                if (groupingValue.concat) {
                    query.select(col.aggConcat(groupingValue.concatSeparator, groupingValue.concatDistinct), safeSuffixer.addSuffix(groupingValue.column, "_concat"));
                }
                if (groupingValue.stddev) {
                    aggColumn = safeSuffixer.addSuffix(groupingValue.column, "_stddev");
                    query.select(ExpressionUtils.getColAsFloatingPoint(groupingValue.column, schemaCol).stdDevSamp(), aggColumn);
                }
                if (groupingValue.first) {
                    ExpressionBuilder first = this.ef.col(safeSuffixer.addSuffix(groupingValue.column, "_dku_fst"));
                    first = ExpressionUtils.min(first, schemaCol.getType(), null);
                    aggColumn2 = safeSuffixer.addSuffix(groupingValue.column, "_first");
                    query.select(first, aggColumn2);
                }
                if (!groupingValue.last) continue;
                ExpressionBuilder last = this.ef.col(safeSuffixer.addSuffix(groupingValue.column, "_dku_lst"));
                last = ExpressionUtils.max(last, schemaCol.getType(), null);
                aggColumn2 = safeSuffixer.addSuffix(groupingValue.column, "_last");
                query.select(last, aggColumn2);
                continue;
            }
            dialect.failIfInvalidColumnIdentifier(groupingValue.customName);
            query.select(this.ef.expr(groupingValue.customExpr), groupingValue.customName);
        }
        if (this.params.globalCount) {
            StringTransmogrifier st2 = new StringTransmogrifier();
            for (String s : query.getSelectedItemsAliases()) {
                st2.addAlreadyTransmogrified(s);
            }
            query.select(this.ef.col("*").count(), st2.transmogrify("count"));
        }
        if (this.targetPartitionScheme != null) {
            Set groupingKeysColumns = resolvedGroupingKeys.stream().map(k -> k.column).collect(Collectors.toSet());
            for (String col2 : this.targetPartitionScheme.getDimensionNames()) {
                SchemaColumn sc = this.outputDataset == null ? new SchemaColumn(col2, Type.STRING) : this.outputDataset.getSchema().getColumnOrDefault(col2, Type.STRING);
                ExpressionBuilder expr = this.ef.dstPartitionId(sc, this.targetPartitionScheme.getDimension(col2));
                if (groupingKeysColumns.contains(col2)) {
                    query.replaceSelect(col2, expr, col2);
                    continue;
                }
                query.select(expr, col2);
            }
        }
        if (this.sourcePartitionScheme != null) {
            // empty if block
        }
        for (GroupingRecipePayloadParams.GroupingKey groupingKey : resolvedGroupingKeys) {
            schemaCol = ExpressionUtils.getSchemaColumn(groupingKey.column, intputSchema, this.params.computedColumns);
            col = ExpressionUtils.getAdjustedColumn(this.ef.col(groupingKey.column), schemaCol, this.sourceParams, isSourceDatasetManaged, dialect);
            query.group(col);
        }
        query = QueryGenerationUtils.postFilter(query, this.params.postFilter, dialect, ignoreFilterTranslationError);
        query = QueryGenerationUtils.applyOverrides(query, this.params.outputColumnNameOverrides, dialect, forceOutputColumnNameOverride);
        query = QueryGenerationUtils.applyInsertIntoCasts(query, dialect, this.outputDataset);
        return query;
    }

    private void doSelectFrom(SelectQueryBuilder query) {
        if (StringUtils.isNotBlank((String)this.sqlTableQueryName)) {
            query.from(this.sqlTableQuery, this.sqlTableQueryName);
        } else {
            query.from(this.sqlTable, null);
        }
    }

    private QueryAst.Window makeWindow(List<ExpressionBuilder> keyColumns, ExpressionBuilder orderExpr, QueryAst.OrderType orderType) {
        QueryAst.Window window = SelectQueryBuilder.window(keyColumns, Lists.newArrayList((Object[])new ExpressionBuilder[]{orderExpr}), Lists.newArrayList((Object[])new QueryAst.OrderType[]{orderType}));
        window.withFrame(QueryAst.WindowFrameMode.ROWS, null, QueryAst.WindowFrameDirection.PRECEDING, null, QueryAst.WindowFrameDirection.FOLLOWING, null);
        return window;
    }
}

