/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.server.services.ATSurveyService;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import org.springframework.stereotype.Service;

@Service
public class NPSSurveyService {
    public static final int INITIAL_TIME_DELAY_DAYS = 30;
    public static final int POSTPONE_TIME_DELAY_DAYS = 10;
    public static final int INITIAL_SUBMIT_TIME_DELAY_DAYS = 60;
    public static final int RECURRING_TIME_DELAY_DAYS = 90;

    public NPSSurveySettings getNextSettingAfterATSurvey(NPSSurveySettings settings) {
        if (settings == null) {
            return new NPSSurveySettings();
        }
        return new NPSSurveySettings(settings.state, Math.max(settings.nextAction, ATSurveyService.getNextSurveyInstant()));
    }

    public NPSSurveySettings getNextSetting(NPSSurveySettings settings, NPSSurveyAction action) {
        if (System.currentTimeMillis() < settings.nextAction && action == NPSSurveyAction.POSTPONE) {
            return settings;
        }
        Pair<NPSSurveyState, Long> next = action.apply(settings.state);
        NPSSurveyState newState = (NPSSurveyState)((Object)next.first);
        long newActionTime = (Long)next.second;
        return new NPSSurveySettings(newState, newActionTime);
    }

    public static class NPSSurveySettings {
        public final NPSSurveyState state;
        public final long nextAction;

        public NPSSurveySettings() {
            this.state = NPSSurveyState.INITIAL;
            this.nextAction = new DateTime(DateTimeZone.UTC).plusDays(30).getMillis();
        }

        public NPSSurveySettings(NPSSurveyState state, long nextAction) {
            this.state = state;
            this.nextAction = nextAction;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum NPSSurveyState {
        INITIAL{

            @Override
            public Pair<NPSSurveyState, Long> postpone() {
                return new Pair((Object)INITIAL_POSTPONED, (Object)this.getTimestamp(10));
            }

            @Override
            public Pair<NPSSurveyState, Long> submit() {
                return new Pair((Object)RECURRING, (Object)this.getTimestamp(60));
            }
        }
        ,
        INITIAL_POSTPONED{

            @Override
            public Pair<NPSSurveyState, Long> postpone() {
                return this.submit();
            }

            @Override
            public Pair<NPSSurveyState, Long> submit() {
                return new Pair((Object)RECURRING, (Object)this.getTimestamp(60));
            }
        }
        ,
        RECURRING{

            @Override
            public Pair<NPSSurveyState, Long> postpone() {
                return new Pair((Object)RECURRING_POSTPONED, (Object)this.getTimestamp(10));
            }

            @Override
            public Pair<NPSSurveyState, Long> submit() {
                return new Pair((Object)RECURRING, (Object)this.getTimestamp(90));
            }
        }
        ,
        RECURRING_POSTPONED{

            @Override
            public Pair<NPSSurveyState, Long> postpone() {
                return this.submit();
            }

            @Override
            public Pair<NPSSurveyState, Long> submit() {
                return new Pair((Object)RECURRING, (Object)this.getTimestamp(90));
            }
        }
        ,
        OPTOUT{

            @Override
            public Pair<NPSSurveyState, Long> postpone() {
                return this.submit();
            }

            @Override
            public Pair<NPSSurveyState, Long> submit() {
                return new Pair((Object)RECURRING, (Object)this.getTimestamp(90));
            }
        };


        public abstract Pair<NPSSurveyState, Long> postpone();

        public abstract Pair<NPSSurveyState, Long> submit();

        public Pair<NPSSurveyState, Long> optOut() {
            return new Pair((Object)OPTOUT, (Object)Long.MAX_VALUE);
        }

        long getTimestamp(int dayDelay) {
            return new DateTime(DateTimeZone.UTC).plusDays(dayDelay).getMillis();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum NPSSurveyAction {
        SUBMIT{

            @Override
            public Pair<NPSSurveyState, Long> apply(NPSSurveyState currentState) {
                return currentState.submit();
            }
        }
        ,
        POSTPONE{

            @Override
            public Pair<NPSSurveyState, Long> apply(NPSSurveyState currentState) {
                return currentState.postpone();
            }
        }
        ,
        OPTOUT{

            @Override
            public Pair<NPSSurveyState, Long> apply(NPSSurveyState currentState) {
                return currentState.optOut();
            }
        };


        public abstract Pair<NPSSurveyState, Long> apply(NPSSurveyState var1);
    }
}

