/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.filter;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.shaker.filter.DisplayFilterColumn;
import com.dataiku.dip.shaker.text.StringMatchingMode;
import com.dataiku.dip.shaker.text.StringNormalizationMode;
import java.text.DecimalFormat;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public class AlphanumValueFilter
extends DisplayFilterColumn {
    private boolean exclude;
    private StringMatchingMode mode;
    private StringNormalizationMode normalizationMode;
    private Set<String> values = new HashSet<String>();
    private boolean dkuNoValue;
    private List<Pattern> compiledPatterns = new ArrayList<Pattern>();
    private DecimalFormat df = null;

    public AlphanumValueFilter(String column, String[] values, boolean exclude, StringMatchingMode mode, StringNormalizationMode normalizationMode) {
        this(column, values, exclude, mode, normalizationMode, null);
    }

    public AlphanumValueFilter(String column, String[] values, boolean exclude, StringMatchingMode mode, StringNormalizationMode normalizationMode, Integer decimalPlaces) {
        this.column = column;
        for (String value : values) {
            this.values.add(value);
            if (!value.equals("") && !value.equals("___dku_no_value___")) continue;
            this.dkuNoValue = true;
        }
        this.exclude = exclude;
        this.mode = mode;
        if (this.mode == StringMatchingMode.PATTERN) {
            for (String value : values) {
                this.compiledPatterns.add(Pattern.compile(value));
            }
        }
        this.normalizationMode = normalizationMode;
        if (Objects.requireNonNullElse(decimalPlaces, 0) > 0) {
            this.df = new DecimalFormat("#." + String.valueOf('#').repeat(decimalPlaces));
        }
    }

    @Override
    protected boolean filterRow(MemRow row, Column cd) {
        String value = row.get(cd);
        if (value == null || value.isEmpty()) {
            return this.getFilteringStatus(this.dkuNoValue);
        }
        if (this.df != null && cd instanceof MemColumn && ((MemColumn)cd).selectedType.type.isDouble()) {
            double doubleValue = ((MemColumn)cd).selectedType.type.doubleValue(value);
            value = this.df.format(doubleValue);
        }
        boolean matches = false;
        Set<Object> normalizedValues = new HashSet();
        String normalizedValue = new String();
        switch (this.normalizationMode) {
            case EXACT: {
                normalizedValues = this.values;
                normalizedValue = value;
                break;
            }
            case LOWERCASE: {
                for (String currentValue : this.values) {
                    normalizedValues.add(currentValue.toLowerCase());
                }
                normalizedValue = value.toLowerCase();
                break;
            }
            case NORMALIZED: {
                for (String currentValue : this.values) {
                    String normalizedStr = Normalizer.normalize(currentValue.toLowerCase(), Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
                    normalizedValues.add(normalizedStr);
                }
                normalizedValue = Normalizer.normalize(value.toLowerCase(), Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
            }
        }
        switch (this.mode) {
            case FULL_STRING: {
                matches = normalizedValues.contains(normalizedValue);
                break;
            }
            case SUBSTRING: {
                String s;
                Iterator<Object> iterator = normalizedValues.iterator();
                while (iterator.hasNext() && !(matches = normalizedValue.contains(s = (String)iterator.next()))) {
                }
                break;
            }
            case PATTERN: {
                Pattern p;
                Iterator<Object> iterator = this.compiledPatterns.iterator();
                while (iterator.hasNext() && !(matches = (p = (Pattern)iterator.next()).matcher(value).find())) {
                }
                break;
            }
        }
        return this.getFilteringStatus(matches);
    }

    private boolean getFilteringStatus(boolean matches) {
        if (this.exclude && matches) {
            return false;
        }
        return this.exclude || matches;
    }
}

