/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.mrimpl.formats;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.output.CSVOutputFormatter;
import com.dataiku.dip.shaker.mrimpl.formats.RowWithFactories;
import com.dataiku.dip.shaker.mrimpl.models.DatasetConfig;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.StringWriter;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;

public class CSVOutputFormatAdapter
extends FileOutputFormat<Void, RowWithFactories> {
    private final CSVFormatConfig csvFormatParams;
    private final Schema outputSchema;
    private final TextOutputFormat<NullWritable, Text> outputFormat;
    private final WarningsContext warningsContext;

    public CSVOutputFormatAdapter(DatasetConfig outputConf, WarningsContext warningsContext) {
        this.csvFormatParams = (CSVFormatConfig)outputConf.dataset.getFormatParams();
        this.outputSchema = outputConf.dataset.getSchema();
        this.outputFormat = new TextOutputFormat();
        this.warningsContext = (WarningsContext)Preconditions.checkNotNull((Object)warningsContext);
    }

    public RecordWriter<Void, RowWithFactories> getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        RecordWriter realOutputWriter = this.outputFormat.getRecordWriter(taskAttemptContext);
        return new InternalRecordWriter((RecordWriter<NullWritable, Text>)realOutputWriter);
    }

    private class InternalRecordWriter
    extends RecordWriter<Void, RowWithFactories> {
        private final CSVOutputFormatter csvOutputFormatter;
        private final RecordWriter<NullWritable, Text> realRecordWriter;
        private ColumnFactory cf;

        public InternalRecordWriter(RecordWriter<NullWritable, Text> realRecordWriter) {
            this.realRecordWriter = realRecordWriter;
            this.csvOutputFormatter = new CSVOutputFormatter(CSVOutputFormatAdapter.this.csvFormatParams);
            this.csvOutputFormatter.setOutputSchema(CSVOutputFormatAdapter.this.outputSchema);
            this.csvOutputFormatter.setWarningsContext(CSVOutputFormatAdapter.this.warningsContext);
        }

        private void lazyInit(RowWithFactories firstRow) throws IOException, InterruptedException {
            if (this.cf == null) {
                this.cf = firstRow == null ? new StreamColumnFactory() : firstRow.getColumnFactory();
                StringWriter writer = new StringWriter();
                this.csvOutputFormatter.header(this.cf, writer);
                String headerString = writer.toString();
                if (!StringUtils.isBlank((String)headerString)) {
                    this.writeLine(headerString);
                }
            }
        }

        private void writeLine(String line) throws IOException, InterruptedException {
            if (line.endsWith("\n")) {
                line = line.substring(0, line.length() - 1);
            }
            this.realRecordWriter.write(null, (Object)new Text(line));
        }

        public void write(Void aVoid, RowWithFactories mrRow) throws IOException, InterruptedException {
            this.lazyInit(mrRow);
            StringWriter writer = new StringWriter();
            this.csvOutputFormatter.format(mrRow.getRow(), this.cf, writer);
            this.writeLine(writer.toString());
        }

        public void close(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            this.lazyInit(null);
            StringWriter writer = new StringWriter();
            this.csvOutputFormatter.footer(this.cf, writer);
            String footerString = writer.toString();
            if (!StringUtils.isBlank((String)footerString)) {
                this.writeLine(footerString);
            }
            this.realRecordWriter.close(taskAttemptContext);
        }
    }
}

