/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.text;

import com.dataiku.dip.shaker.text.StringMatchingMode;
import com.dataiku.dip.shaker.text.StringNormalizationMode;
import java.util.regex.Pattern;

public class StringMatchingHelper {
    private String value;
    private Pattern pattern;
    private StringMatchingMode matchingMode;
    private StringNormalizationMode normalizationMode;

    public StringMatchingHelper(String value, StringMatchingMode matchingMode, StringNormalizationMode normalizationMode) {
        if (matchingMode == StringMatchingMode.PATTERN) {
            this.pattern = Pattern.compile(normalizationMode.apply(value));
        } else {
            this.value = normalizationMode.apply(value);
        }
        this.matchingMode = matchingMode;
        this.normalizationMode = normalizationMode;
    }

    public boolean matches(String text) {
        text = this.normalizationMode.apply(text);
        switch (this.matchingMode) {
            case FULL_STRING: {
                return text.equals(this.value);
            }
            case PATTERN: {
                return this.pattern.matcher(text).find();
            }
            case SUBSTRING: {
                return text.indexOf(this.value) >= 0;
            }
        }
        throw new Error("unreachable");
    }
}

