/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.plugin.CustomSQLDialect;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.CustomJavaDialectDesc;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.DateRounding;
import com.dataiku.dip.sql.GenericSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.QuotedPortionFinderFactory;
import com.dataiku.dip.sql.queries.QuotedPortionFinders;
import com.dataiku.dip.sql.regex.RegexDatabaseSupport;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CustomJavaDialect
extends GenericSQLDialect {
    private final CustomSQLDialect dialect;
    private final CustomJavaDialectDesc desc;
    private static Logger logger = Logger.getLogger((String)"dip.custom.java.dialect");

    public CustomJavaDialect(CustomSQLDialect dialect, CustomJavaDialectDesc desc) {
        this.dialect = dialect;
        this.desc = desc;
        this.initExtraOperators();
    }

    private void initExtraOperators() {
        for (Object op : this.dialect.getExtraOperators()) {
            if (op instanceof QueryUtils.AbstractOperator) {
                this.addOperator((QueryUtils.AbstractOperator)op);
                continue;
            }
            logger.warn((Object)("Operator not added, because type is not an AbstractOperator : " + op.getClass().getCanonicalName()));
        }
    }

    @Override
    public DSSTypeSQLMapping getSQLType(SchemaColumn schemaColumn, Dataset dataset) {
        if (this.dialect instanceof CustomSQLDialect.TypeMappingAbleDialect) {
            return ((CustomSQLDialect.TypeMappingAbleDialect)((Object)this.dialect)).getSQLType(schemaColumn, dataset.getParams());
        }
        return super.getSQLType(schemaColumn, dataset);
    }

    @Override
    public int getIdentifiersMaxLength() {
        return this.desc.identifiersMaxLength;
    }

    @Override
    public int getMaxPossibleVarcharLen() {
        return this.desc.maxPossibleVarcharLen;
    }

    @Override
    public boolean supportsCommitAndRollback() {
        return this.desc.supportsCommitAndRollback;
    }

    @Override
    public boolean needsDoubleNormalization() {
        return this.desc.needsDoubleNormalization;
    }

    @Override
    public boolean supportsCTEs() {
        return this.desc.supportsCTEs;
    }

    @Override
    public boolean requiresColumnNamesInCTEs() {
        return this.desc.requiresColumnNamesInCTEs;
    }

    @Override
    public boolean needsTruncateBeforeDropTemporaryTable() {
        if (this.dialect instanceof CustomSQLDialect.TemporaryTableAbleDialect) {
            return ((CustomSQLDialect.TemporaryTableAbleDialect)((Object)this.dialect)).needsTruncateBeforeDropTemporaryTable();
        }
        return false;
    }

    @Override
    public boolean supportsIndexing() {
        return this.dialect instanceof CustomSQLDialect.IndexAbleDialect;
    }

    @Override
    public boolean supportsIndexingOnTemporaryTables() {
        if (this.dialect instanceof CustomSQLDialect.TemporaryTableAbleDialect) {
            return ((CustomSQLDialect.TemporaryTableAbleDialect)((Object)this.dialect)).supportsIndexingOnTemporaryTables();
        }
        return false;
    }

    @Override
    public String getCreateIndexStatement(String indexName, SQLUtils.SQLTable table, String quotedFieldsList) {
        if (this.dialect instanceof CustomSQLDialect.IndexAbleDialect) {
            return ((CustomSQLDialect.IndexAbleDialect)((Object)this.dialect)).getCreateIndexStatement(indexName, table, quotedFieldsList);
        }
        return super.getCreateIndexStatement(indexName, table, quotedFieldsList);
    }

    @Override
    public String getIdentifierQuoteChar() {
        return StringUtils.isNotBlank((String)this.desc.identifierQuoteChar) ? this.desc.identifierQuoteChar : super.getIdentifierQuoteChar();
    }

    @Override
    public String getStringQuoteChar() {
        return StringUtils.isNotBlank((String)this.desc.stringQuoteChar) ? this.desc.stringQuoteChar : super.getStringQuoteChar();
    }

    @Override
    public String useUTCTimezone() {
        return StringUtils.isNotBlank((String)this.desc.useUTCTimezoneCommand) ? this.desc.useUTCTimezoneCommand : super.useUTCTimezone();
    }

    @Override
    public boolean hasCaseInsensitiveColumns() {
        return this.desc.hasCaseInsensitiveColumns;
    }

    @Override
    public RegexDatabaseSupport.RegexSupportStatus supportsRegExpReplaceExpressions(String pattern, String replacement) {
        return RegexDatabaseSupport.RegexSupportStatus.nok("Regex support not known for custom dialects");
    }

    @Override
    public boolean canSQL99() {
        return this.dialect instanceof CustomSQLDialect.WindowAbleDialect;
    }

    @Override
    public boolean supportsNamedWindows() {
        if (this.dialect instanceof CustomSQLDialect.WindowAbleDialect) {
            return ((CustomSQLDialect.WindowAbleDialect)((Object)this.dialect)).supportsNamedWindows();
        }
        return false;
    }

    @Override
    public boolean supportsGreatest() {
        return this.desc.supportsGreatest;
    }

    @Override
    public boolean isNaturalJoinImplicitlyInner() {
        return this.desc.isNaturalJoinImplicitlyInner;
    }

    @Override
    public boolean needsToHaveTrailingSemicolonsRemoved() {
        return this.desc.needsToHaveTrailingSemicolonsRemoved;
    }

    @Override
    public SQLDialect.DefaultUnquotedCase getDefaultUnquotedCaseForTables() {
        return this.desc.defaultUnquotedCase;
    }

    @Override
    public SQLDialect.NaturalJoinSupport getNaturalJoinSupport() {
        return this.desc.naturalJoinSupport;
    }

    @Override
    public QuotedPortionFinderFactory[] getSemicolonExclusionPortionFinders() {
        QuotedPortionFinderFactory[] finders = this.dialect.getSemicolonExclusionPortionFinders();
        if (finders != null) {
            return finders;
        }
        return new QuotedPortionFinderFactory[]{QuotedPortionFinders.SingleLineCommentFinder.META, QuotedPortionFinders.MultiLineCommentFinder.META, QuotedPortionFinders.SingleQuotedNoEscapeFinder.META, QuotedPortionFinders.DoubleQuotedNoEscapeFinder.META};
    }

    @Override
    public boolean tableExists(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, String catalog, String schema, String table) throws Exception {
        if (this.dialect instanceof CustomSQLDialect.TableExistsAbleDialect) {
            return ((CustomSQLDialect.TableExistsAbleDialect)((Object)this.dialect)).tableExists(conn, catalog, schema, table);
        }
        return super.tableExists(authCtx, connData, conn, catalog, schema, table);
    }

    @Override
    public void fill(PreparedStatement ps2, Type dssType, int colIdx, String dssStrVal) throws SQLException {
        if (!this.dialect.fill(ps2, dssType, colIdx, dssStrVal)) {
            super.fill(ps2, dssType, colIdx, dssStrVal);
        }
    }

    @Override
    public void fillWithEmpty(PreparedStatement ps2, Dataset dataset, Type dssType, int colIdx) throws SQLException {
        if (!this.dialect.fillWithEmpty(ps2, dataset.getParams(), dssType, colIdx)) {
            super.fillWithEmpty(ps2, dataset, dssType, colIdx);
        }
    }

    @Override
    public String getValueAsDSSString(ResultSet rs2, int sqlType, int colIdx, SchemaColumn schemaColumn, boolean normalizeDoubles, boolean timestampNoTzAsDate, DateTimeZone assumedTz) throws SQLException {
        Type dssType = schemaColumn.getType();
        if (this.dialect.handlesGetValue(sqlType, dssType)) {
            return this.dialect.getValueAsDSSString(rs2, sqlType, colIdx, dssType, normalizeDoubles, timestampNoTzAsDate, assumedTz);
        }
        return super.getValueAsDSSString(rs2, sqlType, colIdx, schemaColumn, normalizeDoubles, timestampNoTzAsDate, assumedTz);
    }

    @Override
    public boolean lacksTimezoneInfo(String sqlTypeName, int sqlPrecision) {
        return this.dialect.lacksTimezoneInfo(sqlTypeName);
    }

    @Override
    public String getLimitedQuery(String query, long size) {
        return query;
    }

    @Override
    public boolean supportsResultSetMetadataOnPreparedStatement(String sql) {
        return this.dialect instanceof CustomSQLDialect.ResultSetMetadataOnPreparedStatementAbleDialect;
    }

    @Override
    public String alterQueryForResultSetMetadataOnPreparedStatement(String sql) {
        if (this.dialect instanceof CustomSQLDialect.ResultSetMetadataOnPreparedStatementAbleDialect) {
            return ((CustomSQLDialect.ResultSetMetadataOnPreparedStatementAbleDialect)((Object)this.dialect)).alterQueryForResultSetMetadataOnPreparedStatement(sql);
        }
        return sql;
    }

    @Override
    public ResultSetMetaData getResultSetMetadataOnPreparedStatement(PreparedStatement pstmt) throws Exception {
        if (this.dialect instanceof CustomSQLDialect.ResultSetMetadataOnPreparedStatementAbleDialect) {
            return ((CustomSQLDialect.ResultSetMetadataOnPreparedStatementAbleDialect)((Object)this.dialect)).getResultSetMetadataOnPreparedStatement(pstmt);
        }
        return pstmt.getMetaData();
    }

    @Override
    public boolean isSchemaAware() {
        return this.desc.isSchemaAware;
    }

    @Override
    public void executePostConnectTasks(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn) throws SQLException {
        this.dialect.executePostConnectTasks(conn, connData.getConnection().getParams());
    }

    @Override
    public String getColumnExpressionForBoolean(String booleanExpression) {
        String converted = this.dialect.getColumnExpressionForBoolean(booleanExpression);
        return converted != null ? converted : super.getColumnExpressionForBoolean(booleanExpression);
    }

    @Override
    protected String cast(String expr, Type exprType, Type requestedType, int maxLength) {
        String converted = this.dialect.cast(expr, requestedType, maxLength);
        return converted != null ? converted : super.cast(expr, exprType, requestedType, maxLength);
    }

    @Override
    public String createTemporaryTable(SQLUtils.SQLTable table, String columnListExpr) {
        if (this.dialect instanceof CustomSQLDialect.TemporaryTableAbleDialect) {
            return ((CustomSQLDialect.TemporaryTableAbleDialect)((Object)this.dialect)).createTemporaryTable(table, columnListExpr);
        }
        return super.createTemporaryTable(table, columnListExpr);
    }

    @Override
    public String[] createTemporaryTableAs(SQLUtils.SQLTable table, String selectExpr) {
        if (this.dialect instanceof CustomSQLDialect.TemporaryTableAbleDialect) {
            return ((CustomSQLDialect.TemporaryTableAbleDialect)((Object)this.dialect)).createTemporaryTableAs(table, selectExpr);
        }
        return super.createTemporaryTableAs(table, selectExpr);
    }

    @Override
    public String getSafeRandomTemporaryTableName(String prefix) {
        if (this.dialect instanceof CustomSQLDialect.TemporaryTableAbleDialect) {
            return ((CustomSQLDialect.TemporaryTableAbleDialect)((Object)this.dialect)).getSafeRandomTemporaryTableName(prefix);
        }
        return super.getSafeRandomTemporaryTableName(prefix);
    }

    @Override
    public void failIfInvalidColumnIdentifier(String identifier) {
        if (this.desc.knowsHowToFailIfInvalidColumnIdentifier) {
            this.dialect.failIfInvalidColumnIdentifier(identifier);
        } else {
            super.failIfInvalidColumnIdentifier(identifier);
        }
    }

    @Override
    public void setDefaultLengthForSchemaColumn(Schema schema, List<SchemaColumn> keyColumns, InfoMessage.InfoMessages messages) {
        if (this.dialect instanceof CustomSQLDialect.DefaultLenghtAbleDialect) {
            ((CustomSQLDialect.DefaultLenghtAbleDialect)((Object)this.dialect)).setDefaultLengthForSchemaColumn(schema);
        } else {
            super.setDefaultLengthForSchemaColumn(schema, keyColumns, messages);
        }
    }

    @Override
    public String datePartExpression(String inputDateExpression, DatePart part) {
        if (this.dialect instanceof CustomSQLDialect.DateOperationAbleDialect) {
            return ((CustomSQLDialect.DateOperationAbleDialect)((Object)this.dialect)).datePartExpression(inputDateExpression, part);
        }
        return super.datePartExpression(inputDateExpression, part);
    }

    @Override
    public String timeRange(String value, String unit) {
        if (this.dialect instanceof CustomSQLDialect.DateOperationAbleDialect) {
            return ((CustomSQLDialect.DateOperationAbleDialect)((Object)this.dialect)).timeRange(value, unit);
        }
        return super.timeRange(value, unit);
    }

    @Override
    public String dateTrunc(String inputDateExpression, DateRounding rounding) {
        if (this.dialect instanceof CustomSQLDialect.DateOperationAbleDialect) {
            return ((CustomSQLDialect.DateOperationAbleDialect)((Object)this.dialect)).dateTrunc(inputDateExpression, rounding);
        }
        return super.dateTrunc(inputDateExpression, rounding);
    }

    @Override
    public String dateonlyTrunc(String inputDateExpression, DateRounding rounding) {
        if (this.dialect instanceof CustomSQLDialect.DateOperationAbleDialect) {
            return ((CustomSQLDialect.DateOperationAbleDialect)((Object)this.dialect)).dateonlyTrunc(inputDateExpression, rounding);
        }
        return super.dateonlyTrunc(inputDateExpression, rounding);
    }

    @Override
    public String datetimenotzTrunc(String inputDateExpression, DateRounding rounding) {
        if (this.dialect instanceof CustomSQLDialect.DateOperationAbleDialect) {
            return ((CustomSQLDialect.DateOperationAbleDialect)((Object)this.dialect)).datetimenotzTrunc(inputDateExpression, rounding);
        }
        return super.datetimenotzTrunc(inputDateExpression, rounding);
    }

    @Override
    public boolean supportsInDatabaseCharts() {
        return this.desc.supportsInDatabaseCharts;
    }

    @Override
    public String getId() {
        return this.desc.id;
    }
}

