/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.sql.PostgreSQLDialect;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;

public class PostgreSQL14Dialect
extends PostgreSQLDialect {
    @Override
    protected void initRegexpOperators() {
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.REGEXP_REPLACE, "REGEXP_REPLACE", QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String column = this.toSQLNoBrackets(args[0]);
                String pattern = this.toSQLNoBrackets(args[1]);
                String replacement = this.toSQLNoBrackets(args[2]);
                String caseSensitive = "cg";
                if (args.length > 3) {
                    caseSensitive = this.getParamAs(args[3], Boolean.class) != false ? "ig" : "cg";
                }
                return String.format("REGEXP_REPLACE(%s, %s, %s, '%s')", column, pattern, replacement, caseSensitive);
            }
        });
        this.removeOperator(QueryUtils.OperatorType.REGEXP_SUBSTR);
    }
}

