/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.sql.AsterDataSQLDialect;
import com.dataiku.dip.sql.AthenaSQLDialect;
import com.dataiku.dip.sql.BigQuerySQLDialect;
import com.dataiku.dip.sql.DB2SQLDialect;
import com.dataiku.dip.sql.DatabricksSQLDialect;
import com.dataiku.dip.sql.DenodoSQLDialect;
import com.dataiku.dip.sql.DremioSQLDialect;
import com.dataiku.dip.sql.ExasolSQLDialect;
import com.dataiku.dip.sql.GreenplumSQLDialect;
import com.dataiku.dip.sql.H2SQLDialect;
import com.dataiku.dip.sql.H2V2SQLDialect;
import com.dataiku.dip.sql.HiveSQLDialect;
import com.dataiku.dip.sql.ImpalaSQLDialect;
import com.dataiku.dip.sql.KDBSQLDialect;
import com.dataiku.dip.sql.MySQLDialect;
import com.dataiku.dip.sql.NetezzaSQLDialect;
import com.dataiku.dip.sql.OracleSQLDialect;
import com.dataiku.dip.sql.PostgreSQLDialect;
import com.dataiku.dip.sql.RedshiftSQLDialect;
import com.dataiku.dip.sql.SAPHANASQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLServerSQLDialect;
import com.dataiku.dip.sql.SnowflakeSQLDialect;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.sql.SqreamSQLDialect;
import com.dataiku.dip.sql.SybaseIQSQLDialect;
import com.dataiku.dip.sql.SynapseSQLDialect;
import com.dataiku.dip.sql.TeradataSQLDialect;
import com.dataiku.dip.sql.TrinoSQLDialect;
import com.dataiku.dip.sql.VerticaSQLDialect;
import com.dataiku.dip.sql.YellowbrickSQLDialect;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SQLDialectsRegistry {
    private static final Map<String, SQLDialect> dialects = new HashMap<String, SQLDialect>();

    public static synchronized void register(SQLDialect dialect) {
        if (dialects.containsKey(dialect.getId())) {
            throw new IllegalArgumentException("Duplicate SQL identifier: " + dialect.getId());
        }
        dialects.put(dialect.getId(), dialect);
    }

    public static synchronized void deregister(SQLDialect dialect) {
        dialects.remove(dialect.getId());
    }

    public static synchronized SQLDialect get(String dialectId) {
        return dialects.get(dialectId);
    }

    public static synchronized List<String> listAvailable() {
        ArrayList<String> ret = new ArrayList<String>();
        for (SQLDialect dialect : dialects.values()) {
            ret.add(dialect.getId());
        }
        Collections.sort(ret);
        return ret;
    }

    static {
        SQLDialectsRegistry.register(new AsterDataSQLDialect());
        SQLDialectsRegistry.register(new BigQuerySQLDialect());
        SQLDialectsRegistry.register(new DB2SQLDialect());
        SQLDialectsRegistry.register(new ExasolSQLDialect());
        SQLDialectsRegistry.register(new GreenplumSQLDialect());
        SQLDialectsRegistry.register(new H2SQLDialect());
        SQLDialectsRegistry.register(new H2V2SQLDialect());
        SQLDialectsRegistry.register(new HiveSQLDialect());
        SQLDialectsRegistry.register(new ImpalaSQLDialect());
        SQLDialectsRegistry.register(new MySQLDialect());
        SQLDialectsRegistry.register(new NetezzaSQLDialect());
        SQLDialectsRegistry.register(new OracleSQLDialect());
        SQLDialectsRegistry.register(new PostgreSQLDialect());
        SQLDialectsRegistry.register(new RedshiftSQLDialect());
        SQLDialectsRegistry.register(new SnowflakeSQLDialect());
        SQLDialectsRegistry.register(new SAPHANASQLDialect());
        SQLDialectsRegistry.register(new SynapseSQLDialect());
        SQLDialectsRegistry.register(new SQLServerSQLDialect());
        SQLDialectsRegistry.register(new SparkSQLDialect());
        SQLDialectsRegistry.register(new SybaseIQSQLDialect());
        SQLDialectsRegistry.register(new TeradataSQLDialect());
        SQLDialectsRegistry.register(new VerticaSQLDialect());
        SQLDialectsRegistry.register(new KDBSQLDialect());
        SQLDialectsRegistry.register(new DatabricksSQLDialect());
        SQLDialectsRegistry.register(new SqreamSQLDialect());
        SQLDialectsRegistry.register(new DremioSQLDialect());
        SQLDialectsRegistry.register(new YellowbrickSQLDialect());
        SQLDialectsRegistry.register(new AthenaSQLDialect());
        SQLDialectsRegistry.register(new TrinoSQLDialect());
        SQLDialectsRegistry.register(new DenodoSQLDialect());
    }
}

