/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.crecipes.sync;

import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.RecipeEnginesPreferenceConfig;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowStreamingEndpoint;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.FakeJobActivityFromRecipeBuilder;
import com.dataiku.dip.recipes.common.RecipeConfigUtils;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.streaming.crecipes.sync.CSyncRecipeParams;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.variables.VariablesService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class CsyncRecipeStatusComputer
extends RecipeStatusComputer {
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private VisualSQLRecipesBaseService visualSQLRecipesBaseService;
    private static Logger logger = Logger.getLogger((String)"dip.shaker.status.computer");

    public CsyncRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
    }

    @Override
    public RecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) throws Exception {
        CSyncRecipeStatus status;
        try (Transaction t = this.transactionService.beginRead();){
            status = this.fastStatusIgnorePartitions(authCtx, new StatusInitializer());
        }
        return status;
    }

    @Override
    public CSyncRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws Exception {
        return this.fastStatusIgnorePartitions(authCtx, new StatusInitializer());
    }

    public CSyncRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx, StatusInitializer init) throws Exception {
        StreamingEndpoint input;
        CSyncRecipeStatus status = new CSyncRecipeStatus();
        JobActivity activity = new FakeJobActivityFromRecipeBuilder().buildFakeJobActivity(this.recipe);
        CSyncRecipeParams params = (CSyncRecipeParams)this.recipe.params;
        status.engines = this.getEnginesStatus(authCtx);
        status.selectedEngine = this.selectEngine(authCtx, params.engineType, status.engines);
        this.performBasicStructureChecks(status, authCtx);
        this.recipesValidationService.checkTargetsAreWritable(activity);
        FlowComputable inputComputable = activity.getSubgraph().getSources().get(0);
        FlowComputable outputComputable = activity.getSubgraph().getTargets().get(0);
        if ("SPARK".equals(status.selectedEngine.type) && inputComputable.getType() == FlowComputable.FCType.STREAMING_ENDPOINT && !(input = ((FlowStreamingEndpoint)inputComputable).getStreamingEndpoint()).getType().equals("kafka")) {
            status.topLevelMessages.withWarning((InfoMessage.MessageCode)RecipeCodes.WARN_RECIPE_CSYNC_NONNATIVE_STREAMING, "Only Kafka endpoint are natively read by Spark streaming");
        }
        return status;
    }

    public List<RecipeEngineStatus> getEnginesStatus(AuthCtx authCtx) throws Exception {
        StreamingEndpoint output;
        JobActivity activity = new FakeJobActivityFromRecipeBuilder().buildFakeJobActivity(this.recipe);
        FlowComputable inputComputable = activity.getSubgraph().getSources().get(0);
        FlowComputable outputComputable = activity.getSubgraph().getTargets().get(0);
        ArrayList<RecipeEngineStatus> ret = new ArrayList<RecipeEngineStatus>();
        RecipeEngineStatus dss = new RecipeEngineStatus("DSS", "DSS", null, null, "DSS");
        dss.description = "Run on DSS";
        dss.isSelectable = true;
        ret.add(dss);
        RecipeEngineStatus spark = new RecipeEngineStatus("SPARK", "Spark", null, null, "Spark");
        spark.description = "Run on Spark";
        SparkSettings sparkSettings = new ClusterSelector().selectForProject(authCtx, this.recipe.getProjectKey()).getSparkSettings();
        if (!sparkSettings.sparkEnabled) {
            spark.isSelectable = false;
            spark.statusWarnLevel = RecipeEngineStatus.WarningLevel.ERROR;
            spark.statusMessage = "Spark not found";
        } else {
            spark.isSelectable = true;
        }
        if (outputComputable.getType() == FlowComputable.FCType.DATASET) {
            Dataset output2 = ((FlowDataset)outputComputable).getMandatory(this.datasetsDAO);
            if (!DatasetInspector.isFSLike(output2)) {
                spark.isSelectable = false;
                spark.statusWarnLevel = RecipeEngineStatus.WarningLevel.ERROR;
                spark.statusMessage = "Only FS-like outputs are supported";
            }
        } else if (outputComputable.getType() == FlowComputable.FCType.STREAMING_ENDPOINT && !(output = ((FlowStreamingEndpoint)outputComputable).getStreamingEndpoint()).getType().equals("kafka")) {
            spark.isSelectable = false;
            spark.statusWarnLevel = RecipeEngineStatus.WarningLevel.ERROR;
            spark.statusMessage = "Only Kafka outputs are supported";
        }
        ret.add(spark);
        return ret;
    }

    public RecipeEngineStatus selectEngine(AuthCtx authCtx, String userSelected) throws Exception {
        List<RecipeEngineStatus> statusList = this.getEnginesStatus(authCtx);
        return this.selectEngine(authCtx, userSelected, statusList);
    }

    private RecipeEngineStatus selectEngine(AuthCtx authCtx, String userSelected, List<RecipeEngineStatus> statusList) throws IOException, DKUSecurityException {
        RecipeEnginesPreferenceConfig resolvedPrefs = new RecipeConfigUtils().getResolvedPreferenceConfig(this.recipe.projectKey, this.recipe.type, null);
        HashMap<String, RecipeEngineStatus> enginesIndex = new HashMap<String, RecipeEngineStatus>();
        for (RecipeEngineStatus recipeEngineStatus : statusList) {
            enginesIndex.put(recipeEngineStatus.type, recipeEngineStatus);
        }
        List<String> forbiddenEngines = resolvedPrefs.getEffectiveForbidden(this.recipe.type);
        for (String forbidden : forbiddenEngines) {
            RecipeEngineStatus engine = (RecipeEngineStatus)enginesIndex.get(forbidden);
            if (engine == null) continue;
            engine.isSelectable = false;
            engine.statusWarnLevel = RecipeEngineStatus.WarningLevel.ERROR;
            engine.statusMessage = "Forbidden by configuration";
        }
        if (userSelected != null) {
            return RecipeEngineStatus.getByType(statusList, userSelected);
        }
        List<String> list2 = resolvedPrefs.getEffectivePreference(this.recipe.type);
        list2 = RecipeStatus.filterToActualEngines(list2, RecipeStatus.toEngineTypes(statusList));
        list2.add("DSS");
        list2.add("SPARK");
        for (String type : list2) {
            RecipeEngineStatus res = RecipeStatus.getEngineByTypeAllowNonExisting(statusList, type);
            if (res == null || !res.isSelectable || res.statusWarnLevel != RecipeEngineStatus.WarningLevel.OK) continue;
            return res;
        }
        return RecipeEngineStatus.getByType(statusList, "DSS");
    }

    public static class StatusInitializer {
    }

    public static class CSyncRecipeStatus
    extends RecipeStatus {
        @Override
        public InfoMessage.InfoMessages gatherAllMessages() {
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            ret.mergeFrom(this.topLevelMessages);
            return ret;
        }
    }
}

