/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.crecipes.sync;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.streaming.crecipes.sync.CSyncExecutor;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimpleConsumer;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimplePusher;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimplePusherFactory;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimpleWriter;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointsRegistry;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;

public class SimpleSEToSECSyncRecipeExecutor
implements CSyncExecutor {
    private final StreamingEndpoint source;
    private final StreamingEndpoint target;
    private StreamingEndpointSimpleWriter outputAppender;
    private StreamingEndpointSimplePusher driver;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.streaming.setodatasetsync.simple");

    public SimpleSEToSECSyncRecipeExecutor(StreamingEndpoint source, StreamingEndpoint target) {
        SpringUtils.getInstance().autowire((Object)this);
        this.source = source;
        this.target = target;
    }

    @Override
    public void run(AuthCtx authCtx) throws Exception {
        StreamColumnFactory scf = new StreamColumnFactory();
        StreamRowFactory srf = new StreamRowFactory();
        WarningsContext wc = new WarningsContext();
        this.outputAppender = StreamingEndpointsRegistry.getMeta(this.target).getSimpleWriter(authCtx, this.target, (ColumnFactory)scf, wc);
        this.outputAppender.init();
        this.driver = new StreamingEndpointSimplePusherFactory().build(authCtx, this.source, false);
        SimpleSyncConsumer consumer = new SimpleSyncConsumer();
        this.driver.run(consumer, null, (ColumnFactory)scf, (RowFactory)srf, this.source.schema);
        this.outputAppender.postProcess();
    }

    @Override
    public void abort() {
        if (this.driver != null) {
            this.driver.interrupt();
        }
    }

    class SimpleSyncConsumer
    implements StreamingEndpointSimpleConsumer {
        SimpleSyncConsumer() {
        }

        @Override
        public void onRow(Row row) throws Exception {
            logger.info((Object)("Append row: " + String.valueOf(row)));
            SimpleSEToSECSyncRecipeExecutor.this.outputAppender.processRow(row);
        }

        @Override
        public void onNewState(String state) throws Exception {
        }
    }
}

