/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.endpoints;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointMeta;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimplePusher;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointsRegistry;
import com.dataiku.dip.streaming.endpoints.httpsse.HTTPSSESimplePusher;
import com.dataiku.dip.streaming.endpoints.httpsse.HTTPSSEStreamingEndpointParams;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaSimplePusher;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaStreamingEndpointParams;
import com.dataiku.dip.streaming.endpoints.kdbplustick.KDBPlusTickSimplePusher;
import com.dataiku.dip.streaming.endpoints.kdbplustick.KDBPlusTickStreamingEndpointParams;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.streaming.endpoints.sqs.SQSSimplePusher;
import com.dataiku.dip.streaming.endpoints.sqs.SQSStreamingEndpointParams;

public class StreamingEndpointSimplePusherFactory {
    public StreamingEndpointSimplePusher build(AuthCtx authCtx, StreamingEndpoint endpoint, boolean nonConsuming) {
        StreamingEndpointMeta meta = StreamingEndpointsRegistry.getMeta(endpoint);
        if ("httpsse".equals(endpoint.type)) {
            return new HTTPSSESimplePusher(meta.getExpandedParams(endpoint.projectKey, endpoint, HTTPSSEStreamingEndpointParams.class));
        }
        if ("kafka".equals(endpoint.type)) {
            return new KafkaSimplePusher(authCtx, meta.getExpandedParams(endpoint.projectKey, endpoint, KafkaStreamingEndpointParams.class));
        }
        if ("sqs".equals(endpoint.type)) {
            return new SQSSimplePusher(authCtx, meta.getExpandedParams(endpoint.projectKey, endpoint, SQSStreamingEndpointParams.class), nonConsuming);
        }
        if ("kdbplustick".equals(endpoint.type)) {
            return new KDBPlusTickSimplePusher(authCtx, meta.getExpandedParams(endpoint.projectKey, endpoint, KDBPlusTickStreamingEndpointParams.class));
        }
        throw new Error("unimplemented");
    }
}

