/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.endpoints.sqs;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimpleConsumer;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimplePuller;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimplePusher;
import com.dataiku.dip.streaming.endpoints.sqs.SQSSimplePuller;
import com.dataiku.dip.streaming.endpoints.sqs.SQSStreamingEndpointParams;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;

public class SQSSimplePusher
implements StreamingEndpointSimplePusher {
    private volatile boolean interrupted;
    private final SQSSimplePuller puller;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.streaming.endpoints.sqs.pusher");

    public SQSSimplePusher(AuthCtx authCtx, SQSStreamingEndpointParams params, boolean nonConsuming) {
        this.puller = new SQSSimplePuller(authCtx, params, nonConsuming);
    }

    @Override
    public void run(StreamingEndpointSimpleConsumer consumer, String previousState, ColumnFactory cf, RowFactory rf, Schema schema) throws Exception {
        this.puller.init(cf, rf, schema, (JsonElement)(previousState == null ? JsonNull.INSTANCE : new JsonPrimitive(previousState)));
        while (!this.interrupted) {
            StreamingEndpointSimplePuller.RowsPulled pulled = this.puller.next();
            for (Row row : pulled.rows) {
                consumer.onRow(row);
            }
            consumer.onNewState(pulled.state == null ? null : pulled.state.getAsString());
            if (pulled.ack == null) continue;
            pulled.ack.run();
        }
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
        try {
            this.puller.close();
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to close puller", (Throwable)e);
        }
    }
}

