/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import com.dataiku.dip.utils.DKULogger;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;

public class ObjectFinder {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.utils.objectfinder");

    private static boolean matches(String data, String filter) {
        return data.toLowerCase().contains(filter);
    }

    private static boolean matches(List<?> obj, String filter, int depth) {
        if (depth > 10) {
            throw new IllegalStateException("Max depth exceeded");
        }
        for (int i = 0; i < obj.size(); ++i) {
            Object val = obj.get(i);
            if (!(val instanceof List ? ObjectFinder.matches((List)val, filter, depth + 1) : (val instanceof String ? ObjectFinder.matches((String)val, filter) : (val instanceof Map ? ObjectFinder.matches((Map)val, filter, depth + 1) : ObjectFinder.matchesRc(val, filter, depth + 1))))) continue;
            return true;
        }
        return false;
    }

    private static boolean matches(Map<?, ?> map, String filter, int depth) {
        if (depth > 10) {
            throw new IllegalStateException("Max depth exceeded");
        }
        for (Object val : map.values()) {
            if (!(val instanceof List ? ObjectFinder.matches((List)val, filter, depth + 1) : (val instanceof String ? ObjectFinder.matches((String)val, filter) : (val instanceof Map ? ObjectFinder.matches((Map)val, filter, depth + 1) : ObjectFinder.matchesRc(val, filter, depth + 1))))) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(Object obj, String filter) {
        if (obj == null) {
            return false;
        }
        return ObjectFinder.matchesRc(obj, filter, 0);
    }

    private static boolean matchesRc(Object obj, String filter, int depth) {
        if (depth > 10) {
            throw new IllegalStateException("Max depth exceeded");
        }
        if (obj == null) {
            return false;
        }
        filter = filter.toLowerCase();
        for (Field f : obj.getClass().getDeclaredFields()) {
            try {
                if (Modifier.isStatic(f.getModifiers())) continue;
                f.setAccessible(true);
                Object val = f.get(obj);
                if (val instanceof List) {
                    if (!ObjectFinder.matches((List)val, filter, depth + 1)) continue;
                    return true;
                }
                if (val instanceof String) {
                    if (!ObjectFinder.matches((String)val, filter)) continue;
                    return true;
                }
                if (f.getType().isPrimitive()) continue;
                if (val instanceof Map) {
                    if (!ObjectFinder.matches((Map)val, filter, depth + 1)) continue;
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                logger.warn((Object)"Matching failed", (Throwable)e);
            }
        }
        return false;
    }
}

