/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.variables;

import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.variables.HierarchicalVariablesContext;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ManualVariablesService
extends VariablesService {
    public HierarchicalVariablesContext global;
    public Map<String, HierarchicalVariablesContext> perProject = new HashMap<String, HierarchicalVariablesContext>();
    public String dssUserLogin;

    @Override
    public VariablesContext getGlobalContext() {
        return this.global;
    }

    private void addUserLogin(HierarchicalVariablesContext hvc) {
        if (StringUtils.isNotBlank((String)this.dssUserLogin) && !hvc.has("dssUserLogin")) {
            JsonObject ret = new JsonObject();
            ret.addProperty("dssUserLogin", this.dssUserLogin);
            hvc.addLevel(ret);
        }
    }

    @Override
    public VariablesContext getGlobalContextAndUserLogin(AuthCtx authCtx) {
        this.addUserLogin(this.global);
        return this.global;
    }

    @Override
    public VariablesContext getContext(String projectKey) {
        if (StringUtils.isBlank((String)projectKey)) {
            throw new IllegalArgumentException("projectKey is empty");
        }
        HierarchicalVariablesContext hvc = this.perProject.get(projectKey);
        if (hvc == null) {
            throw new Error("No variables context for project " + projectKey);
        }
        return hvc;
    }

    @Override
    public VariablesContext getContextAndUserLogin(String projectKey, AuthCtx authCtx) {
        HierarchicalVariablesContext hvc = (HierarchicalVariablesContext)this.getContext(projectKey);
        this.addUserLogin(hvc);
        return hvc;
    }

    @Override
    public VariablesContext getForConnection(DSSConnection connection, AuthCtx authCtx) {
        return this.global;
    }

    @Override
    public VariablesContext getForConnectionAndProject(DSSConnection connection, AuthCtx authCtx, String projectKey) {
        return this.getContext(projectKey);
    }

    @Override
    public VariablesContext getForEverything(DSSConnection connection, AuthCtx authCtx, String projectKey) {
        return this.getContext(projectKey);
    }
}

