/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.webapps.WebApp;
import java.io.IOException;
import java.util.Objects;

public class WebAppSecurityInfo {
    public boolean forceAuthentication;
    public boolean hideAccessToken;
    public String redirectUrl;
    public String accessTokenCookieName;
    public String vanityURL;
    public String studioUrl;
    public boolean backendCheckAccess;
    public GeneralSettingsDAO.WebAppSecuritySettings.RedirectMode redirectMode = GeneralSettingsDAO.WebAppSecuritySettings.RedirectMode.DEFAULT;

    public static WebAppSecurityInfo create(WebApp webApp) throws IOException, DKUSecurityException {
        WebAppSecurityInfo ret = WebAppSecurityInfo.createPublic(webApp);
        ret.accessTokenCookieName = UIAuthService.getAccessCookieName();
        return ret;
    }

    public static WebAppSecurityInfo createPublic(WebApp webApp) {
        GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        return WebAppSecurityInfo.createPublic(webApp, generalSettings.webAppSecuritySettings, generalSettings);
    }

    public static WebAppSecurityInfo createPublic(WebApp webApp, GeneralSettingsDAO.WebAppSecuritySettings webAppSecuritySettings) {
        GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        return WebAppSecurityInfo.createPublic(webApp, webAppSecuritySettings, generalSettings);
    }

    private static WebAppSecurityInfo createPublic(WebApp webApp, GeneralSettingsDAO.WebAppSecuritySettings webAppSecuritySettings, GeneralSettingsDAO.GeneralSettings generalSettings) {
        WebAppSecurityInfo ret = new WebAppSecurityInfo();
        switch (webAppSecuritySettings.requiredAuthenticationMode) {
            case LET_USER_DECIDE: {
                ret.forceAuthentication = webApp.params.forceAuthentication;
                break;
            }
            case ALL_BUT_ADMIN_WHITELIST: {
                ret.forceAuthentication = !webAppSecuritySettings.requiredAuthenticationWhitelist.contains(webApp.getFullId()) || webApp.params.forceAuthentication;
            }
        }
        for (SimpleKeyValue skv : webAppSecuritySettings.vanityURLs) {
            if (!webApp.getFullId().equals(skv.key)) continue;
            ret.vanityURL = skv.value;
        }
        ret.hideAccessToken = webAppSecuritySettings.disableAccessToken && !webAppSecuritySettings.accessTokenWhitelist.contains(webApp.getFullId());
        ret.redirectUrl = webAppSecuritySettings.webAppAuthCustomRedirectUrl;
        ret.redirectMode = webAppSecuritySettings.redirectMode;
        ret.studioUrl = generalSettings.studioExternalUrl;
        ret.backendCheckAccess = webAppSecuritySettings.trustedCodePolicy != GeneralSettingsDAO.WebAppSecuritySettings.TrustedCodePolicy.NOBODY || ret.forceAuthentication;
        return ret;
    }

    public static boolean needsRestart(WebAppSecurityInfo previous, WebAppSecurityInfo updated) {
        return previous.forceAuthentication != updated.forceAuthentication || !Objects.equals(previous.vanityURL, updated.vanityURL);
    }
}

