/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.wikis;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.files.MimeTypeUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectDiffService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TaggingService;
import com.dataiku.dip.timelines.EnrichmentService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.wikis.Article;
import com.dataiku.dip.wikis.ArticlesCacheService;
import com.dataiku.dip.wikis.ArticlesDAO;
import com.dataiku.dip.wikis.ArticlesTemplatesService;
import com.dataiku.dip.wikis.Wiki;
import com.dataiku.dip.wikis.WikisDAO;
import com.dataiku.dss.shadelib.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WikisService {
    @Autowired
    private WikisDAO wikisDAO;
    @Autowired
    private ArticlesDAO articlesDAO;
    @Autowired
    private TaggingService taggingService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private CustomFieldsService customFieldsService;
    @Autowired
    private ArticlesTemplatesService articlesTemplatesService;
    @Autowired
    private EnrichmentService enrichmentService;
    @Autowired
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    @Autowired
    private ArticlesCacheService articlesCacheService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    private static final int MAX_PAYLOAD_LENGTH = 16000000;
    public static final int ATTACHMENT_ID_LENGTH = 12;
    public static final String ATTACHMENT_EXTENSIONS_WHITELIST_DIP_PROPERTY = "dku.wikis.authorizedUploadExtensions";
    static DKULogger logger = DKULogger.getLogger((String)"dku.wikis.service");

    public Wiki getWikiUnsafe(String projectKey) throws IOException {
        return this.wikisDAO.getUnsafe(projectKey);
    }

    public Wiki getWiki(String projectKey) throws IOException {
        return this.wikisDAO.get(projectKey);
    }

    public List<Article> listArticles(String projectKey) throws IOException {
        List<Article> articles = this.articlesDAO.list(projectKey);
        for (Article article : articles) {
            for (Article.ArticleAttachment attachment : article.attachments) {
                if (!StringUtils.isNotBlank((CharSequence)attachment.getObjectSmartId())) continue;
                try {
                    this.enrichmentService.enrich(attachment, projectKey);
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to enrich wiki article pkey=" + projectKey + " article=" + article.id + " attachement=" + attachment.getObjectSmartId()), (Throwable)e);
                }
            }
        }
        return articles;
    }

    public List<Article> listArticlesUnsafe(String projectKey) throws IOException {
        return this.listArticlesUnsafe(projectKey, true);
    }

    public List<Article> listArticlesUnsafe(String projectKey, boolean withAttachmentEnrichment) throws IOException {
        List<Article> articles = this.articlesDAO.listUnsafe(projectKey);
        if (withAttachmentEnrichment) {
            for (Article article : articles) {
                for (Article.ArticleAttachment attachment : article.attachments) {
                    if (!StringUtils.isNotBlank((CharSequence)attachment.getObjectSmartId())) continue;
                    try {
                        this.enrichmentService.enrich(attachment, projectKey);
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Failed to enrich wiki article pkey=" + projectKey + " article=" + article.id + " attachement=" + attachment.getObjectSmartId()), (Throwable)e);
                    }
                }
            }
        }
        return articles;
    }

    public Article getArticleOrNull(String projectKey, String articleId) throws IOException {
        Article article = (Article)this.articlesDAO.getOrNull(projectKey, articleId);
        if (article != null) {
            for (Article.ArticleAttachment attachment : article.attachments) {
                if (!StringUtils.isNotBlank((CharSequence)attachment.getObjectSmartId())) continue;
                try {
                    this.enrichmentService.enrich(attachment, projectKey);
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to enrich wiki article pkey=" + projectKey + " article=" + article.id + " attachement=" + attachment.getObjectSmartId()), (Throwable)e);
                }
            }
        }
        return article;
    }

    public Article getArticleOrNullUnsafe(String projectKey, String articleId) throws IOException {
        Article article = (Article)this.articlesDAO.getOrNullUnsafe(projectKey, articleId);
        if (article != null) {
            for (Article.ArticleAttachment attachment : article.attachments) {
                if (!StringUtils.isNotBlank((CharSequence)attachment.getObjectSmartId())) continue;
                try {
                    this.enrichmentService.enrich(attachment, projectKey);
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to enrich wiki article pkey=" + projectKey + " article=" + article.id + " attachement=" + attachment.getObjectSmartId()), (Throwable)e);
                }
            }
        }
        return article;
    }

    public Article getArticleMandatory(String projectKey, String articleId) throws IOException {
        Article article = (Article)this.articlesDAO.getMandatory(projectKey, articleId);
        for (Article.ArticleAttachment attachment : article.attachments) {
            if (!StringUtils.isNotBlank((CharSequence)attachment.getObjectSmartId())) continue;
            try {
                this.enrichmentService.enrich(attachment, projectKey);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to enrich wiki article pkey=" + projectKey + " article=" + article.id + " attachement=" + attachment.getObjectSmartId()), (Throwable)e);
            }
        }
        return article;
    }

    public Article getArticleMandatoryUnsafe(String projectKey, String articleId) throws IOException {
        Article article = (Article)this.articlesDAO.getMandatoryUnsafe(projectKey, articleId);
        for (Article.ArticleAttachment attachment : article.attachments) {
            if (!StringUtils.isNotBlank((CharSequence)attachment.getObjectSmartId())) continue;
            try {
                this.enrichmentService.enrich(attachment, projectKey);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to enrich wiki article pkey=" + projectKey + " article=" + article.id + " attachement=" + attachment.getObjectSmartId()), (Throwable)e);
            }
        }
        return article;
    }

    public Article getArticleFromNameMandatoryUnsafe(String projectKey, String articleName) throws IOException {
        String articleId = this.articlesCacheService.getIdFromName(projectKey, articleName);
        if (articleId == null) {
            throw new NotFoundException(String.format("Article %s does not exist in %s", articleName, projectKey));
        }
        return this.getArticleMandatoryUnsafe(projectKey, articleId);
    }

    public Article getArticleFromNameOrNullUnsafe(String projectKey, String articleName) throws IOException {
        String articleId = this.articlesCacheService.getIdFromName(projectKey, articleName);
        if (articleId == null) {
            return null;
        }
        return this.getArticleOrNullUnsafe(projectKey, articleId);
    }

    public Article getSmartArticleMandatoryUnsafe(String projectKey, String articleIdOrName) throws IOException {
        Article retrievedArticle;
        if (StringUtils.isNumeric((CharSequence)articleIdOrName) && (retrievedArticle = this.getArticleOrNullUnsafe(projectKey, articleIdOrName)) != null) {
            return retrievedArticle;
        }
        return this.getArticleFromNameMandatoryUnsafe(projectKey, articleIdOrName);
    }

    @Nullable
    public Article getSmartArticleUnsafe(String projectKey, String articleIdOrName) throws IOException {
        Article retrievedArticle;
        if (StringUtils.isNumeric((CharSequence)articleIdOrName) && (retrievedArticle = this.getArticleOrNullUnsafe(projectKey, articleIdOrName)) != null) {
            return retrievedArticle;
        }
        return this.getArticleFromNameOrNullUnsafe(projectKey, articleIdOrName);
    }

    public String getArticlePayloadOrNull(String projectKey, String articleId) throws IOException {
        return this.articlesDAO.getPayloadOrNull(projectKey, articleId);
    }

    public List<String> getArticleChildrenIds(String projectKey, String articleId) throws IOException {
        Wiki wiki = this.wikisDAO.get(projectKey);
        Wiki.WikiTaxonomyNode node = this.getNodeById(wiki.taxonomy, articleId);
        ArrayList childrenIds = Lists.newArrayList();
        if (node != null) {
            for (Wiki.WikiTaxonomyNode child : node.children) {
                childrenIds.add(child.id);
            }
        }
        return childrenIds;
    }

    public List<String> getRootArticlesIds(String projectKey) throws IOException {
        ArrayList articles = Lists.newArrayList();
        List<Wiki.WikiTaxonomyNode> taxonomy = this.wikisDAO.get((String)projectKey).taxonomy;
        if (taxonomy != null) {
            for (Wiki.WikiTaxonomyNode child : taxonomy) {
                articles.add(child.id);
            }
        }
        return articles;
    }

    public Article createArticle(String projectKey, String articleName, String parent, ArticlesTemplatesService.ArticleTemplateDesc templateDesc) throws Exception {
        Wiki wiki = this.wikisDAO.get(projectKey);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{parent})) {
            this.checkExists(wiki, parent);
        }
        this.checkHasUniqueName(wiki, null, articleName);
        AuthCtx authCtx = TransactionContext.retrieveWrite().getUser();
        Article article = new Article();
        article.projectKey = projectKey;
        article.name = articleName;
        article.id = this.articlesCacheService.computeNextId(projectKey);
        article.layout = Article.ArticleLayout.WIKI_ARTICLE;
        this.taggableObjectsService.handleCreationVersionTagOnObjectCreation(article);
        this.customFieldsService.enrichWithDefaultCustomFieldsForTaggableObject(article);
        String payload = null;
        if (templateDesc != null) {
            article.layout = templateDesc.layout;
            File templateFolder = this.articlesTemplatesService.getTemplateDir(templateDesc);
            File scriptFile = new File(templateFolder, "template.md");
            if (scriptFile.exists()) {
                payload = DKUFileUtils.readFileToStringUTF8((File)scriptFile);
            } else {
                logger.info((Object)("Empty report template: " + templateDesc.id));
            }
        }
        this.customPolicyHooksRegistry.onPreObjectSave(authCtx, null, article);
        this.articlesDAO.save(article, payload);
        this.addToTaxonomy(wiki, article.id, parent);
        this.wikisDAO.save(wiki);
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", article.name);
        TaggableObjectChangedEvent.ActionType action = TaggableObjectChangedEvent.ActionType.ARTICLE_CREATE;
        this.taggingService.onObjectSaved(article.projectKey, article.tags);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.ARTICLE, article.projectKey, article.id, authCtx, action).withDetails(details));
        for (Article.ArticleAttachment attachment : article.attachments) {
            this.enrichmentService.enrich(attachment, projectKey);
        }
        return article;
    }

    public Article addAttachment(Article article, Article.ArticleAttachment articleAttachment) throws IOException, CodedException, UnauthorizedException {
        Wiki wiki = this.wikisDAO.get(article.projectKey);
        this.checkExists(wiki, article.id);
        this.checkNoAttachmentsDuplicates(article);
        AuthCtx authCtx = TransactionContext.retrieveWrite().getUser();
        Article preExisting = (Article)this.articlesDAO.getOrNullUnsafe(article.projectKey, article.id);
        article.attachments.clear();
        article.attachments.addAll(preExisting.attachments);
        if (articleAttachment.attachmentType.equals((Object)Article.ArticleAttachmentType.DSS_OBJECT)) {
            boolean newAttachment = true;
            for (Article.ArticleAttachment attachment : article.attachments) {
                this.checkAttachment(attachment);
                if (attachment.taggableType == null || !attachment.taggableType.equals((Object)articleAttachment.taggableType) || !attachment.smartId.equals(articleAttachment.smartId)) continue;
                newAttachment = false;
            }
            if (newAttachment) {
                article.attachments.add(articleAttachment);
            }
        } else {
            article.attachments.add(articleAttachment);
        }
        this.taggableObjectsService.handleCreationVersionTagOnObjectUpdateNullAllowed(article, preExisting);
        this.deleteUnusedUploads(article);
        this.addUploadedOnAndBy(article);
        this.customPolicyHooksRegistry.onPreObjectSave(authCtx, (TaggableObjectsService.TaggableObject)this.articlesDAO.getOrNull(article.projectKey, article.id), article);
        this.checkUploadedAttachmentFileExtensions(preExisting, article);
        this.articlesDAO.save(article, null);
        for (Article.ArticleAttachment attachment : article.attachments) {
            this.enrichmentService.enrich(attachment, article.projectKey);
        }
        return article;
    }

    public Article deleteAttachment(Article article, Article.ArticleAttachment articleAttachment) throws IOException, CodedException {
        Wiki wiki = this.wikisDAO.get(article.projectKey);
        this.checkExists(wiki, article.id);
        this.checkNoAttachmentsDuplicates(article);
        AuthCtx authCtx = TransactionContext.retrieveWrite().getUser();
        Article preExisting = (Article)this.articlesDAO.getOrNullUnsafe(article.projectKey, article.id);
        article.attachments.clear();
        article.attachments.addAll(preExisting.attachments);
        int removeAttachmentIndex = -1;
        for (Article.ArticleAttachment attachment : article.attachments) {
            this.checkAttachment(attachment);
            if (!attachment.smartId.equals(articleAttachment.smartId) || (attachment.taggableType == null || !attachment.taggableType.equals((Object)articleAttachment.taggableType)) && (!Article.ArticleAttachmentType.FILE.equals((Object)attachment.attachmentType) || !Article.ArticleAttachmentType.FILE.equals((Object)articleAttachment.attachmentType))) continue;
            removeAttachmentIndex = article.attachments.indexOf(attachment);
            break;
        }
        if (removeAttachmentIndex != -1) {
            article.attachments.remove(removeAttachmentIndex);
        }
        this.taggableObjectsService.handleCreationVersionTagOnObjectUpdateNullAllowed(article, preExisting);
        this.deleteUnusedUploads(article);
        this.addUploadedOnAndBy(article);
        this.customPolicyHooksRegistry.onPreObjectSave(authCtx, (TaggableObjectsService.TaggableObject)this.articlesDAO.getOrNull(article.projectKey, article.id), article);
        this.articlesDAO.save(article, null);
        for (Article.ArticleAttachment attachment : article.attachments) {
            this.enrichmentService.enrich(attachment, article.projectKey);
        }
        return article;
    }

    public Article saveArticle(Article article, String payload) throws IOException, CodedException, UnauthorizedException {
        TaggableObjectChangedEvent.ActionType action;
        Wiki wiki = this.wikisDAO.get(article.projectKey);
        this.checkExists(wiki, article.id);
        this.checkHasUniqueName(wiki, article.id, article.name);
        this.checkSizeLimit(payload);
        AuthCtx authCtx = TransactionContext.retrieveWrite().getUser();
        Article preExisting = (Article)this.articlesDAO.getOrNullUnsafe(article.projectKey, article.id);
        this.taggableObjectsService.handleCreationVersionTagOnObjectUpdateNullAllowed(article, preExisting);
        this.deleteUnusedUploads(article);
        this.addUploadedOnAndBy(article);
        this.customPolicyHooksRegistry.onPreObjectSave(authCtx, (TaggableObjectsService.TaggableObject)this.articlesDAO.getOrNull(article.projectKey, article.id), article);
        this.checkUploadedAttachmentFileExtensions(preExisting, article);
        this.articlesDAO.save(article, payload);
        boolean rename = preExisting != null && !StringUtils.equals((CharSequence)preExisting.name, (CharSequence)article.name);
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", article.name);
        if (rename) {
            details.addProperty("oldName", preExisting.name);
            details.addProperty("newName", article.name);
        }
        if (rename) {
            action = TaggableObjectChangedEvent.ActionType.ARTICLE_RENAME;
        } else {
            action = TaggableObjectChangedEvent.ActionType.ARTICLE_EDIT;
            TaggableObjectDiffService.addTagEditInfoIfNeeded(preExisting, article, details);
        }
        this.taggingService.onObjectSaved(article.projectKey, article.tags);
        this.pubSub.publishAfterTransactionWithDebounce("WikiArticleEdition." + authCtx.getIdentifier() + "." + article.projectKey + "." + article.id, new TaggableObjectChangedEvent(ITaggingService.TaggableType.ARTICLE, article.projectKey, article.id, authCtx, action).withDetails(details), this.generalSettingsDAO.read().debounceDelayForWikiArticleSave);
        for (Article.ArticleAttachment attachment : article.attachments) {
            this.enrichmentService.enrich(attachment, article.projectKey);
        }
        return article;
    }

    public void changeArticleParent(String projectKey, String id, String parentId) throws IOException {
        List<Wiki.WikiTaxonomyNode> newSiblings;
        Wiki wiki = this.wikisDAO.get(projectKey);
        this.checkExists(wiki, id);
        Wiki.WikiTaxonomyNode articleNode = this.getNodeById(wiki.taxonomy, id);
        List<Wiki.WikiTaxonomyNode> oldSiblings = this.getSiblings(wiki.taxonomy, articleNode);
        if (oldSiblings == null) {
            throw ErrorContext.iaef((String)"Cannot find siblings of article (%s.%s)", (Object)projectKey, (Object[])new Object[]{id});
        }
        if (StringUtils.isBlank((CharSequence)parentId)) {
            newSiblings = wiki.taxonomy;
        } else {
            this.checkANotAscendantOfBOrSelf(wiki, id, parentId);
            Wiki.WikiTaxonomyNode newParentNode = this.getNodeById(wiki.taxonomy, parentId);
            if (newParentNode == null) {
                throw ErrorContext.iaef((String)"Parent article (%s.%s) does not exist", (Object)projectKey, (Object[])new Object[]{parentId});
            }
            newSiblings = newParentNode.children;
        }
        oldSiblings.remove(articleNode);
        newSiblings.add(articleNode);
        this.wikisDAO.save(wiki);
    }

    public void setWiki(Wiki wiki) throws IOException {
        assert (wiki != null);
        assert (wiki.projectKey != null);
        this.checkTaxonomy(wiki);
        if (wiki.homeArticleId != null) {
            this.checkExists(wiki, wiki.homeArticleId);
        }
        this.wikisDAO.save(wiki);
    }

    public void deleteArticle(String projectKey, String articleId, boolean deleteChildren) throws IOException, CodedException {
        Wiki wiki = this.wikisDAO.get(projectKey);
        Article article = (Article)this.articlesDAO.getMandatoryUnsafe(projectKey, articleId);
        boolean deleted = this.deleteArticleAndUpdateTaxonomy(projectKey, wiki.taxonomy, articleId, deleteChildren);
        if (deleted && articleId.equals(wiki.homeArticleId)) {
            wiki.homeArticleId = null;
        }
        this.wikisDAO.save(wiki);
        this.deleteFileUploads(article);
        AuthCtx authCtx = TransactionContext.retrieveWrite().getUser();
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", article.name);
        TaggableObjectChangedEvent.ActionType action = TaggableObjectChangedEvent.ActionType.ARTICLE_DELETE;
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.ARTICLE, projectKey, articleId, authCtx, action).withDetails(details));
    }

    public void deleteForProject(String projectKey) {
        try {
            File wikiUploads = ApplicationConfigurator.getFile((String[])new String[]{"wiki-attachments", projectKey});
            if (wikiUploads.exists()) {
                DKUFileUtils.forceDelete((File)wikiUploads);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failed to delete wiki uploads for project " + projectKey), (Throwable)e);
        }
    }

    public File getUploadedFile(String projectKey, String uploadId) throws IOException {
        UploadMeta meta = this.getUploadMeta(projectKey, uploadId);
        return this.getUploadedFile(projectKey, uploadId, meta.fileName);
    }

    public String generateUniqueAttachmentId(String projectKey) {
        for (int i = 0; i < 10; ++i) {
            String newUploadId = SecretKeyGenerator.generate((int)12);
            if (this.getUploadFolder(projectKey, newUploadId).exists()) continue;
            return newUploadId;
        }
        throw new RuntimeException("Failed to generate a unique id for attachment");
    }

    public Article.ArticleAttachment copyUploadFile(String projectKey, Article.ArticleAttachment att, AuthCtx authCtx) throws IOException {
        String newUploadId = this.generateUniqueAttachmentId(projectKey);
        File parentDir = this.getUploadFolder(projectKey, att.smartId);
        File targetDir = this.getUploadFolder(projectKey, newUploadId);
        DKUFileUtils.copyDirectory((File)parentDir, (File)targetDir);
        Article.ArticleAttachment newAtt = new Article.ArticleAttachment();
        newAtt.attachmentType = Article.ArticleAttachmentType.FILE;
        newAtt.smartId = newUploadId;
        newAtt.details = att.details;
        newAtt.attachedOn = System.currentTimeMillis();
        newAtt.attachedBy = authCtx.getIdentifier();
        return newAtt;
    }

    public UploadMeta getUploadMeta(String projectKey, String uploadId) throws IOException {
        File f = this.getUploadMetaFile(projectKey, uploadId);
        return (UploadMeta)JSON.parseFile((File)f, UploadMeta.class);
    }

    public Callable<Article.ArticleAttachment> handleUploadRequest(final String projectKey, final InputStream is, final String fileName, final AuthCtx authCtx) {
        final String uploadId = SecretKeyGenerator.generate((int)12);
        return new Callable<Article.ArticleAttachment>(){

            @Override
            public Article.ArticleAttachment call() throws Exception {
                File outFile = WikisService.this.getUploadedFile(projectKey, uploadId, fileName);
                outFile.getParentFile().mkdirs();
                if (!outFile.createNewFile()) {
                    throw new IllegalArgumentException("Uploaded file already exists");
                }
                try (FileOutputStream os = new FileOutputStream(outFile);){
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                String ext = FilenameUtils.getExtension((String)fileName);
                Article.ArticleAttachment att = new Article.ArticleAttachment();
                att.attachmentType = Article.ArticleAttachmentType.FILE;
                att.smartId = uploadId;
                att.details.addProperty("objectDisplayName", fileName);
                att.details.addProperty("size", (Number)outFile.length());
                att.attachedOn = System.currentTimeMillis();
                att.attachedBy = authCtx.getIdentifier();
                MimeTypeUtils.MimeType mt = MimeTypeUtils.fromExtension((String)ext);
                if (mt != null) {
                    att.details.addProperty("mimeType", mt.mimeType);
                }
                return att;
            }
        };
    }

    private File getUploadedFile(String projectKey, String uploadId, String fileName) {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{projectKey}), (Object)"Project key not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{uploadId}), (Object)"Upload id not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{fileName}), (Object)"File name not specified");
        return ApplicationConfigurator.getFile((String[])new String[]{"wiki-attachments", projectKey, uploadId, fileName});
    }

    private File getUploadFolder(String projectKey, String uploadId) {
        return ApplicationConfigurator.getFile((String[])new String[]{"wiki-attachments", projectKey, uploadId});
    }

    private File getUploadMetaFile(String projectKey, String uploadId) {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{projectKey}), (Object)"Project key not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{uploadId}), (Object)"Upload id not specified");
        return ApplicationConfigurator.getFile((String[])new String[]{"wiki-attachments", projectKey, uploadId, "meta.json"});
    }

    private void addToTaxonomy(Wiki wiki, String articleId, String parentId) throws NotFoundException {
        if (StringUtils.isNotBlank((CharSequence)parentId)) {
            if (wiki.taxonomy == null || wiki.taxonomy.isEmpty()) {
                throw new IllegalArgumentException("Empty wiki, cannot add an article with a parent");
            }
            Wiki.WikiTaxonomyNode parentNode = this.getNodeById(wiki.taxonomy, parentId);
            if (parentNode == null) {
                throw new NotFoundException("Article does not exist: " + parentId);
            }
            parentNode.children.add(new Wiki.WikiTaxonomyNode(articleId));
        } else if (wiki.taxonomy == null || wiki.taxonomy.isEmpty()) {
            wiki.taxonomy = Lists.newArrayList((Object[])new Wiki.WikiTaxonomyNode[]{new Wiki.WikiTaxonomyNode(articleId)});
        } else {
            wiki.taxonomy.add(new Wiki.WikiTaxonomyNode(articleId));
        }
    }

    private boolean deleteArticleAndUpdateTaxonomy(String projectKey, List<Wiki.WikiTaxonomyNode> nodes, String articleId, boolean deleteChildren) throws IOException, CodedException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        Iterator<Wiki.WikiTaxonomyNode> iter = nodes.iterator();
        while (iter.hasNext()) {
            Wiki.WikiTaxonomyNode node = iter.next();
            if (node.id.equals(articleId)) {
                List<Wiki.WikiTaxonomyNode> children = node.children;
                iter.remove();
                this.customPolicyHooksRegistry.onPreObjectDelete(t.getUser(), (TaggableObjectsService.TaggableObject)this.articlesDAO.getOrNull(projectKey, node.id));
                this.articlesDAO.delete(projectKey, node.id);
                if (!deleteChildren) {
                    nodes.addAll(children);
                } else {
                    for (Wiki.WikiTaxonomyNode child : children) {
                        this.customPolicyHooksRegistry.onPreObjectDelete(t.getUser(), (TaggableObjectsService.TaggableObject)this.articlesDAO.getOrNull(projectKey, child.id));
                        this.articlesDAO.delete(projectKey, child.id);
                    }
                }
                return true;
            }
            if (!this.deleteArticleAndUpdateTaxonomy(projectKey, node.children, articleId, deleteChildren)) continue;
            return true;
        }
        return false;
    }

    private Wiki.WikiTaxonomyNode getNodeById(List<Wiki.WikiTaxonomyNode> nodes, String needle) {
        if (nodes == null) {
            return null;
        }
        for (Wiki.WikiTaxonomyNode node : nodes) {
            if (node.id.equals(needle)) {
                return node;
            }
            Wiki.WikiTaxonomyNode found = this.getNodeById(node.children, needle);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private List<Wiki.WikiTaxonomyNode> getSiblings(List<Wiki.WikiTaxonomyNode> rootSiblings, Wiki.WikiTaxonomyNode needle) {
        if (rootSiblings == null) {
            return null;
        }
        if (rootSiblings.contains(needle)) {
            return rootSiblings;
        }
        for (Wiki.WikiTaxonomyNode rootSibling : rootSiblings) {
            List<Wiki.WikiTaxonomyNode> foundSiblings = this.getSiblings(rootSibling.children, needle);
            if (foundSiblings == null) continue;
            return foundSiblings;
        }
        return null;
    }

    private List<String> getAscendantList(List<Wiki.WikiTaxonomyNode> rootSiblings, Wiki.WikiTaxonomyNode needle) {
        if (rootSiblings == null) {
            return null;
        }
        if (rootSiblings.contains(needle)) {
            return Lists.newArrayList();
        }
        for (Wiki.WikiTaxonomyNode sibling : rootSiblings) {
            List<String> subAscendantList = this.getAscendantList(sibling.children, needle);
            if (subAscendantList == null) continue;
            subAscendantList.add(0, sibling.id);
            return subAscendantList;
        }
        return null;
    }

    @VisibleForTesting
    void checkHasUniqueName(Wiki wiki, String articleId, String articleName) throws IOException {
        if (StringUtils.isBlank((CharSequence)articleName) || ".".equals(articleName) || "..".equals(articleName)) {
            throw ErrorContext.iae((String)"Article name is invalid");
        }
        if (!this.articlesCacheService.isNameUnique(wiki.projectKey, articleId, articleName)) {
            throw ErrorContext.iaef((String)"Article %s already exists in %s", (Object)articleName, (Object[])new Object[]{wiki.projectKey});
        }
    }

    @VisibleForTesting
    void checkExists(Wiki wiki, String articleId) {
        if (StringUtils.isBlank((CharSequence)articleId)) {
            throw ErrorContext.iae((String)"Article id is empty");
        }
        if (this.getNodeById(wiki.taxonomy, articleId) == null) {
            throw ErrorContext.iaef((String)"Article %s.%s does not exist", (Object)wiki.projectKey, (Object[])new Object[]{articleId});
        }
    }

    private void checkANotAscendantOfBOrSelf(Wiki wiki, String articleA, String articleB) {
        if (StringUtils.isBlank((CharSequence)articleA) || StringUtils.isBlank((CharSequence)articleB)) {
            throw ErrorContext.iae((String)"Article id is empty");
        }
        if (articleA.equals(articleB)) {
            throw ErrorContext.iaef((String)"Article (%s.%s) cannot be its own parent", (Object)wiki.projectKey, (Object[])new Object[]{articleA});
        }
        Wiki.WikiTaxonomyNode articleBNode = this.getNodeById(wiki.taxonomy, articleB);
        if (articleBNode == null) {
            throw ErrorContext.iaef((String)"Article %s.%s does not exist", (Object)wiki.projectKey, (Object[])new Object[]{articleBNode});
        }
        List<String> articleBAscendantList = this.getAscendantList(wiki.taxonomy, articleBNode);
        if (articleBAscendantList != null && articleBAscendantList.contains(articleA)) {
            throw ErrorContext.iaef((String)"Selected parent (%s.%s) cannot be descendant of article (%s.%s)", (Object)wiki.projectKey, (Object[])new Object[]{articleB, wiki.projectKey, articleA});
        }
    }

    private List<String> buildAndCheckArticleList(String projectKey, List<Wiki.WikiTaxonomyNode> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return Lists.newArrayList();
        }
        ArrayList articleIdList = Lists.newArrayList();
        for (Wiki.WikiTaxonomyNode node : nodes) {
            List<String> childIds = this.buildAndCheckArticleList(projectKey, node.children);
            for (String childId : childIds) {
                if (!articleIdList.contains(childId)) continue;
                throw ErrorContext.iaef((String)"Duplicate article %s.%s", (Object)projectKey, (Object[])new Object[]{childId});
            }
            articleIdList.addAll(childIds);
            if (articleIdList.contains(node.id)) {
                throw ErrorContext.iaef((String)"Duplicate article %s.%s", (Object)projectKey, (Object[])new Object[]{node.id});
            }
            articleIdList.add(node.id);
        }
        return articleIdList;
    }

    public void saveUploadMeta(String projectKey, Article.ArticleAttachment att, String fileName, AuthCtx authCtx) throws IOException {
        UploadMeta meta = new UploadMeta();
        meta.fileName = fileName;
        meta.uploadedBy = authCtx.getIdentifier();
        meta.uploadedOn = System.currentTimeMillis();
        meta.mimeType = att.details.get("mimeType") != null ? att.details.get("mimeType").getAsString() : null;
        DKUFileUtils.writeFileUTF8((File)this.getUploadMetaFile(projectKey, att.smartId), (String)JSON.pretty((Object)meta));
    }

    private void checkTaxonomy(Wiki wiki) throws IOException {
        assert (wiki != null);
        assert (wiki.projectKey != null);
        List<String> taxonomyArticleIdList = this.buildAndCheckArticleList(wiki.projectKey, wiki.taxonomy);
        List articleList = this.articlesDAO.listUnsafe(wiki.projectKey);
        if (taxonomyArticleIdList.size() != articleList.size()) {
            throw ErrorContext.iaef((String)"Number of article in taxonomy is not correct (it is %d but should be %d)", (Object)taxonomyArticleIdList.size(), (Object[])new Object[]{articleList.size()});
        }
        for (Article article : articleList) {
            if (taxonomyArticleIdList.contains(article.id)) continue;
            throw ErrorContext.iaef((String)"Article not present in taxonomy %s.%s", (Object)wiki.projectKey, (Object[])new Object[]{article.id});
        }
    }

    public void deleteFileUploads(Article article) {
        for (Article.ArticleAttachment attachment : article.attachments) {
            logger.warn((Object)("Att" + String.valueOf((Object)attachment.attachmentType)));
            if (attachment.attachmentType != Article.ArticleAttachmentType.FILE) continue;
            this.deleteFileUpload(article.projectKey, attachment.smartId);
        }
    }

    private void deleteUnusedUploads(Article newArticle) throws IOException {
        Article oldArticle = (Article)this.articlesDAO.getOrNullUnsafe(newArticle.projectKey, newArticle.id);
        if (oldArticle == null) {
            return;
        }
        block0: for (Article.ArticleAttachment oldAtt : oldArticle.attachments) {
            for (Article.ArticleAttachment newAtt : newArticle.attachments) {
                Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{newAtt.smartId}), (Object)"Article attachments should have an id");
                if (!newAtt.smartId.equals(oldAtt.smartId)) continue;
                continue block0;
            }
            if (oldAtt.attachmentType != Article.ArticleAttachmentType.FILE) continue;
            this.deleteFileUpload(oldArticle.projectKey, oldAtt.smartId);
        }
    }

    private void addUploadedOnAndBy(Article newArticle) throws IOException {
        Article oldArticle = (Article)this.articlesDAO.getOrNullUnsafe(newArticle.projectKey, newArticle.id);
        if (oldArticle == null) {
            return;
        }
        block0: for (Article.ArticleAttachment newAtt : newArticle.attachments) {
            String login;
            for (Article.ArticleAttachment oldAtt : oldArticle.attachments) {
                if (!newAtt.smartId.equals(oldAtt.smartId)) continue;
                if (oldAtt.attachedBy != null && !oldAtt.attachedBy.equals(newAtt.attachedBy)) {
                    throw new IllegalArgumentException("Cannot change attachedBy attribute");
                }
                if (oldAtt.attachedOn == newAtt.attachedOn) continue block0;
                throw new IllegalArgumentException("Cannot change attachedOn attribute");
            }
            newAtt.attachedBy = login = TransactionContext.retrieveWrite().getUser().getIdentifier();
            newAtt.attachedOn = System.currentTimeMillis();
        }
    }

    private void deleteFileUpload(String projectKey, String id) {
        try {
            File dir = this.getUploadFolder(projectKey, id);
            DKUFileUtils.forceDelete((File)dir);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to delete uploaded file", (Throwable)e);
        }
    }

    @VisibleForTesting
    void checkSizeLimit(String payload) {
        if (payload != null && payload.length() > 16000000) {
            throw new IllegalArgumentException("The article content is too long, maximum length is 16000000 characters");
        }
    }

    private void checkNoAttachmentsDuplicates(Article article) {
        for (int i = 0; i < article.attachments.size(); ++i) {
            Article.ArticleAttachment ai = article.attachments.get(i);
            this.checkAttachment(ai);
            for (int j = i + 1; j < article.attachments.size(); ++j) {
                Article.ArticleAttachment aj = article.attachments.get(j);
                this.checkAttachment(aj);
                if (ai.taggableType == null || !ai.taggableType.equals((Object)aj.taggableType) || !ai.smartId.equals(aj.smartId)) continue;
                throw new IllegalArgumentException("Duplicate attachment: " + String.valueOf((Object)ai.taggableType) + " " + ai.smartId);
            }
        }
    }

    private void checkAttachment(Article.ArticleAttachment attachment) {
        if (StringUtils.isBlank((CharSequence)attachment.smartId)) {
            throw new IllegalArgumentException("Invalid attachment: no id specified");
        }
        if (attachment.attachmentType == null) {
            throw new IllegalArgumentException("Invalid attachment: no attachment type specified");
        }
        if (attachment.attachmentType == Article.ArticleAttachmentType.DSS_OBJECT && attachment.taggableType == null) {
            throw new IllegalArgumentException("Invalid attachment: no taggable type specified");
        }
    }

    public long getLastModifiedOn(String projectKey) throws IOException {
        long lastModified = -1L;
        for (Article article : this.listArticlesUnsafe(projectKey)) {
            long articleLastModified = article.versionTag.getLastModifiedOn();
            if (articleLastModified <= lastModified) continue;
            lastModified = articleLastModified;
        }
        return lastModified;
    }

    public void checkUploadedAttachmentFileExtensions(@Nullable Article existing, Article changed) throws UnauthorizedException {
        Map<String, String> existingAttachments = existing == null ? null : existing.attachments.stream().filter(att -> att.attachmentType == Article.ArticleAttachmentType.FILE && att.getFileDisplayName() != null).collect(Collectors.toMap(att -> att.smartId, Article.ArticleAttachment::getFileDisplayName));
        List<Article.ArticleAttachment> forbiddenUploadedAttachments = this.listForbiddenUploadedAttachments(changed, existingAttachments);
        if (!forbiddenUploadedAttachments.isEmpty()) {
            String forbiddenExtensionsFormatted = forbiddenUploadedAttachments.stream().filter(att -> att.getFileDisplayName() != null).map(att -> {
                String extension = FilenameUtils.getExtension((String)att.getFileDisplayName()).toLowerCase(Locale.ROOT);
                return "." + extension;
            }).distinct().sorted(String::compareTo).collect(Collectors.joining(", "));
            throw new UnauthorizedException("Your instance settings doesn't allow this type of files to be added as attachment to wikis: " + forbiddenExtensionsFormatted, "Unauthorized");
        }
    }

    public void checkNewUploadedAttachmentFileExtension(String filename) throws UnauthorizedException {
        String authorisedExtensions = DKUApp.getProperty((String)ATTACHMENT_EXTENSIONS_WHITELIST_DIP_PROPERTY, null);
        if (authorisedExtensions == null) {
            return;
        }
        String extension = FilenameUtils.getExtension((String)filename).toLowerCase(Locale.ROOT);
        boolean hasUnauthorizedAttachments = Arrays.stream(authorisedExtensions.split(",")).noneMatch(ext -> ext.equals(extension));
        if (hasUnauthorizedAttachments) {
            throw new UnauthorizedException("Your instance settings doesn't allow this type of files to be added as attachment to wikis: ." + extension, "Unauthorized");
        }
    }

    public List<Article.ArticleAttachment> listForbiddenUploadedAttachments(Article article, @Nullable Map<String, String> authorized) {
        Set<String> authorisedExtensionsSet = this.getAuthorizedExtensions();
        if (authorisedExtensionsSet == null) {
            return Collections.emptyList();
        }
        HashMap authorizedResolved = authorized == null ? new HashMap() : authorized;
        return article.attachments.stream().filter(att -> att.attachmentType == Article.ArticleAttachmentType.FILE).filter(att -> !authorizedResolved.containsKey(att.smartId) || !StringUtils.equals((CharSequence)((CharSequence)authorizedResolved.get(att.smartId)), (CharSequence)att.getFileDisplayName())).filter(att -> {
            String extension = FilenameUtils.getExtension((String)att.getFileDisplayName());
            return extension != null && !authorisedExtensionsSet.contains(extension.toLowerCase(Locale.ROOT));
        }).collect(Collectors.toList());
    }

    public boolean removeForbiddenAttachments(String projectKey) throws IOException {
        if (this.getAuthorizedExtensions() == null) {
            return false;
        }
        boolean anyChange = false;
        for (Article article : this.articlesDAO.list(projectKey)) {
            boolean articleChange = false;
            for (Article.ArticleAttachment att : this.listForbiddenUploadedAttachments(article, null)) {
                article.attachments.remove(att);
                this.deleteFileUpload(projectKey, att.smartId);
                articleChange = true;
            }
            if (!articleChange) continue;
            this.articlesDAO.save(article, null);
            anyChange = true;
        }
        return anyChange;
    }

    @Nullable
    public Set<String> getAuthorizedExtensions() {
        String authorisedExtensions = DKUApp.getProperty((String)ATTACHMENT_EXTENSIONS_WHITELIST_DIP_PROPERTY, null);
        if (authorisedExtensions == null) {
            return null;
        }
        return Arrays.stream(authorisedExtensions.split(",")).map(ext -> ext.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
    }

    public static class UploadMeta {
        public String mimeType;
        public String fileName;
        public String uploadedBy;
        public long uploadedOn;
    }

    public static class ArticleWithRecentAttachment {
        public Article article;
        public Article.ArticleAttachment articleAttachment;

        public ArticleWithRecentAttachment(Article article, Article.ArticleAttachment articleAttachment) {
            this.article = article;
            this.articleAttachment = articleAttachment;
        }
    }
}

