/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.geoip.fastgeo.builder;

import com.dataiku.geoip.fastgeo.FastGeoIP2;
import com.dataiku.geoip.fastgeo.builder.RangeTableBuilder;
import com.dataiku.geoip.mmdb.Reader;
import com.dataiku.geoip.uniquedb.InvalidDatabaseException;
import com.dataiku.geoip.uniquedb.UniqueDB;
import com.dataiku.geoip.uniquedb.builder.NodeBuilder;
import com.dataiku.geoip.uniquedb.builder.UniqueDBBuilder;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.commons.lang.mutable.MutableInt;

public class FastGeoIP2Builder {
    private final DecimalFormat latitudeFormat;
    private final DecimalFormat longitudeFormat;
    private RangeTableBuilder ipv4Table;
    private RangeTableBuilder ipv6Table;
    private UniqueDBBuilder db;
    private File geoliteFile;

    public FastGeoIP2Builder(File mmdbFile) {
        this.geoliteFile = mmdbFile;
        this.latitudeFormat = new DecimalFormat("#");
        this.latitudeFormat.setMaximumFractionDigits(4);
        this.latitudeFormat.setMinimumIntegerDigits(1);
        this.latitudeFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        this.longitudeFormat = this.latitudeFormat;
    }

    public FastGeoIP2 build(final Listener listener) throws IOException {
        FastGeoIP2 fastGeoIP2;
        this.db = new UniqueDBBuilder();
        final Reader geoliteDatabase = new Reader(this.geoliteFile);
        try {
            this.ipv4Table = new RangeTableBuilder(this.db, 1);
            this.ipv6Table = new RangeTableBuilder(this.db, 2);
            final MutableInt i = new MutableInt(0);
            geoliteDatabase.visit(128, new Reader.IpVisitor(){

                @Override
                public void visit(InetAddress addr) throws IOException {
                    JsonNode node = geoliteDatabase.get(addr);
                    FastGeoIP2Builder.this.insert(addr, node);
                    if (listener != null) {
                        listener.progress(i.intValue());
                    }
                    i.increment();
                }
            });
            this.db.root().add(1181889348);
            this.db.root().add(2);
            this.db.root().add(this.ipv4Table);
            this.db.root().add(this.ipv6Table);
            UniqueDB udb = this.db.constructDatabase();
            fastGeoIP2 = new FastGeoIP2(udb);
        }
        catch (Throwable throwable) {
            try {
                try {
                    geoliteDatabase.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (InvalidDatabaseException e) {
                throw new RuntimeException("This is a bug: the FastGeoIP2Builder generated an invalid database", e);
            }
        }
        geoliteDatabase.close();
        return fastGeoIP2;
    }

    private void insert(InetAddress address, JsonNode node) {
        int[] ip;
        NodeBuilder ipDetails = null;
        if (node != null) {
            ipDetails = this.buildIpDetails(node, this.db);
        }
        if ((ip = FastGeoIP2.inetToInteger((InetAddress)address))[0] == Integer.MIN_VALUE && ip[1] == Integer.MIN_VALUE && ip[2] == -2147418113) {
            this.ipv4Table.orderedAdd(new int[]{ip[3]}, ipDetails);
        } else if (ip[0] != Integer.MIN_VALUE || ip[1] != Integer.MIN_VALUE || ip[2] != Integer.MIN_VALUE) {
            this.ipv6Table.orderedAdd(new int[]{ip[0], ip[1]}, ipDetails);
        }
    }

    protected NodeBuilder buildIpDetails(JsonNode node, UniqueDBBuilder db) {
        String latitude = this.latitudeFormat.format(node.path("location").path("latitude").asDouble());
        String longitude = this.longitudeFormat.format(node.path("location").path("longitude").asDouble());
        String city = node.path("city").path("names").path("en").asText();
        String postalcode = node.path("postal").path("code").asText();
        String countrycode = node.path("country").path("iso_code").asText();
        String country = node.path("country").path("names").path("en").asText();
        String continentcode = node.path("continent").path("iso_code").asText();
        String continent = node.path("continent").path("names").path("en").asText();
        String timezone = node.path("location").path("time_zone").asText();
        NodeBuilder regions = new NodeBuilder(db);
        JsonNode subdivisions = node.path("subdivisions");
        for (int i = 0; i < subdivisions.size(); ++i) {
            String name = subdivisions.get(i).path("names").path("en").asText();
            String code = subdivisions.get(i).path("iso_code").asText();
            regions.add(new NodeBuilder(db).withSize(false).add(name).add(code));
        }
        NodeBuilder ipDetails = new NodeBuilder(db).withSize(false).add(latitude).add(longitude).add(postalcode).add(city).add(new NodeBuilder(db).withSize(false).add(regions).add(country).add(countrycode).add(timezone).add(new NodeBuilder(db).withSize(false).add(continent).add(continentcode)));
        return ipDetails;
    }

    public static interface Listener {
        public void progress(int var1);
    }
}

