/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.client;

import com.dataiku.common.rpc.APIKeyAuthAPIClient;
import com.dataiku.common.rpc.InternalAPIClient;
import com.dataiku.common.rpc.NoAuthAPIClient;
import com.dataiku.common.server.APIError;
import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.apideployer.datamodel.actual.APIServiceDeploymentHeavyStatus;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.client.BaseLambdaAPIClient;
import com.dataiku.lambda.model.serverconfig.LambdaEndpointConfig;
import com.dataiku.lambda.model.studioconfig.ApiEndpointQuery;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class LambdaAPIClient
implements BaseLambdaAPIClient {
    private static final Logger logger = Logger.getLogger((String)"dku.lambda.test");

    public static BaseLambdaAPIClient.ApiEndpointResponses runQueries(String baseURI, String apiKey, String serviceId, APIServiceDeploymentHeavyStatus.EndpointSummary endpoint, Collection<ApiEndpointQuery> testQueries, boolean trustAllSSLCertificates) throws IOException {
        try (InternalAPIClient client = LambdaAPIClient.getAPIClient(baseURI, apiKey, trustAllSSLCertificates);){
            client.postObject("/ping", Void.class, (Object)new JsonObject());
            BaseLambdaAPIClient.ApiEndpointResponses resps = new BaseLambdaAPIClient.ApiEndpointResponses();
            String path = "/" + serviceId + "/" + endpoint.id + "/" + LambdaAPIClient.getCallName(endpoint.type);
            logger.info((Object)("Queries on API node: " + baseURI));
            for (ApiEndpointQuery tq : testQueries) {
                BaseLambdaAPIClient.ResponseOrError roe = new BaseLambdaAPIClient.ResponseOrError();
                roe.query = tq;
                try {
                    logger.info((Object)("Submit query " + JSON.json((Object)tq)));
                    InternalAPIClient.ResponseStringWithHeaders responseWithHeaders = client.postObjectToStringResponseAndHeaders(path, (Object)tq.q);
                    roe.headers = responseWithHeaders.headers;
                    roe.response = responseWithHeaders.response;
                    if (responseWithHeaders.response != null && responseWithHeaders.headers.stream().anyMatch(h -> ((String)h.first).equalsIgnoreCase("Content-Type") && StringUtils.startsWithIgnoreCase((String)((String)h.second), (String)"application/json"))) {
                        try {
                            roe.response = JSON.parse((String)responseWithHeaders.response, JsonElement.class);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (APIError.APIErrorException e) {
                    logger.warn((Object)("Query " + JSON.json((Object)tq) + " failed"), (Throwable)e);
                    roe.error = new APIError((Throwable)e, !DKUApp.hideErrorStacks(), !DKUApp.hideErrorStacks(), !DKUApp.hideLogTails());
                }
                catch (Exception e) {
                    logger.warn((Object)("Query " + JSON.json((Object)tq) + " failed"), (Throwable)e);
                    roe.error = new SerializedError((Throwable)e, !DKUApp.hideErrorStacks(), !DKUApp.hideErrorStacks(), !DKUApp.hideLogTails());
                }
                resps.responses.add(roe);
            }
            BaseLambdaAPIClient.ApiEndpointResponses apiEndpointResponses = resps;
            return apiEndpointResponses;
        }
    }

    private static InternalAPIClient getAPIClient(String baseURI, String apiKey, boolean trustAllSSLCertificates) {
        if (StringUtils.isBlank((String)apiKey)) {
            return new NoAuthAPIClient(baseURI, trustAllSSLCertificates);
        }
        return new APIKeyAuthAPIClient(baseURI, apiKey, trustAllSSLCertificates);
    }

    private static String getCallName(LambdaEndpointConfig.EndpointType endpointType) {
        switch (endpointType) {
            case STD_PREDICTION: 
            case STD_CAUSAL_PREDICTION: 
            case CUSTOM_PREDICTION: 
            case CUSTOM_R_PREDICTION: 
            case STD_CLUSTERING: {
                return "predict";
            }
            case STD_FORECAST: {
                return "forecast";
            }
            case DATASETS_LOOKUP: {
                return "lookup";
            }
            case PY_FUNCTION: 
            case R_FUNCTION: {
                return "run";
            }
            case SQL_QUERY: {
                return "query";
            }
        }
        throw new Error("Unreachable");
    }
}

