/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;

public class Coalesce
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 0) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " requires at least an argument");
        }
        for (Object arg : args) {
            if (arg == null || "".equals(arg)) continue;
            return arg;
        }
        return null;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Coalesce.DOCUMENTATION", "Returns the first non-null value.").withParams("value1, value2 ...").withReturns("GREL.FUNCTIONS.RETURNS.DEPENDS_ON_ARGUMENTS", "depends on arguments").withCategory("GREL.FUNCTIONS.CATEGORY.STRING", "String functions").withExample(Example.with("\"\"", "\"foo\"", "42").returns("\"foo\""));
    }
}

