/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hive.udf.maps;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class UDAFMapGroupSum
extends AbstractGenericUDAFResolver {
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] tis) throws SemanticException {
        if (tis.length != 1) {
            throw new UDFArgumentTypeException(tis.length - 1, "Exactly one argument is expected.");
        }
        return new MapGroupSumEvaluator();
    }

    public static class MapGroupSumEvaluator
    extends GenericUDAFEvaluator {
        private MapObjectInspector originalDataOI;
        private IntObjectInspector valueOI;
        private StringObjectInspector keyOI;

        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            this.originalDataOI = (MapObjectInspector)parameters[0];
            this.keyOI = (StringObjectInspector)this.originalDataOI.getMapKeyObjectInspector();
            this.valueOI = (IntObjectInspector)this.originalDataOI.getMapValueObjectInspector();
            return ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector);
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer ab) throws HiveException {
            ((MapBuffer)ab).map.clear();
        }

        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            return new MapBuffer();
        }

        protected void mapAppend(Map<String, Integer> m, Map<Object, Object> from) {
            if (from == null) {
                return;
            }
            for (Map.Entry<Object, Object> entry : from.entrySet()) {
                Object okey = entry.getKey();
                Object ovalue = entry.getValue();
                if (okey == null || ovalue == null) continue;
                String key = this.keyOI.getPrimitiveJavaObject(entry.getKey());
                Integer value = this.valueOI.get(entry.getValue());
                if (m.containsKey(key)) {
                    m.put(key, m.get(key) + value);
                    continue;
                }
                m.put(key, value);
            }
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer ab, Object[] parameters) throws HiveException {
            assert (parameters.length == 1);
            Object p = parameters[0];
            if (p != null) {
                MapBuffer agg = (MapBuffer)ab;
                Map o = this.originalDataOI.getMap(p);
                this.mapAppend(agg.map, o);
            }
        }

        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer ab) throws HiveException {
            MapBuffer agg = (MapBuffer)ab;
            return Maps.newHashMap(agg.map);
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer ab, Object p) throws HiveException {
            MapBuffer agg = (MapBuffer)ab;
            Map obj = this.originalDataOI.getMap(p);
            this.mapAppend(agg.map, obj);
        }

        public Object terminate(GenericUDAFEvaluator.AggregationBuffer ab) throws HiveException {
            MapBuffer agg = (MapBuffer)ab;
            return Maps.newHashMap(agg.map);
        }

        static class MapBuffer
        implements GenericUDAFEvaluator.AggregationBuffer {
            Map<String, Integer> map = new HashMap<String, Integer>();

            MapBuffer() {
            }
        }
    }
}

