/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record;

import com.dataiku.dss.shadelibpoi.org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;
import com.dataiku.dss.shadelibpoi.org.apache.poi.common.Duplicatable;
import com.dataiku.dss.shadelibpoi.org.apache.poi.common.usermodel.GenericRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.HSSFRecordTypes;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.RecordBase;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.RecordFactory;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.RecordInputStream;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.GenericRecordJsonWriter;
import java.io.IOException;

public abstract class Record
extends RecordBase
implements Duplicatable,
GenericRecord {
    protected Record() {
    }

    protected Record(Record other) {
    }

    public final byte[] serialize() {
        byte[] retval = new byte[this.getRecordSize()];
        this.serialize(0, retval);
        return retval;
    }

    public final String toString() {
        return GenericRecordJsonWriter.marshal(this);
    }

    public abstract short getSid();

    public Record cloneViaReserialise() {
        byte[] b = this.serialize();
        RecordInputStream rinp = null;
        try {
            rinp = new RecordInputStream(UnsynchronizedByteArrayInputStream.builder().setByteArray(b).get());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        rinp.nextRecord();
        Record[] r = RecordFactory.createRecord(rinp);
        if (r.length != 1) {
            throw new IllegalStateException("Re-serialised a record to clone it, but got " + r.length + " records back!");
        }
        return r[0];
    }

    @Override
    public abstract Record copy();

    public abstract HSSFRecordTypes getGenericRecordType();
}

