/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

@UIModel
public class SmartLogTail {
    public static final int STATUS_DEBUG = 0;
    public static final int STATUS_INFO = 1;
    public static final int STATUS_WARNING = 2;
    public static final int STATUS_ERROR = 3;
    public static final int STATUS_SUCCESS = 4;
    public int totalLines = 0;
    public List<String> lines = new ArrayList<String>();
    public List<Integer> status = new ArrayList<Integer>();
    public Integer maxLevel = 0;
    public int maxLevelFirstLine = -1;
    private transient ParseStatus parseStatus = new ParseStatus();

    public static SmartLogTail appendTracebackToLogTail(SmartLogTail logTail, WarningsContext.SerializedThrowable failure) {
        if (failure != null && failure.stack.length() > 0) {
            if (logTail == null) {
                logTail = new SmartLogTail();
            }
            logTail.lines.add("");
            for (String elt : failure.stack.split("\n")) {
                logTail.lines.add(elt);
            }
        }
        return logTail;
    }

    static Integer getSmartStatus(String line, ParseStatus parseStatus) {
        int status = 1;
        if (line.contains("Exception") || line.startsWith("\tat ")) {
            status = 3;
        }
        if (line.contains(" - ERROR")) {
            status = 3;
        }
        if (line.contains("- Error in ")) {
            status = 3;
        }
        if (line.contains("R code failed")) {
            status = 3;
        }
        if (line.contains("Execution halted")) {
            status = 3;
        }
        if (line.contains("Error sourcing")) {
            status = 3;
        }
        if (line.contains("Failed to read dataset")) {
            status = 3;
        }
        if (line.contains("Fatal error: ")) {
            status = 3;
        }
        if (line.contains("no package called")) {
            status = 3;
        }
        if (line.contains("WARN  org.apache.hadoop.conf.Configuration ") && line.contains("is deprecated")) {
            status = 0;
        }
        if (line.contains("Recipe code failed")) {
            status = 3;
        }
        if (line.contains("Begin Python stack")) {
            parseStatus.inPythonStack = true;
        }
        if (line.contains("End Python stack")) {
            parseStatus.inPythonStack = false;
        }
        if (parseStatus.inPythonStack) {
            status = 3;
        }
        if (line.contains("Traceback ")) {
            status = 3;
        }
        if (line.contains("NameError") || line.contains("TypeError") || line.contains("ValueError")) {
            status = 3;
        }
        if (line.contains("] [ERROR] [")) {
            status = 3;
        }
        if (line.contains("] [WARN] [")) {
            status = 2;
        }
        if (line.contains("] [DEBUG] [")) {
            status = 0;
        }
        if (line.contains("[INFO] [dku.utils]") && line.contains(" DEBUG ")) {
            status = 0;
        }
        if (line.contains("[INFO] [dku.utils]") && line.contains(" ERROR ")) {
            status = 3;
        }
        if (line.contains("[INFO] [dku.utils]") && line.contains(" WARNING ")) {
            status = 2;
        }
        if (line.contains("[INFO] [dku.utils]") && line.contains("- \tat ")) {
            status = 3;
        }
        if (line.startsWith("error:")) {
            status = 3;
        }
        if (line.startsWith("Successfully built") || line.startsWith("Successfully tagged")) {
            status = 4;
        }
        if (line.matches("(?i).*State:\\s+Terminated.*") || line.matches("(?i).*Reason:\\s+OOMKilled.*") || line.matches("(?i).*Status:\\s+Failed.*")) {
            status = 3;
        }
        if (line.matches("(?i).*Normal.*Started.*kubelet.*Started container.*")) {
            status = 4;
        }
        return status;
    }

    public List<String> getLines() {
        return this.lines;
    }

    public List<Integer> getStatus() {
        return this.status;
    }

    public synchronized void appendLine(String line) {
        this.lines.add(line);
        Integer s = SmartLogTail.getSmartStatus(line, this.parseStatus);
        if (this.status.isEmpty()) {
            this.maxLevelFirstLine = 0;
        } else if (s > this.maxLevel) {
            this.maxLevelFirstLine = this.lines.size() - 1;
        }
        this.status.add(s);
        this.maxLevel = Math.max(this.maxLevel, s);
    }

    public synchronized SmartLogTail snapshot() {
        SmartLogTail copy = new SmartLogTail();
        copy.totalLines = this.totalLines;
        copy.lines = Lists.newArrayList(this.lines);
        copy.status = Lists.newArrayList(this.status);
        copy.maxLevel = this.maxLevel;
        return copy;
    }

    public void append(SmartLogTail other) {
        for (String line : other.lines) {
            this.appendLine(line);
        }
    }

    public static SmartLogTail restrictedLogTail() {
        SmartLogTail logTail = new SmartLogTail();
        logTail.appendLine("Logs visibility is restricted. Contact your administrator if you need to access these logs");
        return logTail;
    }

    public synchronized List<String> getMaxLevelLines() {
        List<String> logLines = !this.lines.isEmpty() ? this.lines.subList(this.maxLevelFirstLine, this.lines.size()) : this.lines;
        return logLines;
    }

    static class ParseStatus {
        boolean inPythonStack;

        ParseStatus() {
        }
    }
}

