/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import java.util.List;
import java.util.Objects;

public class StringUtils {
    public static void split(String str, char separatorChar, boolean preserveAllTokens, List<String> list) {
        list.clear();
        if (str == null) {
            return;
        }
        int len = str.length();
        if (len == 0) {
            return;
        }
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        while (i < len) {
            if (str.charAt(i) == separatorChar) {
                if (match || preserveAllTokens) {
                    list.add(str.substring(start, i));
                    match = false;
                    lastMatch = true;
                }
                start = ++i;
                continue;
            }
            lastMatch = false;
            match = true;
            ++i;
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
    }

    public static String truncate(String input, int maxLength) {
        return input == null ? null : input.substring(0, Math.min(input.length(), maxLength));
    }

    public static int countChar(String haystack, char needle) {
        int count = 0;
        int len = haystack.length();
        for (int i = 0; i < len; ++i) {
            if (haystack.charAt(i) != needle) continue;
            ++count;
        }
        return count;
    }

    public static String nullIfBlank(String in) {
        return org.apache.commons.lang.StringUtils.isBlank((String)in) ? null : in;
    }

    public static boolean equalsOrBothBlank(String str1, String str2) {
        if (org.apache.commons.lang.StringUtils.isBlank((String)str1) && org.apache.commons.lang.StringUtils.isBlank((String)str2)) {
            return true;
        }
        return Objects.equals(str1, str2);
    }

    public static boolean equalsOrLeftBlank(String left, String right) {
        if (org.apache.commons.lang.StringUtils.isBlank((String)left)) {
            return true;
        }
        return Objects.equals(left, right);
    }

    public static boolean endsWithAny(String str, String ... endings) {
        for (String extension : endings) {
            if (!str.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUtf8(String charset) {
        return charset != null && charset.matches("(?i)^utf-?8$");
    }

    public static boolean isUtf16(String charset) {
        return charset != null && charset.matches("(?i)^utf-?16$");
    }
}

