/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.HDFSableDatasetHandler;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatConfig;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.spark.HDFSDatasetRDD$;
import com.dataiku.dip.spark.NativeFormatWriter;
import com.dataiku.dip.spark.package$;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class ORCWriter$
extends NativeFormatWriter {
    public static ORCWriter$ MODULE$;
    private final Logger logger;

    static {
        new ORCWriter$();
    }

    public Map<String, String> prepareSaveORCDataset(DatasetHandler handler, org.apache.spark.sql.Dataset<Row> df) {
        block6: {
            String string;
            Dataset dataset = handler.getDataset();
            ORCFileFormatConfig orcFormatConfig = (ORCFileFormatConfig)dataset.getFormatParamsAs(ORCFileFormatConfig.class);
            ORCFileFormatConfig.CompressionMethod compressionMethod = orcFormatConfig.compressionMethod;
            if (ORCFileFormatConfig.CompressionMethod.NONE.equals(compressionMethod)) {
                string = "uncompressed";
            } else if (ORCFileFormatConfig.CompressionMethod.SNAPPY.equals(compressionMethod)) {
                string = "snappy";
            } else if (ORCFileFormatConfig.CompressionMethod.ZLIB.equals(compressionMethod)) {
                string = "gzip";
            } else {
                throw new MatchError((Object)compressionMethod);
            }
            String codec = string;
            df.sqlContext().setConf("spark.sql.orc.compression.codec", codec);
            if (!(handler instanceof HDFSableDatasetHandler)) break block6;
            HDFSableDatasetHandler hdfsable = (HDFSableDatasetHandler)handler;
            hdfsable.addExtraConf(df.sqlContext().sparkContext().hadoopConfiguration(), true);
            hdfsable.addExtraConf(package$.MODULE$.getSparkHadoopUtilConf(), true);
        }
        return Predef$.MODULE$.Map().empty();
    }

    public boolean isORCOutputCompatible(Dataset dataset, org.apache.spark.sql.Dataset<Row> df) {
        if (!this.checkColumns(dataset.getSchema().getColumns(), df.schema(), false)) {
            this.logger().info((Object)new StringBuilder(71).append("Dataset ").append(dataset.getFullName()).append(" is not compatible with native ORC writer: incompatible schemas").toString());
            return false;
        }
        this.logger().info((Object)new StringBuilder(45).append("Dataset ").append(dataset.getFullName()).append(" is compatible with native ORC writer").toString());
        return true;
    }

    public void saveORCDataset(HDFSableDatasetHandler handler, org.apache.spark.sql.Dataset<Row> df, String partition, Enumeration.Value writeMode, String apiTicket) {
        String string;
        Dataset dataset = handler.getDataset();
        Partition dssPartition = partition != null ? PartitionFactory.fromIdentifier((PartitioningScheme)dataset.getPartitioningSchema(), (String)partition) : null;
        SaveMode saveMode = HDFSDatasetRDD$.MODULE$.clearDataset(dataset, dssPartition, writeMode, apiTicket);
        String path = partition != null ? handler.getFullyQualifiedPartitionPath(dssPartition) : handler.getFullyQualifiedRootPath();
        ORCFileFormatConfig orcFormatConfig = (ORCFileFormatConfig)dataset.getFormatParamsAs(ORCFileFormatConfig.class);
        ORCFileFormatConfig.CompressionMethod compressionMethod = orcFormatConfig.compressionMethod;
        if (ORCFileFormatConfig.CompressionMethod.NONE.equals(compressionMethod)) {
            string = "uncompressed";
        } else if (ORCFileFormatConfig.CompressionMethod.SNAPPY.equals(compressionMethod)) {
            string = "snappy";
        } else if (ORCFileFormatConfig.CompressionMethod.ZLIB.equals(compressionMethod)) {
            string = "gzip";
        } else {
            throw new MatchError((Object)compressionMethod);
        }
        String codec = string;
        df.sqlContext().setConf("spark.sql.orc.compression.codec", codec);
        handler.addExtraConf(df.sqlContext().sparkContext().hadoopConfiguration(), true);
        handler.addExtraConf(package$.MODULE$.getSparkHadoopUtilConf(), true);
        org.apache.spark.sql.Dataset<Row> dssDataframe = this.adaptDataFrame(df, dataset.getSchema(), dataset.isManaged());
        this.logger().info((Object)new StringBuilder(27).append("Saving dataframe as ORC to ").append(path).toString());
        dssDataframe.write().mode(saveMode).orc(path);
    }

    public org.apache.spark.sql.Dataset<Row> adaptDataFrame(org.apache.spark.sql.Dataset<Row> df, Schema dssSchema, boolean isManaged) {
        ObjectRef dssDataframe = ObjectRef.create(df);
        df.schema().foreach((Function1 & Serializable & scala.Serializable)field -> {
            dssDataframe.elem = ORCWriter$.MODULE$.adaptDataFrameColumn((org.apache.spark.sql.Dataset<Row>)((org.apache.spark.sql.Dataset)dssDataframe.elem), field, dssSchema, isManaged);
            return BoxedUnit.UNIT;
        });
        return (org.apache.spark.sql.Dataset)dssDataframe.elem;
    }

    private Logger logger() {
        return this.logger;
    }

    private ORCWriter$() {
        MODULE$ = this;
        this.logger = Logger.getLogger((String)"dku.spark.orc");
    }
}

