/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.ml.prediction;

import com.dataiku.dip.analysis.model.clustering.ClusterHierarchy;
import com.dataiku.dip.analysis.model.core.PreTrainModelingParams;
import com.dataiku.dip.analysis.model.prediction.DecisionTreeSummary;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.server.controllers.analysis.MLClusteringController;
import com.dataiku.dip.spark.ml.clustering.IsolationForestModel;
import com.dataiku.dip.spark.ml.clustering.TwoStepClusteringModel;
import com.dataiku.dip.spark.ml.clustering.WardClustering;
import com.dataiku.dip.spark.ml.prediction.WrappedDecisionTreeClassificationModel;
import com.dataiku.dip.spark.ml.prediction.WrappedGBTClassificationModel;
import com.dataiku.dip.spark.ml.preprocessing.ColumnRescalerModel;
import com.dataiku.dip.spark.package$;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.classification.RandomForestClassificationModel;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.regression.GBTRegressionModel;
import org.apache.spark.ml.regression.RandomForestRegressionModel;
import org.apache.spark.ml.tree.ContinuousSplit;
import org.apache.spark.ml.tree.InternalNode;
import org.apache.spark.ml.tree.LeafNode;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.stat.MultivariateStatisticalSummary;
import org.apache.spark.mllib.stat.Statistics$;
import org.apache.spark.mllib.tree.model.Node;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.StructuralCallSite;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

public final class ModelUIData$ {
    public static ModelUIData$ MODULE$;

    static {
        new ModelUIData$();
    }

    public static Method reflMethod$Method1(Class x$1) {
        CallSite methodCache1 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method1 = methodCache1.find(x$1);
        if (method1 != null) {
            return method1;
        }
        method1 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("trees", methodCache1.parameterTypes()));
        methodCache1.add(x$1, method1);
        return method1;
    }

    public static Method reflMethod$Method2(Class x$1) {
        CallSite methodCache2 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method2 = methodCache2.find(x$1);
        if (method2 != null) {
            return method2;
        }
        method2 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("trees", methodCache2.parameterTypes()));
        methodCache2.add(x$1, method2);
        return method2;
    }

    public static Method reflMethod$Method3(Class x$1) {
        CallSite methodCache3 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method3 = methodCache3.find(x$1);
        if (method3 != null) {
            return method3;
        }
        method3 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("trees", methodCache3.parameterTypes()));
        methodCache3.add(x$1, method3);
        return method3;
    }

    public static Method reflMethod$Method4(Class x$1) {
        CallSite methodCache4 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method4 = methodCache4.find(x$1);
        if (method4 != null) {
            return method4;
        }
        method4 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("rootNode", methodCache4.parameterTypes()));
        methodCache4.add(x$1, method4);
        return method4;
    }

    public void write(Model<?> m, Dataset<Row> data, String[] features, List<PipelineStage> pipeline, PreTrainModelingParams modelingParams, File modelFolder) {
        Option rescaler = ((TraversableLike)pipeline.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends PipelineStage, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof ColumnRescalerModel) {
                    ColumnRescalerModel columnRescalerModel = (ColumnRescalerModel)A1;
                    return (B1)columnRescalerModel;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(PipelineStage x1) {
                PipelineStage pipelineStage = x1;
                return pipelineStage instanceof ColumnRescalerModel;
            }
        }, List$.MODULE$.canBuildFrom())).headOption();
        Model<?> model = m;
        if (model instanceof DecisionTreeRegressionModel) {
            DecisionTreeRegressionModel decisionTreeRegressionModel = (DecisionTreeRegressionModel)model;
            ModelUIData$.dump$1("tree.json", this.getTreeSummary(decisionTreeRegressionModel, (RDD<org.apache.spark.ml.linalg.Vector>)data.rdd().map((Function1 & Serializable & scala.Serializable)x$2 -> (org.apache.spark.ml.linalg.Vector)x$2.getAs("__dku_features"), ClassTag$.MODULE$.apply(org.apache.spark.ml.linalg.Vector.class)), features, (Option<ColumnRescalerModel>)rescaler), modelFolder);
            return;
        }
        if (model instanceof WrappedDecisionTreeClassificationModel) {
            WrappedDecisionTreeClassificationModel wrappedDecisionTreeClassificationModel = (WrappedDecisionTreeClassificationModel)model;
            ModelUIData$.dump$1("tree.json", this.getTreeSummary(wrappedDecisionTreeClassificationModel.treeModel(), (RDD<org.apache.spark.ml.linalg.Vector>)data.rdd().map((Function1 & Serializable & scala.Serializable)x$3 -> (org.apache.spark.ml.linalg.Vector)x$3.getAs("__dku_features"), ClassTag$.MODULE$.apply(org.apache.spark.ml.linalg.Vector.class)), features, (Option<ColumnRescalerModel>)rescaler), modelFolder);
            return;
        }
        if (model instanceof WrappedGBTClassificationModel) {
            WrappedGBTClassificationModel wrappedGBTClassificationModel = (WrappedGBTClassificationModel)model;
            ModelUIData$.dump$1("trees.json", this.getEnsembleSummary((Object)wrappedGBTClassificationModel.gbtModel(), (RDD<org.apache.spark.ml.linalg.Vector>)data.rdd().map((Function1 & Serializable & scala.Serializable)x$4 -> (org.apache.spark.ml.linalg.Vector)x$4.getAs("__dku_features"), ClassTag$.MODULE$.apply(org.apache.spark.ml.linalg.Vector.class)), features, (Option<ColumnRescalerModel>)rescaler, modelingParams, (Function1)Predef$.MODULE$.$conforms(), (Function1)Predef$.MODULE$.$conforms()), modelFolder);
            return;
        }
        if (model instanceof GBTRegressionModel) {
            GBTRegressionModel gBTRegressionModel = (GBTRegressionModel)model;
            ModelUIData$.dump$1("trees.json", this.getEnsembleSummary((Object)gBTRegressionModel, (RDD<org.apache.spark.ml.linalg.Vector>)data.rdd().map((Function1 & Serializable & scala.Serializable)x$5 -> (org.apache.spark.ml.linalg.Vector)x$5.getAs("__dku_features"), ClassTag$.MODULE$.apply(org.apache.spark.ml.linalg.Vector.class)), features, (Option<ColumnRescalerModel>)rescaler, modelingParams, (Function1)Predef$.MODULE$.$conforms(), (Function1)Predef$.MODULE$.$conforms()), modelFolder);
            return;
        }
        if (model instanceof RandomForestRegressionModel) {
            RandomForestRegressionModel randomForestRegressionModel = (RandomForestRegressionModel)model;
            ModelUIData$.dump$1("trees.json", this.getEnsembleSummary((Object)randomForestRegressionModel, (RDD<org.apache.spark.ml.linalg.Vector>)data.rdd().map((Function1 & Serializable & scala.Serializable)x$6 -> (org.apache.spark.ml.linalg.Vector)x$6.getAs("__dku_features"), ClassTag$.MODULE$.apply(org.apache.spark.ml.linalg.Vector.class)), features, (Option<ColumnRescalerModel>)rescaler, modelingParams, (Function1)Predef$.MODULE$.$conforms(), (Function1)Predef$.MODULE$.$conforms()), modelFolder);
            return;
        }
        if (model instanceof RandomForestClassificationModel) {
            RandomForestClassificationModel randomForestClassificationModel = (RandomForestClassificationModel)model;
            ModelUIData$.dump$1("trees.json", this.getEnsembleSummary((Object)randomForestClassificationModel, (RDD<org.apache.spark.ml.linalg.Vector>)data.rdd().map((Function1 & Serializable & scala.Serializable)x$7 -> (org.apache.spark.ml.linalg.Vector)x$7.getAs("__dku_features"), ClassTag$.MODULE$.apply(org.apache.spark.ml.linalg.Vector.class)), features, (Option<ColumnRescalerModel>)rescaler, modelingParams, (Function1)Predef$.MODULE$.$conforms(), (Function1)Predef$.MODULE$.$conforms()), modelFolder);
            return;
        }
        if (model instanceof TwoStepClusteringModel) {
            TwoStepClusteringModel twoStepClusteringModel = (TwoStepClusteringModel)model;
            ModelUIData$.dump$1("hierarchy.json", this.getHierarchy(twoStepClusteringModel, (IndexedSeq<String>)Predef$.MODULE$.wrapRefArray((Object[])features), (Option<ColumnRescalerModel>)rescaler), modelFolder);
            return;
        }
        if (model instanceof IsolationForestModel) {
            IsolationForestModel isolationForestModel = (IsolationForestModel)model;
            ModelUIData$.dump$1("anomalies.json", this.getAnomalies(isolationForestModel, data, features, (Option<ColumnRescalerModel>)rescaler), modelFolder);
            return;
        }
    }

    public ClusterHierarchy getHierarchy(TwoStepClusteringModel ts, IndexedSeq<String> features, Option<ColumnRescalerModel> rescaler) {
        ClusterHierarchy.Node root = ModelUIData$.toJNode$1(ts.wardClustering().root(), rescaler, features);
        ClusterHierarchy ch = new ClusterHierarchy();
        ch.root = root;
        ch.variable_names = (String[])features.toArray(ClassTag$.MODULE$.apply(String.class));
        ch.active_ids = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)ts.getActiveIds().toList().map((Function1 & Serializable & scala.Serializable)i -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)i)), List$.MODULE$.canBuildFrom())).asJava();
        return ch;
    }

    public MLClusteringController.AnomalyData getAnomalies(IsolationForestModel iso, Dataset<Row> data, String[] features, Option<ColumnRescalerModel> rescaler2) {
        MLClusteringController.AnomalyData anom = new MLClusteringController.AnomalyData();
        anom.columns = features;
        String fCol = iso.getFeaturesColumn();
        Dataset<Row> transformed = iso.transform(data);
        Dataset anomalies = transformed.where(functions$.MODULE$.col("cluster").equalTo((Object)BoxesRunTime.boxToInteger((int)0)));
        Tuple2[] samples = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])anomalies.select(fCol, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"anomaly_score"})).sort("anomaly_score", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).take(iso.getNSamples()))).map((Function1 & Serializable & scala.Serializable)r -> new Tuple2((Object)((org.apache.spark.ml.linalg.Vector)r.getAs(fCol)).toArray(), r.getAs("anomaly_score")), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        Tuple2[] regularSamples = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])transformed.select(fCol, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"anomaly_score"})).sort((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("anomaly_score").desc()})).take(10))).map((Function1 & Serializable & scala.Serializable)r -> new Tuple2((Object)((org.apache.spark.ml.linalg.Vector)r.getAs(fCol)).toArray(), r.getAs("anomaly_score")), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        anom.scores = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])samples)).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToDouble((double)x$11._2$mcD$sp()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        anom.regular_scores = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])regularSamples)).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToDouble((double)x$12._2$mcD$sp()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        anom.data = (double[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])samples)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                double[] arr = (double[])tuple2._1();
                return ModelUIData$.denorm$1(arr, rescaler2, features);
            }
            throw new MatchError((Object)tuple2);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
        anom.regular_data = (double[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])regularSamples)).map((Function1 & Serializable & scala.Serializable)x$13 -> (double[])x$13._1(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)))))).map((Function1 & Serializable & scala.Serializable)x -> ModelUIData$.denorm$1(x, rescaler2, features), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
        String[] pCol = iso.getProfilingColumns();
        anom.extra_profiling_columns = pCol;
        anom.extra_profiling_data = (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])anomalies.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pCol)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"anomaly_score"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).map((Function1 & Serializable & scala.Serializable)c -> functions$.MODULE$.col(c), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class))))).sort("anomaly_score", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).take(iso.getNSamples()))).map((Function1 & Serializable & scala.Serializable)r -> (String[])Predef$.MODULE$.genericArrayOps(r.toSeq().toArray(ClassTag$.MODULE$.Any())).map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
        anom.extra_profiling_regular_data = (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])transformed.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pCol)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"anomaly_score"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).map((Function1 & Serializable & scala.Serializable)c -> functions$.MODULE$.col(c), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class))))).sort((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("anomaly_score").desc()})).take(10))).map((Function1 & Serializable & scala.Serializable)r -> (String[])Predef$.MODULE$.genericArrayOps(r.toSeq().toArray(ClassTag$.MODULE$.Any())).map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
        MultivariateStatisticalSummary summ = Statistics$.MODULE$.colStats(data.rdd().map((Function1 & Serializable & scala.Serializable)x$16 -> com.dataiku.dip.spark.compat.package$.MODULE$.ml2mllibVector((org.apache.spark.ml.linalg.Vector)x$16.getAs(fCol)), ClassTag$.MODULE$.apply(Vector.class)));
        anom.averages = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(summ.mean().toArray())).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])features), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToDouble((double)ModelUIData$.$anonfun$getAnomalies$16(rescaler2, x0$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        scala.collection.immutable.Map sdMap = (scala.collection.immutable.Map)rescaler2.map((Function1 & Serializable & scala.Serializable)rescaler -> ((TraversableOnce)rescaler.columns().zip(rescaler.scale(), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        anom.standard_deviations = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(summ.variance().toArray())).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])features), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToDouble((double)ModelUIData$.$anonfun$getAnomalies$21(sdMap, x0$3)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        anom.total_anomalies = anomalies.count();
        return anom;
    }

    public DecisionTreeSummary getTreeSummary(DecisionTreeRegressionModel dt, RDD<org.apache.spark.ml.linalg.Vector> data, String[] features, Option<ColumnRescalerModel> rescaler) {
        return this.getSummary(dt.rootNode(), data, features, rescaler, true);
    }

    public DecisionTreeSummary getTreeSummary(DecisionTreeClassificationModel dt, RDD<org.apache.spark.ml.linalg.Vector> data, String[] features, Option<ColumnRescalerModel> rescaler) {
        return this.getSummary(dt.rootNode(), data, features, rescaler, false);
    }

    public <EnsembleType, TreeType> DecisionTreeSummary.TreeEnsembleSummary getEnsembleSummary(EnsembleType gb, RDD<org.apache.spark.ml.linalg.Vector> data, String[] features, Option<ColumnRescalerModel> rescaler, PreTrainModelingParams modelingParams, Function1<EnsembleType, Object> getTrees, Function1<TreeType, Object> getNode) {
        Object object;
        Object object2;
        Object object3;
        int maxNodes = ((PreTrainPredictionModelingParams)modelingParams).max_ensemble_nodes_serialized;
        Object qual1 = getTrees.apply(gb);
        try {
            object3 = ModelUIData$.reflMethod$Method1(qual1.getClass()).invoke(qual1, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        int taken = ((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.genericArrayOps(object3).map((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToInteger((int)ModelUIData$.$anonfun$getEnsembleSummary$1(getNode, t)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).scanLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$18, x$19) -> x$18 + x$19, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).drop(1))).takeWhile((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$20 -> x$20 < maxNodes)).length;
        RDD cached = data.cache();
        Object qual2 = getTrees.apply(gb);
        try {
            object2 = ModelUIData$.reflMethod$Method2(qual2.getClass()).invoke(qual2, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        DecisionTreeSummary[] trees = (DecisionTreeSummary[])Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps(object2).take(scala.math.package$.MODULE$.max(1, taken))).map((Function1 & Serializable & scala.Serializable)t -> {
            DecisionTreeSummary decisionTreeSummary;
            Object object = t;
            if (object instanceof DecisionTreeRegressionModel) {
                DecisionTreeRegressionModel decisionTreeRegressionModel = (DecisionTreeRegressionModel)object;
                decisionTreeSummary = MODULE$.getTreeSummary(decisionTreeRegressionModel, (RDD<org.apache.spark.ml.linalg.Vector>)cached, features, rescaler);
            } else if (object instanceof DecisionTreeClassificationModel) {
                DecisionTreeClassificationModel decisionTreeClassificationModel = (DecisionTreeClassificationModel)object;
                decisionTreeSummary = MODULE$.getTreeSummary(decisionTreeClassificationModel, (RDD<org.apache.spark.ml.linalg.Vector>)cached, features, rescaler);
            } else {
                throw new MatchError(object);
            }
            DecisionTreeSummary treeSummary = decisionTreeSummary;
            return treeSummary;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeSummary.class)));
        cached.unpersist(cached.unpersist$default$1());
        DecisionTreeSummary.TreeEnsembleSummary summary = new DecisionTreeSummary.TreeEnsembleSummary();
        Object qual3 = getTrees.apply(gb);
        try {
            object = ModelUIData$.reflMethod$Method3(qual3.getClass()).invoke(qual3, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        summary.was_clipped = ScalaRunTime$.MODULE$.array_length(object) != trees.length;
        summary.trees = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])trees)).map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.tree, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeSummary.TreeDescription.class))))).toList()).asJava();
        summary.featureNames = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])features)).toList()).asJava();
        return summary;
    }

    private int getNodeCount(org.apache.spark.ml.tree.Node dt) {
        return ModelUIData$.ct$1(org.apache.spark.ml.tree.dataiku.package$.MODULE$.toOld(dt));
    }

    private List<Object> getPath(org.apache.spark.ml.tree.Node n, org.apache.spark.ml.linalg.Vector v, int id) {
        org.apache.spark.ml.tree.Node node = n;
        if (node instanceof LeafNode) {
            return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{id}));
        }
        if (node instanceof InternalNode) {
            Tuple2 tuple2;
            InternalNode internalNode = (InternalNode)node;
            ContinuousSplit sp2 = (ContinuousSplit)internalNode.split();
            Tuple2 tuple22 = tuple2 = v.apply(sp2.featureIndex()) <= sp2.threshold() ? new Tuple2((Object)internalNode.leftChild(), (Object)BoxesRunTime.boxToInteger((int)(2 * id))) : new Tuple2((Object)internalNode.rightChild(), (Object)BoxesRunTime.boxToInteger((int)(2 * id + 1)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            org.apache.spark.ml.tree.Node son = (org.apache.spark.ml.tree.Node)tuple2._1();
            int sonId = tuple2._2$mcI$sp();
            Tuple2 tuple23 = new Tuple2((Object)son, (Object)BoxesRunTime.boxToInteger((int)sonId));
            org.apache.spark.ml.tree.Node son2 = (org.apache.spark.ml.tree.Node)tuple23._1();
            int sonId2 = tuple23._2$mcI$sp();
            int n2 = id;
            return this.getPath(son2, v, sonId2).$colon$colon((Object)BoxesRunTime.boxToInteger((int)n2));
        }
        throw new MatchError((Object)node);
    }

    private DecisionTreeSummary getSummary(org.apache.spark.ml.tree.Node rootNode, RDD<org.apache.spark.ml.linalg.Vector> data, String[] features, Option<ColumnRescalerModel> rescaler, boolean isRegression) {
        DecisionTreeSummary.TreeDescription tree;
        DecisionTreeSummary summary = new DecisionTreeSummary();
        summary.tree = tree = new DecisionTreeSummary.TreeDescription();
        Map countsPerNode = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(data.flatMap((Function1 & Serializable & scala.Serializable)v -> MODULE$.getPath(rootNode, (org.apache.spark.ml.linalg.Vector)v, 1), ClassTag$.MODULE$.Int()).map((Function1 & Serializable & scala.Serializable)x$24 -> ModelUIData$.$anonfun$getSummary$2(BoxesRunTime.unboxToInt((Object)x$24)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Long(), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x$25, x$26) -> x$25 + x$26), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Long(), (Ordering)Ordering.Int$.MODULE$).collectAsMap();
        List nodes = (List)ModelUIData$.extract$1(rootNode, 1).toList().sortBy((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToInteger((int)x$27._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$);
        scala.collection.immutable.Map indexMapper = ((TraversableOnce)((IterableLike)nodes.map((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToInteger((int)x$28._1$mcI$sp()), List$.MODULE$.canBuildFrom())).zipWithIndex(List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        List leftChildren = (List)nodes.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)ModelUIData$.$anonfun$getSummary$6(indexMapper, x0$1)), List$.MODULE$.canBuildFrom());
        List rightChildren = (List)nodes.map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)ModelUIData$.$anonfun$getSummary$7(indexMapper, x0$2)), List$.MODULE$.canBuildFrom());
        tree.rightChild = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)rightChildren.map((Function1 & Serializable & scala.Serializable)i -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)i)), List$.MODULE$.canBuildFrom())).asJava();
        tree.leftChild = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)leftChildren.map((Function1 & Serializable & scala.Serializable)i -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)i)), List$.MODULE$.canBuildFrom())).asJava();
        tree.impurity = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)nodes.map((Function1 & Serializable & scala.Serializable)x$29 -> Predef$.MODULE$.double2Double(((org.apache.spark.ml.tree.Node)x$29._2()).impurity()), List$.MODULE$.canBuildFrom())).asJava();
        tree.threshold = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)nodes.map((Function1 & Serializable & scala.Serializable)s -> {
            double d;
            org.apache.spark.ml.tree.Node node = (org.apache.spark.ml.tree.Node)s._2();
            if (node instanceof LeafNode) {
                d = 0.0;
            } else if (node instanceof InternalNode) {
                InternalNode internalNode = (InternalNode)node;
                ContinuousSplit sp2 = (ContinuousSplit)internalNode.split();
                d = BoxesRunTime.unboxToDouble((Object)rescaler.map((Function1 & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToDouble((double)x$30.unscale(features[sp2.featureIndex()], sp2.threshold()))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> sp2.threshold()));
            } else {
                throw new MatchError((Object)node);
            }
            double d2 = d;
            return Predef$.MODULE$.double2Double(d2);
        }, List$.MODULE$.canBuildFrom())).asJava();
        tree.nSamples = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)nodes.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                int i = tuple2._1$mcI$sp();
                long cts = BoxesRunTime.unboxToLong((Object)countsPerNode.getOrElse((Object)BoxesRunTime.boxToInteger((int)i), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 1L));
                return Predef$.MODULE$.double2Double((double)cts);
            }
            throw new MatchError((Object)tuple2);
        }, List$.MODULE$.canBuildFrom())).asJava();
        tree.feature = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((List)nodes.map((Function1 & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToInteger((int)ModelUIData$.$anonfun$getSummary$16(x$31)), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)u -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)u)), List$.MODULE$.canBuildFrom())).asJava();
        if (isRegression) {
            tree.predict = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)nodes.map((Function1 & Serializable & scala.Serializable)x$32 -> Predef$.MODULE$.double2Double(((org.apache.spark.ml.tree.Node)x$32._2()).prediction()), List$.MODULE$.canBuildFrom())).asJava();
        } else {
            tree.probas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)nodes.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 != null) {
                    org.apache.spark.ml.tree.Node n = (org.apache.spark.ml.tree.Node)tuple2._2();
                    Object impurityStats = ((Method)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])n.getClass().getMethods())).find((Function1 & Serializable & scala.Serializable)x$36 -> BoxesRunTime.boxToBoolean((boolean)ModelUIData$.$anonfun$getSummary$23(x$36))).get()).invoke((Object)n, new Object[0]);
                    List raw = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])((Method)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])impurityStats.getClass().getMethods())).find((Function1 & Serializable & scala.Serializable)x$37 -> BoxesRunTime.boxToBoolean((boolean)ModelUIData$.$anonfun$getSummary$24(x$37))).get()).invoke(impurityStats, new Object[0]))).toList();
                    double norm = BoxesRunTime.unboxToDouble((Object)raw.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                    return (double[])((TraversableOnce)raw.map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$38 -> x$38 / norm, List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
                }
                throw new MatchError((Object)tuple2);
            }, List$.MODULE$.canBuildFrom())).asJava();
        }
        summary.featureNames = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])features)).toList()).asJava();
        return summary;
    }

    private static final void dump$1(String path, Object t, File modelFolder$1) {
        package$.MODULE$.printToFile(new File(modelFolder$1, path), (Function1<PrintWriter, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.write(JSON.prettyNoNaN((Object)t));
            return BoxedUnit.UNIT;
        });
    }

    private static final double[] rescale$1(IndexedSeq v, Option rescaler$1, IndexedSeq features$1) {
        double[] arr = (double[])v.toArray(ClassTag$.MODULE$.Double());
        return (double[])((TraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(arr)).indices().map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> BoxesRunTime.unboxToDouble((Object)rescaler$1.map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToDouble((double)x$8.unscale((String)features$1.apply(i), arr[i]))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> arr[i])), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
    }

    private static final double[] rescaleSquares$1(IndexedSeq squares, IndexedSeq rep, double weight, Option rescaler$1, IndexedSeq features$1) {
        return (double[])((TraversableOnce)squares.indices().map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> {
            double shift = BoxesRunTime.unboxToDouble((Object)rescaler$1.map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToDouble((double)x$9.getShift((String)features$1.apply(i)))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
            double inv_scale = BoxesRunTime.unboxToDouble((Object)rescaler$1.map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToDouble((double)x$10.getInvScale((String)features$1.apply(i)))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0));
            double x = BoxesRunTime.unboxToDouble((Object)rep.apply(i));
            double sq = BoxesRunTime.unboxToDouble((Object)squares.apply(i));
            return sq / (inv_scale * inv_scale) + weight * shift * (shift + (double)2 * x / inv_scale);
        }, scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
    }

    private static final ClusterHierarchy.Node toJNode$1(WardClustering.Node n, Option rescaler$1, IndexedSeq features$1) {
        ClusterHierarchy.Node jn = new ClusterHierarchy.Node();
        WardClustering.Node node = n;
        if (node instanceof WardClustering.Leaf) {
            int tid;
            WardClustering.Leaf leaf = (WardClustering.Leaf)node;
            IndexedSeq<Object> r = leaf.representative();
            IndexedSeq<Object> sq = leaf.squares();
            double w = leaf.weight();
            jn.id = tid = leaf.id();
            jn.representative = ModelUIData$.rescale$1(r, rescaler$1, features$1);
            jn.squares = ModelUIData$.rescaleSquares$1(sq, r, w, rescaler$1, features$1);
            jn.weight = w;
        } else if (node instanceof WardClustering.Internal) {
            int tid;
            WardClustering.Internal internal = (WardClustering.Internal)node;
            WardClustering.Node l = internal.left();
            WardClustering.Node r = internal.right();
            jn.id = tid = internal.id();
            jn.representative = ModelUIData$.rescale$1(internal.representative(), rescaler$1, features$1);
            jn.weight = internal.weight();
            jn.squares = ModelUIData$.rescaleSquares$1(internal.squares(), internal.representative(), internal.weight(), rescaler$1, features$1);
            jn.left_son = ModelUIData$.toJNode$1(l, rescaler$1, features$1);
            jn.right_son = ModelUIData$.toJNode$1(r, rescaler$1, features$1);
        } else {
            throw new MatchError((Object)node);
        }
        return jn;
    }

    private static final double[] denorm$1(double[] x, Option rescaler$2, String[] features$2) {
        Option option = rescaler$2;
        if (None$.MODULE$.equals(option)) {
            return x;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            ColumnRescalerModel rescaler = (ColumnRescalerModel)some.value();
            return (double[])((TraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x)).indices().map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> rescaler.unscale(features$2[i], x[i]), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ double $anonfun$getAnomalies$16(Option rescaler$2, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            double x = tuple2._1$mcD$sp();
            String f = (String)tuple2._2();
            return BoxesRunTime.unboxToDouble((Object)rescaler$2.map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToDouble((double)x$17.unscale(f, x))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> x));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ double $anonfun$getAnomalies$21(scala.collection.immutable.Map sdMap$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            double v = tuple2._1$mcD$sp();
            String f = (String)tuple2._2();
            return BoxesRunTime.unboxToDouble((Object)sdMap$1.getOrElse((Object)f, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> scala.math.package$.MODULE$.sqrt(v)));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ int $anonfun$getEnsembleSummary$1(Function1 getNode$1, Object t) {
        Object object;
        Object qual4 = getNode$1.apply(t);
        try {
            object = ModelUIData$.reflMethod$Method4(qual4.getClass()).invoke(qual4, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        return MODULE$.getNodeCount((org.apache.spark.ml.tree.Node)object);
    }

    private static final int ct$1(Node n) {
        if (n.isLeaf()) {
            return 1;
        }
        return ModelUIData$.ct$1((Node)n.leftNode().get()) + ModelUIData$.ct$1((Node)n.rightNode().get()) + 1;
    }

    public static final /* synthetic */ Tuple2 $anonfun$getSummary$2(int x$24) {
        return new Tuple2.mcIJ.sp(x$24, 1L);
    }

    private static final scala.collection.immutable.Map extract$1(org.apache.spark.ml.tree.Node n, int id) {
        org.apache.spark.ml.tree.Node node = n;
        if (node instanceof LeafNode) {
            LeafNode leafNode = (LeafNode)node;
            return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)id)), (Object)leafNode)}));
        }
        if (node instanceof InternalNode) {
            InternalNode internalNode = (InternalNode)node;
            return ModelUIData$.extract$1(internalNode.leftChild(), 2 * id).$plus$plus((GenTraversableOnce)ModelUIData$.extract$1(internalNode.rightChild(), 2 * id + 1)).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)id)), (Object)internalNode));
        }
        throw new MatchError((Object)node);
    }

    public static final /* synthetic */ int $anonfun$getSummary$6(scala.collection.immutable.Map indexMapper$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int i = tuple2._1$mcI$sp();
            org.apache.spark.ml.tree.Node node = (org.apache.spark.ml.tree.Node)tuple2._2();
            if (node instanceof LeafNode) {
                return -1;
            }
            return BoxesRunTime.unboxToInt((Object)indexMapper$1.apply((Object)BoxesRunTime.boxToInteger((int)(2 * i))));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ int $anonfun$getSummary$7(scala.collection.immutable.Map indexMapper$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            int i = tuple2._1$mcI$sp();
            org.apache.spark.ml.tree.Node node = (org.apache.spark.ml.tree.Node)tuple2._2();
            if (node instanceof LeafNode) {
                return -1;
            }
            return BoxesRunTime.unboxToInt((Object)indexMapper$1.apply((Object)BoxesRunTime.boxToInteger((int)(2 * i + 1))));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ int $anonfun$getSummary$16(Tuple2 x$31) {
        org.apache.spark.ml.tree.Node node = (org.apache.spark.ml.tree.Node)x$31._2();
        if (node instanceof LeafNode) {
            return -2;
        }
        if (node instanceof InternalNode) {
            InternalNode internalNode = (InternalNode)node;
            return internalNode.split().featureIndex();
        }
        throw new MatchError((Object)node);
    }

    public static final /* synthetic */ boolean $anonfun$getSummary$19(Method x$33) {
        String string = x$33.getName();
        String string2 = "impurityStats";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getSummary$20(Method x$34) {
        String string = x$34.getName();
        String string2 = "stats";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final List getProbas$1(org.apache.spark.ml.tree.Node leaf) {
        Object impurityStats = ((Method)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leaf.getClass().getMethods())).find((Function1 & Serializable & scala.Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)ModelUIData$.$anonfun$getSummary$19(x$33))).get()).invoke((Object)leaf, new Object[0]);
        List raw = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])((Method)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])impurityStats.getClass().getMethods())).find((Function1 & Serializable & scala.Serializable)x$34 -> BoxesRunTime.boxToBoolean((boolean)ModelUIData$.$anonfun$getSummary$20(x$34))).get()).invoke(impurityStats, new Object[0]))).toList();
        double norm = BoxesRunTime.unboxToDouble((Object)raw.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return (List)raw.map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$35 -> x$35 / norm, List$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$getSummary$23(Method x$36) {
        String string = x$36.getName();
        String string2 = "impurityStats";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getSummary$24(Method x$37) {
        String string = x$37.getName();
        String string2 = "stats";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private ModelUIData$() {
        MODULE$ = this;
    }
}

