/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2;

import com.dataiku.dss.legacy.aws.com.amazonaws.ClientConfigurationFactory;
import com.dataiku.dss.legacy.aws.com.amazonaws.annotation.NotThreadSafe;
import com.dataiku.dss.legacy.aws.com.amazonaws.client.AwsAsyncClientParams;
import com.dataiku.dss.legacy.aws.com.amazonaws.client.builder.AwsAsyncClientBuilder;
import com.dataiku.dss.legacy.aws.com.amazonaws.endpointdiscovery.DefaultEndpointDiscoveryProviderChain;
import com.dataiku.dss.legacy.aws.com.amazonaws.endpointdiscovery.EndpointDiscoveryProviderChain;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.config.InternalConfig;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsync;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsyncClient;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientConfigurationFactory;

@NotThreadSafe
public final class AmazonDynamoDBAsyncClientBuilder
extends AwsAsyncClientBuilder<AmazonDynamoDBAsyncClientBuilder, AmazonDynamoDBAsync> {
    private static final ClientConfigurationFactory CLIENT_CONFIG_FACTORY = new AmazonDynamoDBClientConfigurationFactory();
    private static final EndpointDiscoveryProviderChain DEFAULT_ENDPOINT_DISCOVERY_PROVIDER = new DefaultEndpointDiscoveryProviderChain();
    private boolean endpointDiscoveryEnabled = false;
    private boolean endpointDiscoveryDisabled = false;

    public static AmazonDynamoDBAsyncClientBuilder standard() {
        return new AmazonDynamoDBAsyncClientBuilder();
    }

    public static AmazonDynamoDBAsync defaultClient() {
        return (AmazonDynamoDBAsync)AmazonDynamoDBAsyncClientBuilder.standard().build();
    }

    private AmazonDynamoDBAsyncClientBuilder() {
        super(CLIENT_CONFIG_FACTORY);
    }

    public AmazonDynamoDBAsyncClientBuilder enableEndpointDiscovery() {
        this.endpointDiscoveryEnabled = true;
        return this;
    }

    public AmazonDynamoDBAsyncClientBuilder disableEndpointDiscovery() {
        this.endpointDiscoveryDisabled = true;
        return this;
    }

    private boolean endpointDiscoveryEnabled() {
        Boolean endpointDiscoveryChainSetting = DEFAULT_ENDPOINT_DISCOVERY_PROVIDER.endpointDiscoveryEnabled();
        if (this.endpointDiscoveryDisabled) {
            return false;
        }
        if (this.endpointDiscoveryEnabled) {
            return true;
        }
        if (endpointDiscoveryChainSetting != null && !endpointDiscoveryChainSetting.booleanValue()) {
            return false;
        }
        if (endpointDiscoveryChainSetting != null && endpointDiscoveryChainSetting.booleanValue()) {
            return true;
        }
        return InternalConfig.Factory.getInternalConfig().endpointDiscoveryEnabled();
    }

    @Override
    protected AmazonDynamoDBAsync build(AwsAsyncClientParams params) {
        if (this.endpointDiscoveryEnabled() && this.getEndpoint() == null) {
            return new AmazonDynamoDBAsyncClient(params, true);
        }
        return new AmazonDynamoDBAsyncClient(params);
    }
}

