/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.CreateReplaceRootVolumeTaskRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.TagSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.IdempotentUtils;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class CreateReplaceRootVolumeTaskRequestMarshaller
implements Marshaller<Request<CreateReplaceRootVolumeTaskRequest>, CreateReplaceRootVolumeTaskRequest> {
    @Override
    public Request<CreateReplaceRootVolumeTaskRequest> marshall(CreateReplaceRootVolumeTaskRequest createReplaceRootVolumeTaskRequest) {
        if (createReplaceRootVolumeTaskRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateReplaceRootVolumeTaskRequest> request = new DefaultRequest<CreateReplaceRootVolumeTaskRequest>(createReplaceRootVolumeTaskRequest, "AmazonEC2");
        request.addParameter("Action", "CreateReplaceRootVolumeTask");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createReplaceRootVolumeTaskRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString(createReplaceRootVolumeTaskRequest.getInstanceId()));
        }
        if (createReplaceRootVolumeTaskRequest.getSnapshotId() != null) {
            request.addParameter("SnapshotId", StringUtils.fromString(createReplaceRootVolumeTaskRequest.getSnapshotId()));
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString(createReplaceRootVolumeTaskRequest.getClientToken()));
        SdkInternalList createReplaceRootVolumeTaskRequestTagSpecificationsList = (SdkInternalList)createReplaceRootVolumeTaskRequest.getTagSpecifications();
        if (!createReplaceRootVolumeTaskRequestTagSpecificationsList.isEmpty() || !createReplaceRootVolumeTaskRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createReplaceRootVolumeTaskRequestTagSpecificationsListValue : createReplaceRootVolumeTaskRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createReplaceRootVolumeTaskRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(createReplaceRootVolumeTaskRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createReplaceRootVolumeTaskRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        if (createReplaceRootVolumeTaskRequest.getImageId() != null) {
            request.addParameter("ImageId", StringUtils.fromString(createReplaceRootVolumeTaskRequest.getImageId()));
        }
        if (createReplaceRootVolumeTaskRequest.getDeleteReplacedRootVolume() != null) {
            request.addParameter("DeleteReplacedRootVolume", StringUtils.fromBoolean(createReplaceRootVolumeTaskRequest.getDeleteReplacedRootVolume()));
        }
        return request;
    }
}

