/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.unidecode;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Unidecode {
    private static final Logger LOG = LoggerFactory.getLogger(Unidecode.class);
    private static final String PREFIX = "/cz/jirutka/unidecode/";
    private static final String ASCII = "/cz/jirutka/unidecode/ascii";
    private static final String LATIN2 = "/cz/jirutka/unidecode/latin2";
    public static final String UNKNOWN_CHAR = "[?]";
    private final String[][] cache = new String[256][];
    private final String[] tablesLookupPaths;

    protected Unidecode(String[] tablesLookupPaths) {
        this.tablesLookupPaths = tablesLookupPaths;
    }

    public static Unidecode toAscii() {
        return new Unidecode(new String[]{ASCII});
    }

    public static Unidecode toLatin2() {
        return new Unidecode(new String[]{LATIN2, ASCII});
    }

    public String decode(String str) {
        if (str == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            int codePoint = str.codePointAt(i);
            if (codePoint < 128) {
                sb.append(c);
            } else if (codePoint <= 65535) {
                sb.append(this.substituteChar(codePoint));
            }
            ++i;
        }
        return sb.toString().trim();
    }

    public String toInitials(String str) {
        if (str == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Pattern p = Pattern.compile("^\\w|\\s+\\w");
        Matcher m = p.matcher(this.decode(str));
        while (m.find()) {
            sb.append(m.group().replaceAll(" ", ""));
        }
        return sb.toString();
    }

    protected URL resolveCharsTableFile(int block) {
        String fileName = String.format("X%03x", block);
        String[] stringArray = this.tablesLookupPaths;
        int n = this.tablesLookupPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            URL resource = this.getClass().getResource(String.valueOf(path) + '/' + fileName);
            if (resource != null) {
                return resource;
            }
            ++n2;
        }
        return null;
    }

    private String substituteChar(int codePoint) {
        int section = codePoint >> 8;
        int position = codePoint % 256;
        String[] table = this.getCachedCharsTable(section);
        if (table.length > position) {
            return table[position];
        }
        return UNKNOWN_CHAR;
    }

    private synchronized String[] getCachedCharsTable(int block) {
        if (block < this.cache.length && this.cache[block] == null) {
            this.cache[block] = this.loadCharsTable(block);
        }
        return this.cache[block];
    }

    private String[] loadCharsTable(int block) {
        URL file = this.resolveCharsTableFile(block);
        if (file == null) {
            LOG.info("Missing chars table for block: {}", (Object)String.format("%03x", block));
            return Unidecode.unknownCharsTable();
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream is = file.openStream();){
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                String[] table = new String[256];
                int i = 0;
                String line = null;
                while ((line = reader.readLine()) != null) {
                    table[i] = line;
                    ++i;
                }
                return table;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            LOG.warn("Failed to load chars table from file: {}", (Object)file, (Object)ex);
            return Unidecode.unknownCharsTable();
        }
    }

    private static String[] unknownCharsTable() {
        Object[] table = new String[256];
        Arrays.fill(table, UNKNOWN_CHAR);
        return table;
    }
}

