/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.cli;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.GHSpring;
import com.dataiku.gh.cli.CLICommand;
import com.dataiku.gh.cli.DKU;
import com.dataiku.gh.core.services.admin.IMigrationService;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.springframework.transaction.PlatformTransactionManager;

public class InitDBCommand
extends CLICommand {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.cli.govern-init-db");
    public static final String COMMAND_NAME = "init-db";

    @Override
    public String usageString() {
        return COMMAND_NAME;
    }

    @Override
    public String description() {
        return "Init the database with the structure and provided objects needed for Dataiku Govern";
    }

    @Override
    public Options opts() {
        Options options = new Options();
        DKU.addGlobalOptions(options);
        return options;
    }

    @Override
    public int execute(String[] args) throws Exception {
        CommandLine cmdLine = this.parseAndMiniSetup(args, COMMAND_NAME, true);
        GHSpring.doCLISetupWithDB();
        IMigrationService migrationService = (IMigrationService)SpringUtils.getBean(IMigrationService.class);
        PlatformTransactionManager transactionManager = (PlatformTransactionManager)SpringUtils.getBean(PlatformTransactionManager.class);
        migrationService.checkNoneVersion();
        Long version = migrationService.migrateToVersion(Long.parseLong(DKUApp.getDSSVersion().conf_version), transactionManager);
        logger.info((Object)("DB successfully initialized at version " + version));
        return 0;
    }
}

