/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.controllers.admin;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.configuration.DefaultAutoGovernanceConfiguration;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.services.governance.IGovernanceQueueCoordinatorService;
import com.dataiku.gh.core.services.governance.config.IAdminAutoGovernanceConfigurationService;
import com.dataiku.gh.security.auth.UIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AdminAutoGovernanceConfigurationController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private IAdminAutoGovernanceConfigurationService adminAutoGovernanceConfigurationService;
    @Autowired
    private IGovernanceQueueCoordinatorService governanceQueueCoordinatorService;

    @AuditedCall(value={"msgType", "instance-auto-govern-configuration-get"})
    @RequestMapping(value={"/api/admin/autogovernance-config/get"}, method={RequestMethod.GET})
    @ResponseBody
    public DefaultAutoGovernanceConfiguration getInstanceAutogovernConfiguration(HttpServletRequest req) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.adminAutoGovernanceConfigurationService.getInstanceDefaultAutoGovernConfiguration(authCtx);
    }

    @AuditedCall(value={"msgType", "instance-auto-govern-configuration-save"})
    @RequestMapping(value={"/api/admin/autogovernance-config/save"}, method={RequestMethod.PUT})
    @ResponseBody
    @GovernAction(value=ActionType.INSTANCE_AUTOGOVERNANCE_CONFIG_UPDATE)
    public DefaultAutoGovernanceConfiguration upsertAutogovernConfiguration(HttpServletRequest req, @RequestParam DefaultAutoGovernanceConfiguration defaultAutoGovernanceConfiguration) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.adminAutoGovernanceConfigurationService.upsertInstanceDefaultAutoGovernConfiguration(authCtx, defaultAutoGovernanceConfiguration);
    }

    @AuditedCall(value={"msgType", "instance-auto-govern-configuration-trigger-run"})
    @RequestMapping(value={"/api/admin/autogovernance-config/trigger-run"}, method={RequestMethod.POST})
    @ResponseBody
    @GovernAction(value=ActionType.INSTANCE_AUTOGOVERNANCE_TRIGGER)
    public void triggerGovernanceRun(HttpServletRequest req) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        this.governanceQueueCoordinatorService.triggerInstanceGovernanceRun(authCtx);
    }
}

