/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.controllers.admin;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.signoff.SignoffConfiguration;
import com.dataiku.gh.core.models.signoff.SignoffConfigurationId;
import com.dataiku.gh.core.services.signoff.IAdminBlueprintVersionSignoffConfigurationsService;
import com.dataiku.gh.core.utils.ValidatorUtils;
import com.dataiku.gh.security.auth.UIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AdminSignoffConfigurationsController
extends DIPInternalControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private IAdminBlueprintVersionSignoffConfigurationsService adminBlueprintVersionSignoffConfigurationsService;

    @AuditInline
    @RequestMapping(value={"/api/admin/signoff-configurations/create"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.SIGNOFF_CONFIGURATIONS_CREATE)
    @ResponseBody
    public SignoffConfiguration create(HttpServletRequest req, HttpServletResponse resp, @RequestParam BlueprintVersionId blueprintVersionId, @RequestParam String stepId, @RequestParam SignoffConfiguration signoffConfiguration) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            ValidatorUtils.validateThat(signoffConfiguration != null, "signoffConfiguration is mandatory", new Object[0]);
            ValidatorUtils.validateThat(signoffConfiguration.id == null, "signoffConfiguration.id must not be set in creation", new Object[0]);
            signoffConfiguration.id = SignoffConfigurationId.build(blueprintVersionId, stepId);
            SignoffConfiguration createdSignoffConfiguration = this.adminBlueprintVersionSignoffConfigurationsService.createSignoffConfiguration(authCtx, signoffConfiguration);
            this.auditTrailService.generic("signoff-configurations-create").with("blueprintId", blueprintVersionId.blueprintId).with("versionId", blueprintVersionId.versionId).with("stepId", stepId).emit();
            return createdSignoffConfiguration;
        }
        catch (Exception e) {
            this.auditTrailService.failure("signoff-configurations-create", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/signoff-configurations/save"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.SIGNOFF_CONFIGURATIONS_SAVE)
    @ResponseBody
    public SignoffConfiguration save(HttpServletRequest req, HttpServletResponse resp, @RequestParam BlueprintVersionId blueprintVersionId, @RequestParam String stepId, @RequestParam SignoffConfiguration signoffConfiguration) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            ValidatorUtils.validateThat(signoffConfiguration != null, "signoffConfiguration is mandatory", new Object[0]);
            if (signoffConfiguration.id != null) {
                ValidatorUtils.validateThat(signoffConfiguration.id.blueprintVersionId != null, "signoffConfiguration.id.blueprintVersionId is mandatory", new Object[0]);
                ValidatorUtils.validateThat(Objects.equals(signoffConfiguration.id.blueprintVersionId.blueprintId, blueprintVersionId.blueprintId), "blueprintIds in URL and Body don't match", new Object[0]);
                ValidatorUtils.validateThat(Objects.equals(signoffConfiguration.id.blueprintVersionId.versionId, blueprintVersionId.versionId), "versionIds in URL and Body don't match", new Object[0]);
                ValidatorUtils.validateThat(Objects.equals(signoffConfiguration.id.stepId, stepId), "stepIds in URL and Body don't match", new Object[0]);
            } else {
                signoffConfiguration.id = SignoffConfigurationId.build(blueprintVersionId, stepId);
            }
            SignoffConfiguration savedSignoffConfiguration = this.adminBlueprintVersionSignoffConfigurationsService.saveSignoffConfiguration(authCtx, signoffConfiguration);
            this.auditTrailService.generic("signoff-configurations-save").with("blueprintId", blueprintVersionId.blueprintId).with("versionId", blueprintVersionId.versionId).with("stepId", stepId).emit();
            return savedSignoffConfiguration;
        }
        catch (Exception e) {
            this.auditTrailService.failure("signoff-configurations-save", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/signoff-configurations/delete"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.SIGNOFF_CONFIGURATIONS_DELETE)
    @ResponseBody
    public void delete(HttpServletRequest req, HttpServletResponse resp, @RequestParam BlueprintVersionId blueprintVersionId, @RequestParam String stepId) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            this.adminBlueprintVersionSignoffConfigurationsService.deleteSignoffConfiguration(authCtx, SignoffConfigurationId.build(blueprintVersionId, stepId));
            this.auditTrailService.generic("signoff-configurations-delete").with("blueprintId", blueprintVersionId.blueprintId).with("versionId", blueprintVersionId.versionId).with("stepId", stepId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("signoff-configurations-delete", (Throwable)e).emit();
            throw e;
        }
    }
}

