/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.export;

import com.dataiku.dip.files.MimeTypeUtils;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;

public class ExportFile {
    public InputStream data;
    public String fileName;
    public LocalDateTime localDateTime;
    public MimeTypeUtils.MimeType mimeType;
    public static final String HEADER_TYPE = "Type";
    public static final String HEADER_ID = "ID";
    public static final String HEADER_LABEL = "Label";
    public static final String HEADER_VALUE = "Value";
    public static final String HEADER_BLUEPRINT = "Blueprint";
    public static final String HEADER_BLUEPRINT_VERSION = "Blueprint Version";
    public static final DateTimeFormatter CUSTOM_DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral("_").appendPattern("HH-mm-ss").toFormatter().withResolverStyle(ResolverStyle.STRICT);

    public static ExportFile build(InputStream data, String baseName, MimeTypeUtils.MimeType mimeType) {
        ExportFile exportFile = new ExportFile();
        exportFile.data = data;
        exportFile.localDateTime = LocalDateTime.now();
        exportFile.mimeType = mimeType;
        exportFile.fileName = baseName + "_" + exportFile.localDateTime.format(CUSTOM_DATE_TIME_FORMATTER) + "." + exportFile.mimeType.extension;
        return exportFile;
    }
}

