/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.search;

import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.gh.core.models.fields.FieldType;
import com.dataiku.gh.core.models.search.ArtifactFilter;
import com.dataiku.gh.core.models.search.field_condition_types.BooleanConditionType;
import com.dataiku.gh.core.models.search.field_condition_types.DateConditionType;
import com.dataiku.gh.core.models.search.field_condition_types.NumberConditionType;
import com.dataiku.gh.core.models.search.field_condition_types.TextConditionType;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.j2ts.annotations.UINullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;

@PolyJSON(value={@Mapping(value=NumberFieldLogic.class, type="number"), @Mapping(value=TextFieldLogic.class, type="text"), @Mapping(value=ReferenceFieldLogic.class, type="reference"), @Mapping(value=BooleanFieldLogic.class, type="boolean"), @Mapping(value=DateFieldLogic.class, type="date"), @Mapping(value=CategoryFieldLogic.class, type="category"), @Mapping(value=FieldLogicAnd.class, type="and"), @Mapping(value=FieldLogicOr.class, type="or")})
public abstract class FieldLogic {
    @UINullable
    public boolean negateCondition = false;
    @UINullable
    public NumberFieldLogic indexLogic;

    public abstract FieldType getFieldType();

    public abstract void accept(IFieldLogicVisitor var1);

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldLogic that = (FieldLogic)o;
        return this.negateCondition == that.negateCondition && Objects.equals(this.indexLogic, that.indexLogic);
    }

    public int hashCode() {
        return Objects.hash(this.negateCondition, this.indexLogic);
    }

    public String toString() {
        return "FieldLogic{negateCondition=" + this.negateCondition + ", indexLogic=" + String.valueOf(this.indexLogic) + "}";
    }

    public static class NumberFieldLogic
    extends FieldLogic {
        public static final String TYPE = "number";
        public NumberConditionType conditionType;
        public Double condition;

        @Override
        public FieldType getFieldType() {
            return FieldType.NUMBER;
        }

        public static NumberFieldLogic build(NumberConditionType conditionType, Double condition, boolean negateCondition) {
            NumberFieldLogic logic = new NumberFieldLogic();
            logic.conditionType = conditionType;
            logic.condition = condition;
            logic.negateCondition = negateCondition;
            return logic;
        }

        @Override
        public void accept(IFieldLogicVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            NumberFieldLogic that = (NumberFieldLogic)o;
            return this.conditionType == that.conditionType && Objects.equals(this.condition, that.condition);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.conditionType, this.condition});
        }

        @Override
        public String toString() {
            return "NumberFieldLogic{conditionType=" + String.valueOf((Object)this.conditionType) + ", condition=" + this.condition + "} " + super.toString();
        }
    }

    public static interface IFieldLogicVisitor {
        default public void visit(FieldLogicAnd fieldLogicAnd) {
        }

        default public void visit(FieldLogicOr fieldLogicOr) {
        }

        default public void visit(TextFieldLogic textFieldLogic) {
        }

        default public void visit(CategoryFieldLogic categoryFieldLogic) {
        }

        default public void visit(NumberFieldLogic numberFieldLogic) {
        }

        default public void visit(DateFieldLogic dateFieldLogic) {
        }

        default public void visit(ReferenceFieldLogic referenceFieldLogic) {
        }

        default public void visit(BooleanFieldLogic booleanFieldLogic) {
        }
    }

    public static class BooleanFieldLogic
    extends FieldLogic {
        public static final String TYPE = "boolean";
        public BooleanConditionType conditionType;

        @Override
        public FieldType getFieldType() {
            return FieldType.BOOLEAN;
        }

        public static BooleanFieldLogic build(BooleanConditionType conditionType) {
            BooleanFieldLogic logic = new BooleanFieldLogic();
            logic.conditionType = conditionType;
            return logic;
        }

        @Override
        public void accept(IFieldLogicVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BooleanFieldLogic that = (BooleanFieldLogic)o;
            return this.conditionType == that.conditionType;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.conditionType});
        }

        @Override
        public String toString() {
            return "BooleanFieldLogic{conditionType=" + String.valueOf((Object)this.conditionType) + "} " + super.toString();
        }
    }

    public static class ReferenceFieldLogic
    extends FieldLogic {
        public static final String TYPE = "reference";
        public ArtifactFilter artifactFilter;

        @Override
        public FieldType getFieldType() {
            return FieldType.REFERENCE;
        }

        public static ReferenceFieldLogic build(ArtifactFilter artifactFilter) {
            ReferenceFieldLogic logic = new ReferenceFieldLogic();
            logic.artifactFilter = artifactFilter;
            return logic;
        }

        @Override
        public void accept(IFieldLogicVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ReferenceFieldLogic that = (ReferenceFieldLogic)o;
            return Objects.equals(this.artifactFilter, that.artifactFilter);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.artifactFilter);
        }

        @Override
        public String toString() {
            return "ReferenceFieldLogic{artifactFilter=" + String.valueOf(this.artifactFilter) + "} " + super.toString();
        }
    }

    public static class DateFieldLogic
    extends FieldLogic {
        public static final String TYPE = "date";
        public DateConditionType conditionType;
        public String condition;

        @Override
        public FieldType getFieldType() {
            return FieldType.DATE;
        }

        public static DateFieldLogic build(DateConditionType conditionType, String datetime) {
            DateFieldLogic logic = new DateFieldLogic();
            logic.conditionType = conditionType;
            logic.condition = datetime;
            return logic;
        }

        @Override
        public void accept(IFieldLogicVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DateFieldLogic that = (DateFieldLogic)o;
            return this.conditionType == that.conditionType && Objects.equals(this.condition, that.condition);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.conditionType, this.condition});
        }

        @Override
        public String toString() {
            return "DateFieldLogic{conditionType=" + String.valueOf((Object)this.conditionType) + ", condition='" + this.condition + "'} " + super.toString();
        }
    }

    public static class CategoryFieldLogic
    extends FieldLogic {
        public static final String TYPE = "category";
        public List<String> condition;

        @Override
        public FieldType getFieldType() {
            return FieldType.CATEGORY;
        }

        public static CategoryFieldLogic build(List<String> condition) {
            CategoryFieldLogic logic = new CategoryFieldLogic();
            logic.condition = condition;
            return logic;
        }

        @Override
        public void accept(IFieldLogicVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CategoryFieldLogic that = (CategoryFieldLogic)o;
            return Objects.equals(this.condition, that.condition);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.condition);
        }

        @Override
        public String toString() {
            return "CategoryFieldLogic{condition=" + String.valueOf(this.condition) + "} " + super.toString();
        }
    }

    public static class TextFieldLogic
    extends FieldLogic {
        public static final String TYPE = "text";
        public TextConditionType conditionType;
        public String condition;
        @UINullable
        public boolean caseSensitive = false;

        @Override
        public FieldType getFieldType() {
            return FieldType.TEXT;
        }

        public static TextFieldLogic build(TextConditionType conditionType, String condition, boolean caseSensitive) {
            TextFieldLogic logic = new TextFieldLogic();
            logic.conditionType = conditionType;
            logic.condition = condition;
            logic.caseSensitive = caseSensitive;
            return logic;
        }

        @Override
        public void accept(IFieldLogicVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TextFieldLogic that = (TextFieldLogic)o;
            return this.caseSensitive == that.caseSensitive && this.conditionType == that.conditionType && Objects.equals(this.condition, that.condition);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.conditionType, this.condition, this.caseSensitive});
        }

        @Override
        public String toString() {
            return "TextFieldLogic{conditionType=" + String.valueOf((Object)this.conditionType) + ", condition='" + this.condition + "', caseSensitive=" + this.caseSensitive + "} " + super.toString();
        }
    }

    public static class FieldLogicAnd
    extends FieldLogicCombinator {
        public static final String TYPE = "and";

        public static FieldLogicAnd build(List<FieldLogic> logics) {
            FieldLogicAnd combinator = new FieldLogicAnd();
            combinator.logics = logics;
            return combinator;
        }

        @Override
        public void accept(IFieldLogicVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public String toString() {
            return "FieldLogicAnd{} " + super.toString();
        }
    }

    public static class FieldLogicOr
    extends FieldLogicCombinator {
        public static final String TYPE = "or";

        public static FieldLogicOr build(List<FieldLogic> logics) {
            FieldLogicOr combinator = new FieldLogicOr();
            combinator.logics = logics;
            return combinator;
        }

        @Override
        public void accept(IFieldLogicVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public String toString() {
            return "FieldLogicOr{} " + super.toString();
        }
    }

    public static abstract class FieldLogicCombinator
    extends FieldLogic {
        public List<FieldLogic> logics = new ArrayList<FieldLogic>();

        @Override
        public FieldType getFieldType() {
            if (CollectionUtils.isEmpty(this.logics)) {
                throw new ValidationException("Logics shouldn't be empty");
            }
            return this.logics.get(0).getFieldType();
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FieldLogicCombinator that = (FieldLogicCombinator)o;
            return Objects.equals(this.logics, that.logics);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.logics);
        }

        @Override
        public String toString() {
            return "FieldLogicCombinator{logics=" + String.valueOf(this.logics) + "} " + super.toString();
        }
    }
}

