/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.ui;

import com.dataiku.common.server.APIError;
import com.dataiku.gh.core.models.ui.UIArtifactAtTimestamp;
import com.dataiku.gh.core.models.ui.UIArtifactAtTimestampException;
import com.dataiku.gh.core.utils.Either;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.List;
import java.util.stream.Collectors;

@UIModel
public class UIGetArtifactsAtTimestampResult {
    public final List<UIArtifactAtTimestamp> uiArtifactsAtTimestamp;
    public final List<ArtifactAtTimestampAPIError> errors;

    private UIGetArtifactsAtTimestampResult(List<UIArtifactAtTimestamp> uiArtifactsAtTimestamp, List<ArtifactAtTimestampAPIError> errors) {
        this.uiArtifactsAtTimestamp = uiArtifactsAtTimestamp;
        this.errors = errors;
    }

    public static <E extends Exception> UIGetArtifactsAtTimestampResult build(List<Either<UIArtifactAtTimestampException, UIArtifactAtTimestamp>> artifactsOrExceptions) {
        List<UIArtifactAtTimestamp> uiArtifacts = artifactsOrExceptions.stream().filter(Either::isRight).map(Either::getRight).collect(Collectors.toList());
        List<ArtifactAtTimestampAPIError> errors = artifactsOrExceptions.stream().filter(Either::isLeft).map(item -> ArtifactAtTimestampAPIError.build((UIArtifactAtTimestampException)item.getLeft())).collect(Collectors.toList());
        return new UIGetArtifactsAtTimestampResult(uiArtifacts, errors);
    }

    public static class ArtifactAtTimestampAPIError {
        public final String artifactId;
        public final long timestamp;
        public final APIError error;

        private ArtifactAtTimestampAPIError(String artifactId, long timestamp, Exception exception) {
            this.artifactId = artifactId;
            this.timestamp = timestamp;
            this.error = new APIError((Throwable)exception, false);
        }

        public static ArtifactAtTimestampAPIError build(UIArtifactAtTimestampException uiArtifactException) {
            return new ArtifactAtTimestampAPIError(uiArtifactException.artifactId, uiArtifactException.timestamp, uiArtifactException.exception);
        }
    }
}

