/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.publicapi;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.artifacts.ArtifactDescription;
import com.dataiku.gh.core.models.export.ExportFile;
import com.dataiku.gh.core.models.export.ExportType;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.search.ArtifactSearchQuery;
import com.dataiku.gh.core.models.ui.UIArtifact;
import com.dataiku.gh.core.models.ui.UIArtifactSearchResults;
import com.dataiku.gh.core.services.artifacts.IArtifactsService;
import com.dataiku.gh.core.services.export.IExportService;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.security.auth.MetaAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PublicAPIArtifactsController
extends PublicAPIControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IArtifactsService artifactsService;
    @Autowired
    private IExportService exportService;

    @AuditInline
    @RequestMapping(value={"/publicapi/artifacts"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.ARTIFACT_CREATE)
    @ResponseBody
    public ArtifactDescription create(HttpServletRequest req) throws Exception {
        try {
            Artifact inputArtifact = (Artifact)this.getRequestBodyAs(req, Artifact.class);
            AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
            ArtifactDescription artifactDescription = this.artifactsService.createArtifact(authCtx, inputArtifact);
            this.auditTrailService.generic("artifact-create").with("artifactId", artifactDescription.artifactId).emit();
            return artifactDescription;
        }
        catch (Exception e) {
            this.auditTrailService.failure("artifact-create", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "artifact-get", "artifactId", "${artifactId}"})
    @RequestMapping(value={"/publicapi/artifact/{artifactId}"}, method={RequestMethod.GET})
    @ResponseBody
    public UIArtifact get(HttpServletRequest req, @PathVariable String artifactId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        return this.artifactsService.getArtifact(authCtx, artifactId);
    }

    @AuditedCall(value={"msgType", "artifact-export", "artifactId", "${artifactId}", "exportType", "${exportType}"})
    @RequestMapping(value={"/publicapi/artifact/{artifactId}/export"}, method={RequestMethod.GET})
    public void export(HttpServletRequest req, HttpServletResponse resp, @PathVariable String artifactId, @RequestParam ExportType exportType) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        ExportFile file = this.exportService.exportArtifact(authCtx, artifactId, exportType);
        this.writeStream(resp, file.data, file.mimeType.mimeType, file.fileName);
    }

    @AuditedCall(value={"msgType", "artifact-save", "artifactId", "${artifactId}"})
    @RequestMapping(value={"/publicapi/artifact/{artifactId}"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.ARTIFACT_SAVE)
    @ResponseBody
    public UIArtifact save(HttpServletRequest req, @PathVariable String artifactId) throws Exception {
        Artifact inputArtifact = (Artifact)this.getRequestBodyAs(req, Artifact.class);
        if (!StringUtils.equals((CharSequence)artifactId, (CharSequence)inputArtifact.id)) {
            throw new ValidationException("Artifact IDs do not match: " + artifactId + " , " + inputArtifact.id);
        }
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        return this.artifactsService.saveArtifact(authCtx, inputArtifact);
    }

    @AuditedCall(value={"msgType", "artifact-delete", "artifactId", "${artifactId}"})
    @RequestMapping(value={"/publicapi/artifact/{artifactId}"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.ARTIFACT_DELETE)
    @ResponseBody
    public void delete(HttpServletRequest req, @PathVariable String artifactId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        this.artifactsService.deleteArtifact(authCtx, artifactId);
    }

    @AuditedCall(value={"msgType", "artifacts-search"})
    @RequestMapping(value={"/publicapi/artifacts/search"}, method={RequestMethod.POST})
    @ResponseBody
    public UIArtifactSearchResults search(HttpServletRequest req) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        ArtifactSearchQuery artifactSearchQuery = (ArtifactSearchQuery)this.getRequestBodyAs(req, ArtifactSearchQuery.class);
        return this.artifactsService.search(authCtx, artifactSearchQuery);
    }
}

