/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.artifacts;

import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.fields.definitions.types.json.StoredJsonFieldDefinition;
import com.dataiku.gh.core.visitors.IEnrichedArtifactVisitor;
import com.dataiku.gh.core.visitors.IFieldAndListValueVisitor;
import com.google.gson.JsonElement;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ArtifactPatcher
implements IEnrichedArtifactVisitor {
    private final EnrichedArtifact enrichedArtifact;

    public ArtifactPatcher(EnrichedArtifact enrichedArtifact) {
        this.enrichedArtifact = enrichedArtifact;
    }

    @Override
    public void visit(StoredJsonFieldDefinition fieldDefinition, String fieldId) {
        Object fieldValue = this.enrichedArtifact.artifact.fields.get(fieldId);
        new FieldPatcher(){

            @Override
            public void visit(Map<String, Object> fieldValue) {
                String jsonValue = (String)fieldValue.get("value");
                if (StringUtils.isNotBlank((String)jsonValue)) {
                    String cleanedJsonValue = JSON.json((Object)JSON.parse((String)jsonValue, JsonElement.class));
                    fieldValue.put("value", cleanedJsonValue);
                } else {
                    fieldValue.put("value", "");
                }
            }
        }.visit(fieldValue);
    }

    private static class FieldPatcher
    implements IFieldAndListValueVisitor {
        private FieldPatcher() {
        }
    }
}

