/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.artifacts;

import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.annotations.VisibleForTesting;
import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.artifacts.ArtifactWorkflow;
import com.dataiku.gh.core.models.artifacts.ArtifactWorkflowStep;
import com.dataiku.gh.core.models.blueprints.StepDefinition;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.enriched.EnrichedArtifactWithoutPermissions;
import com.dataiku.gh.core.models.search.ArtifactFilter;
import com.dataiku.gh.core.models.search.ArtifactFilterArtifactVisitor;
import com.dataiku.gh.core.services.artifacts.IArtifactWorkflowService;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArtifactWorkflowService
implements IArtifactWorkflowService {
    @VisibleForTesting
    protected static Logger logger = Logger.getLogger((String)"gh.services.artifact.workflow");
    @Autowired
    private IArtifactsDataService artifactsDataService;

    @Override
    public List<StepDefinition> visibleStepsWithBlockingSignoffs(EnrichedArtifactWithoutPermissions enrichedArtifact) {
        Set<String> visibleStepIds = this.computeVisibleArtifactWorkflowStepIds(enrichedArtifact);
        return enrichedArtifact.blueprintVersion.workflowDefinition.stepDefinitions.stream().filter(stepDefinition -> visibleStepIds.contains(stepDefinition.id) && enrichedArtifact.signoffs.stream().anyMatch(signoff -> signoff.signoffId.stepId.equals(stepDefinition.id) && signoff.isBlocking())).collect(Collectors.toList());
    }

    @Override
    public List<StepDefinition> computeVisibleArtifactWorkflowSteps(EnrichedArtifactWithoutPermissions enrichedArtifact) {
        return enrichedArtifact.blueprintVersion.workflowDefinition.stepDefinitions.stream().filter(sd -> sd.visibilityCondition == null || this.artifactMatchesArtifactFilter(enrichedArtifact, sd.visibilityCondition)).collect(Collectors.toList());
    }

    @Override
    public Set<String> computeVisibleArtifactWorkflowStepIds(EnrichedArtifactWithoutPermissions enrichedArtifactWithoutPermissions) {
        return this.computeVisibleArtifactWorkflowSteps(enrichedArtifactWithoutPermissions).stream().map(sd -> sd.id).collect(Collectors.toSet());
    }

    @Override
    public boolean artifactMatchesArtifactFilter(EnrichedArtifactWithoutPermissions enrichedArtifact, ArtifactFilter artifactFilter) {
        ArtifactFilterArtifactVisitor filterArtifactVisitor = new ArtifactFilterArtifactVisitor(enrichedArtifact, this.artifactsDataService);
        artifactFilter.getQueryableArtifactFilter().accept(filterArtifactVisitor);
        return filterArtifactVisitor.artifactMatches;
    }

    @Override
    public ArtifactWorkflow initializeWorkflow(EnrichedArtifactWithoutPermissions newEnrichedArtifact) {
        return this.prepareWorkflowForSavingWithStepIdAndWorkflow(null, newEnrichedArtifact, false);
    }

    @Override
    public ArtifactWorkflow resetWorkflow(EnrichedArtifactWithoutPermissions newEnrichedArtifact) {
        Set<String> visibleStepIds = this.computeVisibleArtifactWorkflowStepIds(newEnrichedArtifact);
        ArtifactWorkflow artifactWorkflow = new ArtifactWorkflow();
        for (StepDefinition stepDefinition : newEnrichedArtifact.blueprintVersion.workflowDefinition.stepDefinitions) {
            artifactWorkflow.steps.put(stepDefinition.id, ArtifactWorkflowStep.build(ArtifactWorkflowStep.StepStatus.NOT_STARTED, visibleStepIds.contains(stepDefinition.id)));
        }
        return artifactWorkflow;
    }

    @Override
    public ArtifactWorkflow prepareWorkflowForSaving(EnrichedArtifactWithoutPermissions existingEnrichedArtifact, Artifact inputArtifact, boolean forSave) {
        EnrichedArtifact newEnrichedArtifact = EnrichedArtifact.build(existingEnrichedArtifact.blueprint, existingEnrichedArtifact.blueprintVersion, existingEnrichedArtifact.blueprintVersionTrace, null, null, null, inputArtifact, existingEnrichedArtifact.signoffs, existingEnrichedArtifact.enrichedArtifactDetails);
        if (forSave) {
            return this.prepareWorkflowForSavingWithStepIdAndWorkflow(existingEnrichedArtifact, newEnrichedArtifact, false);
        }
        boolean workflowUpdated = !ArtifactWorkflow.stepStatusesAreEqual(existingEnrichedArtifact.artifact.workflow, newEnrichedArtifact.artifact.workflow);
        return this.prepareWorkflowForSavingStepByStep(existingEnrichedArtifact, newEnrichedArtifact, workflowUpdated);
    }

    private ArtifactWorkflow prepareWorkflowForSavingStepByStep(@Nullable EnrichedArtifactWithoutPermissions existingEnrichedArtifact, EnrichedArtifactWithoutPermissions newEnrichedArtifact, boolean autoAdvance) {
        Set<String> visibleStepIds = this.computeVisibleArtifactWorkflowStepIds(newEnrichedArtifact);
        ArtifactWorkflow inputWorkflow = newEnrichedArtifact.artifact.workflow;
        ArtifactWorkflow outputWorkflow = new ArtifactWorkflow();
        boolean fillWithNotStartedSteps = false;
        for (StepDefinition stepDefinition : newEnrichedArtifact.blueprintVersion.workflowDefinition.stepDefinitions) {
            boolean stepIsVisible = visibleStepIds.contains(stepDefinition.id);
            if (fillWithNotStartedSteps) {
                outputWorkflow.steps.put(stepDefinition.id, ArtifactWorkflowStep.build(ArtifactWorkflowStep.StepStatus.NOT_STARTED, stepIsVisible));
                continue;
            }
            ArtifactWorkflowStep inputStep = inputWorkflow.steps.get(stepDefinition.id);
            if (inputStep == null || inputStep.isNotStarted()) {
                outputWorkflow.steps.put(stepDefinition.id, ArtifactWorkflowStep.build(ArtifactWorkflowStep.StepStatus.NOT_STARTED, stepIsVisible));
                fillWithNotStartedSteps = true;
                continue;
            }
            if (inputStep.isOngoing()) {
                outputWorkflow.steps.put(stepDefinition.id, ArtifactWorkflowStep.build(ArtifactWorkflowStep.StepStatus.ONGOING, stepIsVisible));
                fillWithNotStartedSteps = true;
                continue;
            }
            if (inputStep.isSkipped()) {
                if (stepIsVisible && (existingEnrichedArtifact == null || existingEnrichedArtifact.artifact.workflow.steps.containsKey(stepDefinition.id) && existingEnrichedArtifact.artifact.workflow.steps.get((Object)stepDefinition.id).status != ArtifactWorkflowStep.StepStatus.SKIPPED)) {
                    outputWorkflow.steps.put(stepDefinition.id, ArtifactWorkflowStep.build(ArtifactWorkflowStep.StepStatus.FINISHED, true));
                } else {
                    outputWorkflow.steps.put(stepDefinition.id, ArtifactWorkflowStep.build(ArtifactWorkflowStep.StepStatus.SKIPPED, stepIsVisible));
                }
            }
            if (!inputStep.isFinished()) continue;
            outputWorkflow.steps.put(stepDefinition.id, ArtifactWorkflowStep.build(ArtifactWorkflowStep.StepStatus.FINISHED, stepIsVisible));
        }
        if (autoAdvance && existingEnrichedArtifact != null) {
            ArtifactWorkflow advancedWorkflow = this.autoAdvanceWorkflow(outputWorkflow, existingEnrichedArtifact.blueprintVersion.workflowDefinition.stepDefinitions);
            if (!outputWorkflow.equals(advancedWorkflow)) {
                EnrichedArtifactWithoutPermissions newEnrichedArtifactCopy = (EnrichedArtifactWithoutPermissions)JSON.deepCopy((Object)newEnrichedArtifact);
                newEnrichedArtifactCopy.artifact.workflow = advancedWorkflow;
                return this.prepareWorkflowForSavingStepByStep(newEnrichedArtifact, newEnrichedArtifactCopy, false);
            }
            return advancedWorkflow;
        }
        return outputWorkflow;
    }

    @VisibleForTesting
    protected ArtifactWorkflow prepareWorkflowForSavingWithStepIdAndWorkflow(@Nullable EnrichedArtifactWithoutPermissions existingEnrichedArtifact, EnrichedArtifactWithoutPermissions newEnrichedArtifact, boolean autoAdvance) {
        boolean stepIdUpdated;
        ArtifactWorkflow existingWorkflow = null;
        String existingStepId = null;
        if (existingEnrichedArtifact != null) {
            existingWorkflow = existingEnrichedArtifact.artifact.workflow;
            existingStepId = existingEnrichedArtifact.artifact.status.stepId;
        }
        ArtifactWorkflow inputWorkflow = newEnrichedArtifact.artifact.workflow;
        String inputStepId = newEnrichedArtifact.artifact.status.stepId;
        boolean workflowMissing = !newEnrichedArtifact.blueprintVersion.workflowDefinition.stepDefinitions.isEmpty() && inputWorkflow.steps.isEmpty();
        boolean workflowStatusUpdated = !ArtifactWorkflow.stepStatusesAreEqual(existingWorkflow, inputWorkflow);
        boolean bl = stepIdUpdated = !Objects.equals(existingStepId, inputStepId);
        if (stepIdUpdated && !workflowStatusUpdated || workflowMissing) {
            if (workflowMissing) {
                logger.warn((Object)"A workflow is required, but is missing. Computing status using legacy artifact.status.stepId.");
            } else {
                logger.warn((Object)"A legacy artifact.status.stepId has been updated, but workflow updates should use artifact.workflow.");
            }
            return this.getArtifactWorkflowFromInputStepId(existingEnrichedArtifact, newEnrichedArtifact);
        }
        if (workflowStatusUpdated && stepIdUpdated) {
            logger.warn((Object)"Both legacy artifact.status.stepId and artifact.workflow have been updated. Considering only artifact.workflow update. On future releases, only artifact.workflow will be supported.");
        }
        return this.prepareWorkflowForSavingStepByStep(existingEnrichedArtifact, newEnrichedArtifact, autoAdvance);
    }

    @VisibleForTesting
    protected ArtifactWorkflow autoAdvanceWorkflow(ArtifactWorkflow artifactWorkflow, List<StepDefinition> stepDefinitions) {
        ArtifactWorkflow artifactWorkflowCopy = (ArtifactWorkflow)JSON.deepCopy((Object)artifactWorkflow);
        if (artifactWorkflow.isStarted() && !artifactWorkflow.hasOnGoingStep()) {
            for (StepDefinition stepDefinition : stepDefinitions) {
                ArtifactWorkflowStep artifactWorkflowStep = artifactWorkflow.steps.get(stepDefinition.id);
                if (artifactWorkflowStep == null || !artifactWorkflowStep.isNotStarted()) continue;
                if (artifactWorkflowStep.visible.booleanValue()) {
                    artifactWorkflowCopy.steps.get((Object)stepDefinition.id).status = ArtifactWorkflowStep.StepStatus.ONGOING;
                    return artifactWorkflowCopy;
                }
                artifactWorkflowCopy.steps.get((Object)stepDefinition.id).status = ArtifactWorkflowStep.StepStatus.SKIPPED;
            }
        }
        return artifactWorkflow;
    }

    @Override
    public ArtifactWorkflow getArtifactWorkflowFromInputStepId(@Nullable EnrichedArtifactWithoutPermissions existingEnrichedArtifact, EnrichedArtifactWithoutPermissions newEnrichedArtifact) {
        ArtifactWorkflow outputWorkflow = new ArtifactWorkflow();
        String inputStepId = newEnrichedArtifact.artifact.status.stepId;
        Set<String> visibleStepIds = this.computeVisibleArtifactWorkflowStepIds(newEnrichedArtifact);
        boolean fillWithNotStartedSteps = inputStepId == null;
        for (StepDefinition stepDefinition : newEnrichedArtifact.blueprintVersion.workflowDefinition.stepDefinitions) {
            boolean stepIdVisible = visibleStepIds.contains(stepDefinition.id);
            if (fillWithNotStartedSteps) {
                outputWorkflow.steps.put(stepDefinition.id, ArtifactWorkflowStep.build(ArtifactWorkflowStep.StepStatus.NOT_STARTED, stepIdVisible));
                continue;
            }
            if (stepDefinition.id.equals(inputStepId)) {
                outputWorkflow.steps.put(inputStepId, ArtifactWorkflowStep.build(ArtifactWorkflowStep.StepStatus.ONGOING, stepIdVisible));
                fillWithNotStartedSteps = true;
                continue;
            }
            ArtifactWorkflowStep formerArtifactWorkflowStep = null;
            if (existingEnrichedArtifact != null) {
                formerArtifactWorkflowStep = existingEnrichedArtifact.artifact.workflow.steps.get(stepDefinition.id);
            }
            if (stepIdVisible) {
                if (formerArtifactWorkflowStep != null && formerArtifactWorkflowStep.isSkipped()) {
                    outputWorkflow.steps.put(stepDefinition.id, ArtifactWorkflowStep.build(ArtifactWorkflowStep.StepStatus.SKIPPED, true));
                    continue;
                }
                outputWorkflow.steps.put(stepDefinition.id, ArtifactWorkflowStep.build(ArtifactWorkflowStep.StepStatus.FINISHED, true));
                continue;
            }
            if (formerArtifactWorkflowStep != null && formerArtifactWorkflowStep.isFinished()) {
                outputWorkflow.steps.put(stepDefinition.id, ArtifactWorkflowStep.build(ArtifactWorkflowStep.StepStatus.FINISHED, false));
                continue;
            }
            outputWorkflow.steps.put(stepDefinition.id, ArtifactWorkflowStep.build(ArtifactWorkflowStep.StepStatus.SKIPPED, false));
        }
        return outputWorkflow;
    }
}

