/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.blueprints;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionStatus;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprint;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.models.roles.AssignedRolesAndPermissionsCtx;
import com.dataiku.gh.core.models.ui.UIBlueprint;
import com.dataiku.gh.core.models.ui.UIBlueprintVersion;
import com.dataiku.gh.core.services.blueprints.IBlueprintsDataService;
import com.dataiku.gh.core.services.blueprints.IBlueprintsService;
import com.dataiku.gh.core.services.mappers.IUIModelsMapperService;
import com.dataiku.gh.core.services.roles_and_permissions.ICheckPermissionsService;
import com.dataiku.gh.core.services.roles_and_permissions.IRolesAndPermissionsService;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.security.PermissionsService;
import com.dataiku.gh.server.services.licensing.LicenseEnforcementService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BlueprintsService
implements IBlueprintsService {
    @Autowired
    private IBlueprintsDataService blueprintsDataService;
    @Autowired
    private IRolesAndPermissionsService rolesAndPermissionsService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private IUIModelsMapperService uiModelsMapperService;
    @Autowired
    private ICheckPermissionsService checkPermissionsService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;

    @Override
    @GHReadonlyTransaction
    public UIBlueprint getBlueprint(AuthCtx authCtx, String blueprintId) throws IOException, DKUSecurityException {
        return this.checkBlueprintReadPermissionsAndMapToUIBlueprint(authCtx, this.blueprintsDataService.getBlueprint(blueprintId));
    }

    @Override
    @GHReadonlyTransaction
    public List<UIBlueprint> listBlueprints(AuthCtx authCtx) throws IOException, DKUSecurityException {
        this.licenseEnforcementService.checkReadGovernAllowed(authCtx);
        return this.mapToUIBlueprints_NoLicenseCheck(authCtx, this.blueprintsDataService.listBlueprints());
    }

    @Override
    @GHWriteTransaction
    public UIBlueprintVersion getBlueprintVersion(AuthCtx authCtx, BlueprintVersionId blueprintVersionId) throws IOException, DKUSecurityException {
        return this.checkBlueprintVersionReadPermissionsAndMapToUIBlueprintVersion(authCtx, blueprintVersionId);
    }

    @Override
    @GHReadonlyTransaction
    public List<UIBlueprintVersion> listBlueprintVersions(AuthCtx authCtx) throws IOException, DKUSecurityException {
        this.licenseEnforcementService.checkReadGovernAllowed(authCtx);
        return this.mapToUIBlueprintVersions_NoLicenseCheck(authCtx, this.blueprintsDataService.listBlueprintVersions());
    }

    @Override
    @GHReadonlyTransaction
    public List<UIBlueprintVersion> listBlueprintVersionsByBlueprint(AuthCtx authCtx, String blueprintId) throws IOException, DKUSecurityException {
        this.licenseEnforcementService.checkReadGovernAllowed(authCtx);
        return this.mapToUIBlueprintVersions_NoLicenseCheck(authCtx, this.blueprintsDataService.listBlueprintVersionsByBlueprint(blueprintId));
    }

    private UIBlueprint checkBlueprintReadPermissionsAndMapToUIBlueprint(AuthCtx authCtx, EnrichedBlueprint enrichedBlueprint) throws IOException, DKUSecurityException {
        AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtBlueprintLevel(authCtx, enrichedBlueprint);
        return this.uiModelsMapperService.checkReadAndMapEnrichedBlueprintToUIBlueprint(assignedRolesAndPermissionsCtx, enrichedBlueprint);
    }

    private List<UIBlueprint> mapToUIBlueprints_NoLicenseCheck(AuthCtx authCtx, List<EnrichedBlueprint> enrichedBlueprints) throws IOException, DKUSecurityException {
        ArrayList<UIBlueprint> uiBlueprints = new ArrayList<UIBlueprint>();
        for (EnrichedBlueprint enrichedBlueprint : enrichedBlueprints) {
            AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtBlueprintLevel(authCtx, enrichedBlueprint);
            if (!this.checkPermissionsService.hasArtifactReadPermission_NoLicenseCheck(assignedRolesAndPermissionsCtx.effectivePermissionsItem)) continue;
            uiBlueprints.add(this.uiModelsMapperService.checkReadAndMapEnrichedBlueprintToUIBlueprint(assignedRolesAndPermissionsCtx, enrichedBlueprint));
        }
        return uiBlueprints;
    }

    private UIBlueprintVersion checkBlueprintVersionReadPermissionsAndMapToUIBlueprintVersion(AuthCtx authCtx, BlueprintVersionId blueprintVersionId) throws DKUSecurityException, IOException {
        if (blueprintVersionId == null) {
            throw new ValidationException("blueprintVersion.id is required");
        }
        if (StringUtils.isBlank((CharSequence)blueprintVersionId.blueprintId)) {
            throw new ValidationException("blueprintVersion.id.blueprintId is required");
        }
        if (StringUtils.isBlank((CharSequence)blueprintVersionId.versionId)) {
            throw new ValidationException("blueprintVersion.id.versionId is required");
        }
        EnrichedBlueprintVersion enrichedBlueprintVersion = this.blueprintsDataService.getBlueprintVersion(blueprintVersionId);
        AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtBlueprintVersionLevel(authCtx, enrichedBlueprintVersion);
        return this.uiModelsMapperService.checkReadAndMapEnrichedBlueprintVersionToUIBlueprintVersion(this.permissionsService.mayManageGovern(authCtx), assignedRolesAndPermissionsCtx, enrichedBlueprintVersion);
    }

    private List<UIBlueprintVersion> mapToUIBlueprintVersions_NoLicenseCheck(AuthCtx authCtx, List<EnrichedBlueprintVersion> enrichedBlueprintVersions) throws IOException, DKUSecurityException {
        ArrayList<UIBlueprintVersion> uiBlueprintVersions = new ArrayList<UIBlueprintVersion>();
        for (EnrichedBlueprintVersion enrichedBlueprintVersion : enrichedBlueprintVersions) {
            if (enrichedBlueprintVersion.blueprintVersionTrace.status == BlueprintVersionStatus.DRAFT) continue;
            AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtBlueprintVersionLevel(authCtx, enrichedBlueprintVersion);
            if (!this.checkPermissionsService.hasArtifactReadPermission_NoLicenseCheck(assignedRolesAndPermissionsCtx.effectivePermissionsItem)) continue;
            uiBlueprintVersions.add(this.uiModelsMapperService.checkReadAndMapEnrichedBlueprintVersionToUIBlueprintVersion(this.permissionsService.mayManageGovern(authCtx), assignedRolesAndPermissionsCtx, enrichedBlueprintVersion));
        }
        return uiBlueprintVersions;
    }
}

