/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.migration_paths;

import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.migration_paths.BlueprintVersionMigrationPath;
import com.dataiku.gh.core.models.migration_paths.BlueprintVersionMigrationPathStatus;
import com.dataiku.gh.core.services.migration_paths.IBlueprintVersionMigrationPathsDataService;
import com.dataiku.gh.core.services.utils.GHMandatoryTransaction;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.migration_paths.IBlueprintVersionMigrationPathDAO;
import com.dataiku.gh.core.utils.ValidatorUtils;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BlueprintVersionMigrationPathsDataService
implements IBlueprintVersionMigrationPathsDataService {
    @Autowired
    private IBlueprintVersionMigrationPathDAO blueprintVersionMigrationPathDAO;

    @Override
    @GHMandatoryTransaction
    public BlueprintVersionMigrationPath getBlueprintVersionMigrationPath(String migrationPathId) throws IOException {
        return (BlueprintVersionMigrationPath)this.blueprintVersionMigrationPathDAO.getMandatory(migrationPathId);
    }

    @Override
    @GHMandatoryTransaction
    public List<BlueprintVersionMigrationPath> listBlueprintVersionMigrationPaths() throws IOException {
        return this.blueprintVersionMigrationPathDAO.list();
    }

    @Override
    @GHMandatoryTransaction
    public List<BlueprintVersionMigrationPath> listBlueprintVersionMigrationPathsByRelatedBlueprintVersionSource(BlueprintVersionId blueprintVersionIdSource) throws IOException {
        return this.blueprintVersionMigrationPathDAO.listByRelatedBlueprintVersionSource(blueprintVersionIdSource);
    }

    @Override
    @GHMandatoryTransaction
    public List<BlueprintVersionMigrationPath> listBlueprintVersionMigrationPathsByRelatedBlueprintVersion(BlueprintVersionId blueprintVersionId) throws IOException {
        return this.blueprintVersionMigrationPathDAO.listByRelatedBlueprintVersion(blueprintVersionId);
    }

    @Override
    @GHMandatoryTransaction
    public List<BlueprintVersionMigrationPath> listBlueprintVersionMigrationPathsByRelatedBlueprint(String blueprint) throws IOException {
        return this.blueprintVersionMigrationPathDAO.listByRelatedBlueprint(blueprint);
    }

    @Override
    @GHMandatoryTransaction
    public BlueprintVersionMigrationPath saveBlueprintVersionMigrationPath(BlueprintVersionMigrationPath blueprintVersionMigrationPath, boolean dangerZoneAccepted) throws IOException {
        this.checkDangerZone(blueprintVersionMigrationPath.id, dangerZoneAccepted);
        this.blueprintVersionMigrationPathDAO.save(blueprintVersionMigrationPath);
        return (BlueprintVersionMigrationPath)this.blueprintVersionMigrationPathDAO.getMandatory(blueprintVersionMigrationPath.id);
    }

    @Override
    @GHMandatoryTransaction
    public BlueprintVersionMigrationPath createBlueprintVersionMigrationPath(BlueprintVersionMigrationPath blueprintVersionMigrationPath) throws IOException {
        this.blueprintVersionMigrationPathDAO.create(blueprintVersionMigrationPath);
        return (BlueprintVersionMigrationPath)this.blueprintVersionMigrationPathDAO.getMandatory(blueprintVersionMigrationPath.id);
    }

    @Override
    @GHMandatoryTransaction
    public void deleteBlueprintVersionMigrationPath(String migrationPathId) throws IOException {
        this.blueprintVersionMigrationPathDAO.delete(migrationPathId);
    }

    @Override
    @GHMandatoryTransaction
    public BlueprintVersionMigrationPath updateBlueprintVersionMigrationPathStatus(String blueprintVersionMigrationPathId, BlueprintVersionMigrationPathStatus migrationPathStatus) throws IOException {
        BlueprintVersionMigrationPath migration = (BlueprintVersionMigrationPath)this.blueprintVersionMigrationPathDAO.getMandatory(blueprintVersionMigrationPathId);
        ValidatorUtils.validateThat(!Objects.equals((Object)migrationPathStatus, (Object)BlueprintVersionMigrationPathStatus.DRAFT), "Cannot set a migration status back to draft", new Object[0]);
        migration.status = migrationPathStatus;
        this.blueprintVersionMigrationPathDAO.save(migration);
        return (BlueprintVersionMigrationPath)this.blueprintVersionMigrationPathDAO.getMandatory(migration.id);
    }

    private void checkDangerZone(String migrationPathId, boolean dangerZoneAccepted) throws IOException {
        if (!dangerZoneAccepted && this.isMigrationIsActive(migrationPathId)) {
            throw new ValidationException("This blueprint version migration path with ID `" + migrationPathId + "` is active");
        }
    }

    private boolean isMigrationIsActive(String migrationPathId) throws IOException {
        return Objects.equals((Object)((BlueprintVersionMigrationPath)this.blueprintVersionMigrationPathDAO.getMandatory(migrationPathId)).status, (Object)BlueprintVersionMigrationPathStatus.ACTIVE);
    }
}

